/*
 * Decompiled with CFR 0.152.
 */
package org.minimallycorrect.javatransformer.api;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.jetbrains.annotations.Nullable;
import org.minimallycorrect.javatransformer.api.TransformationException;
import org.minimallycorrect.javatransformer.internal.ResolutionContext;
import org.minimallycorrect.javatransformer.internal.util.CollectionUtil;
import org.minimallycorrect.javatransformer.internal.util.JVMUtil;
import org.minimallycorrect.javatransformer.internal.util.Joiner;
import org.minimallycorrect.javatransformer.internal.util.Splitter;
import org.minimallycorrect.javatransformer.internal.util.TypeUtil;

public class Type {
    public static final Type UNKNOWN = new Type("Ljava/lang/Object;", "Tunknown;");
    public static final Type OBJECT = Type.of("java.lang.Object");
    @NonNull
    public final String descriptor;
    @Nullable
    public final String signature;

    public Type(String descriptor, @Nullable String signature) {
        if (descriptor.isEmpty()) {
            throw new IllegalArgumentException("descriptor");
        }
        if (signature != null && (signature.isEmpty() || signature.equals(descriptor))) {
            signature = null;
        }
        Type.checkDescriptor(descriptor);
        Type.checkSignature(signature);
        this.descriptor = descriptor;
        this.signature = signature;
    }

    public Type(String descriptor) {
        this(descriptor, null);
    }

    private static void checkDescriptor(String descriptor) {
        if (descriptor.charAt(0) == 'T') {
            throw new TransformationException("Invalid descriptor '" + descriptor + "'");
        }
    }

    private static void checkSignature(@Nullable String signature) {
        if (signature == null) {
            return;
        }
        int lastBracket = signature.lastIndexOf(62);
        if (lastBracket == -1) {
            return;
        }
        char after = signature.charAt(lastBracket + 1);
        if (after != ';' && after != '>') {
            throw new TransformationException("Invalid signature '" + signature + "'. After generic bracket should either be '>' or ';'");
        }
    }

    public static Type of(String fullClassName) {
        String realType = ResolutionContext.extractReal(fullClassName);
        Type type = new Type('L' + JVMUtil.classNameToJLSName(realType) + ';');
        String genericType = ResolutionContext.extractGeneric(fullClassName);
        if (genericType == null) {
            return type;
        }
        return type.withTypeArguments(CollectionUtil.stream(Splitter.commaSplitter.splitIterable(genericType)).map(Type::of).collect(Collectors.toList()));
    }

    public static List<Type> listOf(String desc, @Nullable String signature) {
        List<String> parsedDesc = TypeUtil.splitTypes(desc, false);
        List<String> parsedSignature = TypeUtil.splitTypes(signature, true);
        if (parsedSignature != null && !parsedSignature.isEmpty() && parsedSignature.size() != parsedDesc.size()) {
            throw new TransformationException("Failed to parse type lists due to size mismatch.\n\tdesc: " + desc + "\n\tsignature: " + signature + "\n\tparsedDesc: " + parsedDesc + "\n\tparsedSignature: " + parsedSignature);
        }
        ArrayList<Type> types = new ArrayList<Type>();
        for (int i = 0; i < parsedDesc.size(); ++i) {
            String real = parsedDesc.get(i);
            String generic = parsedSignature == null ? null : parsedSignature.get(i);
            types.add(new Type(real, generic));
        }
        return types;
    }

    public static Type ofSignature(String signature) {
        if (signature.charAt(0) == 'T') {
            return new Type("Ljava/lang/Object;", signature);
        }
        return new Type(ResolutionContext.extractReal(signature), signature);
    }

    public boolean isPrimitiveType() {
        return this.getDescriptorType().primitiveName != null;
    }

    public boolean isClassType() {
        return this.getDescriptorType() == DescriptorType.CLASS;
    }

    public boolean isArrayType() {
        return this.getDescriptorType() == DescriptorType.ARRAY;
    }

    public DescriptorType getDescriptorType() {
        return DescriptorType.of(this.descriptor.charAt(0));
    }

    public boolean isTypeParameter() {
        String signature = this.signature;
        return signature != null && signature.charAt(0) == 'T';
    }

    public String getJavaName() {
        if (this.isTypeParameter()) {
            return this.getTypeParameterName();
        }
        DescriptorType type = this.getDescriptorType();
        if (type.primitiveName != null) {
            return type.primitiveName;
        }
        if (type == DescriptorType.CLASS) {
            return this.getClassName() + (this.hasTypeArguments() ? "<" + Joiner.on(",").join(this.getTypeArguments().stream().map(Type::getJavaName)) + ">" : "");
        }
        if (type == DescriptorType.ARRAY) {
            return this.getArrayContainedType().getJavaName() + "[]";
        }
        throw new IllegalStateException("Unhandled descriptor type for type: " + this);
    }

    public String getPrimitiveTypeName() {
        DescriptorType type = this.getDescriptorType();
        if (type.primitiveName == null) {
            throw new UnsupportedOperationException("Can't get primitive type for: " + this);
        }
        return type.primitiveName;
    }

    public String getClassName() {
        DescriptorType type = this.getDescriptorType();
        if (type != DescriptorType.CLASS) {
            throw new UnsupportedOperationException("Can't get class name for: " + this);
        }
        return this.descriptorWithoutArray().substring(1, this.descriptor.length() - 1).replace('/', '.');
    }

    public String getTypeParameterName() {
        if (this.signature == null || !this.isTypeParameter()) {
            throw new UnsupportedOperationException("Can't get type parameter name for type: " + this);
        }
        return this.signature.substring(1, this.signature.length() - 1);
    }

    public Type remapClassNames(Function<String, String> mapper) {
        DescriptorType type = this.getDescriptorType();
        if (type == DescriptorType.ARRAY) {
            return this.getArrayContainedType().remapClassNames(mapper).withArrayCount(1);
        }
        if (type != DescriptorType.CLASS) {
            return new Type(this.descriptor, this.signature);
        }
        Type mappedType = Type.of(mapper.apply(this.getClassName()));
        if (this.isTypeParameter()) {
            mappedType = new Type(mappedType.descriptor, this.signature);
        }
        if (this.hasTypeArguments()) {
            mappedType = mappedType.withTypeArguments(this.getTypeArguments().stream().map(it -> it.remapClassNames(mapper)).collect(Collectors.toList()));
        }
        return mappedType;
    }

    public Type getArrayContainedType() {
        DescriptorType type = this.getDescriptorType();
        if (type != DescriptorType.ARRAY) {
            throw new UnsupportedOperationException("Can't get array contained type for: " + this);
        }
        return new Type(this.descriptor.substring(1), this.signatureElseDescriptor().substring(1));
    }

    public boolean hasTypeArguments() {
        return this.signature != null && this.signature.indexOf(60) != -1;
    }

    public List<Type> getTypeArguments() {
        String arguments = ResolutionContext.extractGeneric(this.signature);
        if (arguments == null) {
            throw new UnsupportedOperationException("Can't get type argument for type: " + this);
        }
        ArrayList<Type> argumentList = new ArrayList<Type>();
        for (String argument : CollectionUtil.iterable(TypeUtil.readTypes(arguments, true))) {
            argumentList.add(Type.ofSignature(argument));
        }
        assert (!argumentList.isEmpty());
        return argumentList;
    }

    public String signatureElseDescriptor() {
        return this.signature == null ? this.descriptor : this.signature;
    }

    public String descriptorWithoutArray() {
        return this.descriptor.substring(this.descriptor.lastIndexOf(91) + 1);
    }

    public Type withTypeArgument(Type of) {
        return this.withTypeArguments(Collections.singletonList(of));
    }

    public Type withTypeArguments(Iterable<Type> genericType) {
        if (this.getDescriptorType().primitiveName != null) {
            throw new UnsupportedOperationException("Can not add type argument to primitive type");
        }
        String signature = this.signatureElseDescriptor();
        int semicolon = signature.lastIndexOf(59);
        if (semicolon == -1) {
            throw new IllegalStateException("Couldn't find ';' in: " + this);
        }
        StringBuilder sb = new StringBuilder(signature);
        sb.insert(semicolon, '<' + Joiner.on().join(CollectionUtil.stream(genericType).map(Type::signatureElseDescriptor)) + '>');
        return new Type(this.descriptor, sb.toString());
    }

    public boolean similar(@NonNull Type other) {
        if (other == null) {
            throw new NullPointerException("other");
        }
        return UNKNOWN == this || UNKNOWN == other || this.descriptor.equals(other.descriptor);
    }

    public String toString() {
        String simpleName;
        try {
            simpleName = this.getJavaName();
        }
        catch (Exception e) {
            simpleName = e.toString();
        }
        return "Type(descriptor=" + this.descriptor + ", signature=" + this.signature + ", simpleName=" + simpleName + ")";
    }

    public Type withArrayCount(int arrayCount) {
        if (arrayCount == 0) {
            return this;
        }
        char[] brackets = new char[arrayCount];
        Arrays.fill(brackets, '[');
        return new Type(new String(brackets) + this.descriptor, this.signature);
    }

    public Type withClassName(String name) {
        String descriptor = "L" + name.replace('.', '/') + ";";
        String signature = this.signature;
        if (signature != null) {
            signature = descriptor + signature.substring(signature.indexOf(59) + 1);
        }
        return new Type(descriptor, signature);
    }

    public boolean isAssignableFrom(Type type) {
        return this.descriptor.equals(type.descriptor) || this.isClassType() && this.getClassName().equals("java.lang.Object") && (type.isArrayType() || type.isClassType());
    }

    @NonNull
    public String getDescriptor() {
        return this.descriptor;
    }

    @Nullable
    public String getSignature() {
        return this.signature;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Type)) {
            return false;
        }
        Type other = (Type)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$descriptor = this.getDescriptor();
        String other$descriptor = other.getDescriptor();
        if (this$descriptor == null ? other$descriptor != null : !this$descriptor.equals(other$descriptor)) {
            return false;
        }
        String this$signature = this.getSignature();
        String other$signature = other.getSignature();
        return !(this$signature == null ? other$signature != null : !this$signature.equals(other$signature));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Type;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $descriptor = this.getDescriptor();
        result = result * 59 + ($descriptor == null ? 43 : $descriptor.hashCode());
        String $signature = this.getSignature();
        result = result * 59 + ($signature == null ? 43 : $signature.hashCode());
        return result;
    }

    public static enum DescriptorType {
        BYTE("byte"),
        CHAR("char"),
        DOUBLE("double"),
        FLOAT("float"),
        INT("int"),
        LONG("long"),
        SHORT("short"),
        VOID("void"),
        BOOLEAN("boolean"),
        ARRAY(null),
        CLASS(null),
        VALUE(null),
        UNION(null);

        final String primitiveName;

        public static DescriptorType of(char c) {
            switch (c) {
                case '[': {
                    return ARRAY;
                }
                case 'L': {
                    return CLASS;
                }
                case 'Q': {
                    return VALUE;
                }
                case 'U': {
                    return UNION;
                }
                case 'B': {
                    return BYTE;
                }
                case 'C': {
                    return CHAR;
                }
                case 'D': {
                    return DOUBLE;
                }
                case 'F': {
                    return FLOAT;
                }
                case 'I': {
                    return INT;
                }
                case 'J': {
                    return LONG;
                }
                case 'S': {
                    return SHORT;
                }
                case 'V': {
                    return VOID;
                }
                case 'Z': {
                    return BOOLEAN;
                }
            }
            throw new UnknownDescriptorTypeException("Unknnown descriptor type '" + c + "'");
        }

        private DescriptorType(String primitiveName) {
            this.primitiveName = primitiveName;
        }

        public String getPrimitiveName() {
            return this.primitiveName;
        }

        private static class UnknownDescriptorTypeException
        extends RuntimeException {
            private static final long serialVersionUID = 0L;

            public UnknownDescriptorTypeException(String s) {
                super(s);
            }
        }
    }
}

