/*
 * Decompiled with CFR 0.152.
 */
package org.minimallycorrect.javatransformer.internal.asm;

import java.util.ArrayList;
import java.util.List;
import org.minimallycorrect.javatransformer.internal.asm.CombinedValue;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.LookupSwitchInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TableSwitchInsnNode;
import org.objectweb.asm.tree.TryCatchBlockNode;
import org.objectweb.asm.tree.analysis.AnalyzerException;
import org.objectweb.asm.tree.analysis.Interpreter;
import org.objectweb.asm.tree.analysis.Value;

public class CombinedAnalyzer<V extends Value>
implements Opcodes {
    private final Interpreter<V> interpreter;
    private Frame<V>[] frames;
    private boolean[] queued;
    private int[] queue;
    private int top;

    private CombinedAnalyzer(Interpreter<V> interpreter) {
        this.interpreter = interpreter;
    }

    public static <A extends Value> Frame<A>[] analyze(Interpreter<A> interpreter, String owner, MethodNode m) throws AnalyzerException {
        if ((m.access & 0x500) != 0 || m.instructions.size() == 0) {
            return new Frame[0];
        }
        return super.analyze(owner, m);
    }

    private Frame<V>[] analyze(String owner, MethodNode m) throws AnalyzerException {
        int n = m.instructions.size();
        InsnList insns = m.instructions;
        List[] handlers = new List[n];
        this.frames = new Frame[n + 1];
        this.queued = new boolean[n];
        this.queue = new int[n];
        this.top = 0;
        for (int i = 0; i < m.tryCatchBlocks.size(); ++i) {
            TryCatchBlockNode tcb = (TryCatchBlockNode)m.tryCatchBlocks.get(i);
            int begin = insns.indexOf((AbstractInsnNode)tcb.start);
            int end = insns.indexOf((AbstractInsnNode)tcb.end);
            for (int j = begin; j < end; ++j) {
                ArrayList<TryCatchBlockNode> insnHandlers = handlers[j];
                if (insnHandlers == null) {
                    handlers[j] = insnHandlers = new ArrayList<TryCatchBlockNode>();
                }
                insnHandlers.add(tcb);
            }
        }
        Frame current = new Frame(m.maxLocals, m.maxStack);
        Frame handler = new Frame(m.maxLocals, m.maxStack);
        current.setReturn(this.interpreter.newValue(Type.getReturnType((String)m.desc)));
        Type[] args = Type.getArgumentTypes((String)m.desc);
        int local = 0;
        if ((m.access & 8) == 0) {
            Type ctype = Type.getObjectType((String)owner);
            current.setLocal(local++, this.interpreter.newValue(ctype));
        }
        for (Type arg : args) {
            current.setLocal(local++, this.interpreter.newValue(arg));
            if (arg.getSize() != 2) continue;
            current.setLocal(local++, this.interpreter.newValue(null));
        }
        while (local < m.maxLocals) {
            current.setLocal(local++, this.interpreter.newValue(null));
        }
        this.merge(0, current);
        while (this.top > 0) {
            int insn = this.queue[--this.top];
            Frame<V> f = this.frames[insn];
            this.queued[insn] = false;
            AbstractInsnNode insnNode = null;
            try {
                List insnHandlers;
                insnNode = m.instructions.get(insn);
                int insnOpcode = insnNode.getOpcode();
                int insnType = insnNode.getType();
                if (insnType == 8 || insnType == 15 || insnType == 14) {
                    this.merge(insn + 1, f);
                } else {
                    current.init(f).execute(insnNode, this.interpreter);
                    if (insnNode instanceof JumpInsnNode) {
                        JumpInsnNode j = (JumpInsnNode)insnNode;
                        if (insnOpcode != 167 && insnOpcode != 168) {
                            this.merge(insn + 1, current);
                        }
                        int jump = insns.indexOf((AbstractInsnNode)j.label);
                        this.merge(jump, current);
                    } else if (insnNode instanceof LookupSwitchInsnNode) {
                        LookupSwitchInsnNode lsi = (LookupSwitchInsnNode)insnNode;
                        int jump = insns.indexOf((AbstractInsnNode)lsi.dflt);
                        this.merge(jump, current);
                        for (LabelNode label : lsi.labels) {
                            jump = insns.indexOf((AbstractInsnNode)label);
                            this.merge(jump, current);
                        }
                    } else if (insnNode instanceof TableSwitchInsnNode) {
                        TableSwitchInsnNode tsi = (TableSwitchInsnNode)insnNode;
                        int jump = insns.indexOf((AbstractInsnNode)tsi.dflt);
                        this.merge(jump, current);
                        for (LabelNode label : tsi.labels) {
                            jump = insns.indexOf((AbstractInsnNode)label);
                            this.merge(jump, current);
                        }
                    } else if (insnOpcode != 191 && (insnOpcode < 172 || insnOpcode > 177)) {
                        this.merge(insn + 1, current);
                    }
                }
                if ((insnHandlers = handlers[insn]) == null) continue;
                for (TryCatchBlockNode tcb : insnHandlers) {
                    Type type = tcb.type == null ? Type.getObjectType((String)"java/lang/Throwable") : Type.getObjectType((String)tcb.type);
                    int jump = insns.indexOf((AbstractInsnNode)tcb.handler);
                    handler.init(f);
                    handler.clearStack();
                    handler.push(this.interpreter.newValue(type));
                    this.merge(jump, handler);
                }
            }
            catch (Exception e) {
                throw new AnalyzerException(e instanceof AnalyzerException ? ((AnalyzerException)e).node : insnNode, "Error at instruction " + insn + " " + e.getClass().getName() + ": " + e.getMessage(), (Throwable)e);
            }
        }
        return this.frames;
    }

    private void merge(int insn, Frame<V> frame) throws AnalyzerException {
        boolean changes;
        Frame<V> oldFrame = this.frames[insn];
        if (oldFrame == null) {
            this.frames[insn] = new Frame<V>(frame);
            changes = true;
        } else {
            changes = oldFrame.merge(frame, this.interpreter);
        }
        if (changes && insn < this.queued.length && !this.queued[insn]) {
            this.queued[insn] = true;
            this.queue[this.top++] = insn;
        }
    }

    public static class Frame<V extends Value>
    extends org.objectweb.asm.tree.analysis.Frame<V> {
        public Frame(int nLocals, int nStack) {
            super(nLocals, nStack);
        }

        public Frame(org.objectweb.asm.tree.analysis.Frame<? extends V> src) {
            super(src);
        }

        public V pop() {
            int top = this.getStackSize();
            if (top == 0) {
                this.push(CombinedValue.of(null, CombinedValue.POPPED_FROM_BOTTOM));
            }
            return (V)super.pop();
        }
    }
}

