/*
 * Decompiled with CFR 0.152.
 */
package org.minimallycorrect.javatransformer.internal.asm;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;
import org.minimallycorrect.javatransformer.internal.asm.CombinedValue;
import org.objectweb.asm.Handle;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.IntInsnNode;
import org.objectweb.asm.tree.InvokeDynamicInsnNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MultiANewArrayInsnNode;
import org.objectweb.asm.tree.TypeInsnNode;
import org.objectweb.asm.tree.analysis.AnalyzerException;
import org.objectweb.asm.tree.analysis.Interpreter;

public class CombinedInterpreter
extends Interpreter<CombinedValue>
implements Opcodes {
    public CombinedInterpreter() {
        super(327680);
    }

    protected CombinedInterpreter(int api) {
        super(api);
    }

    @Nullable
    public CombinedValue unaryOperation(AbstractInsnNode insn, CombinedValue value) throws AnalyzerException {
        switch (insn.getOpcode()) {
            case 116: 
            case 132: 
            case 136: 
            case 139: 
            case 142: 
            case 145: 
            case 146: 
            case 147: {
                return CombinedValue.of(Type.INT_TYPE, insn);
            }
            case 118: 
            case 134: 
            case 137: 
            case 144: {
                return CombinedValue.of(Type.FLOAT_TYPE, insn);
            }
            case 117: 
            case 133: 
            case 140: 
            case 143: {
                return CombinedValue.of(Type.LONG_TYPE, insn);
            }
            case 119: 
            case 135: 
            case 138: 
            case 141: {
                return CombinedValue.of(Type.DOUBLE_TYPE, insn);
            }
            case 153: 
            case 154: 
            case 155: 
            case 156: 
            case 157: 
            case 158: 
            case 170: 
            case 171: 
            case 172: 
            case 173: 
            case 174: 
            case 175: 
            case 176: 
            case 179: {
                return null;
            }
            case 180: {
                return CombinedValue.of(Type.getType((String)((FieldInsnNode)insn).desc), insn);
            }
            case 188: {
                switch (((IntInsnNode)insn).operand) {
                    case 4: {
                        return CombinedValue.of(Type.getType((String)"[Z"), insn);
                    }
                    case 5: {
                        return CombinedValue.of(Type.getType((String)"[C"), insn);
                    }
                    case 8: {
                        return CombinedValue.of(Type.getType((String)"[B"), insn);
                    }
                    case 9: {
                        return CombinedValue.of(Type.getType((String)"[S"), insn);
                    }
                    case 10: {
                        return CombinedValue.of(Type.getType((String)"[I"), insn);
                    }
                    case 6: {
                        return CombinedValue.of(Type.getType((String)"[F"), insn);
                    }
                    case 7: {
                        return CombinedValue.of(Type.getType((String)"[D"), insn);
                    }
                    case 11: {
                        return CombinedValue.of(Type.getType((String)"[J"), insn);
                    }
                }
                throw new AnalyzerException(insn, "Invalid array type");
            }
            case 189: {
                String desc = ((TypeInsnNode)insn).desc;
                return CombinedValue.of(Type.getType((String)("[" + Type.getObjectType((String)desc))), insn);
            }
            case 190: {
                return CombinedValue.of(Type.INT_TYPE, insn);
            }
            case 191: {
                return null;
            }
            case 192: {
                String desc = ((TypeInsnNode)insn).desc;
                return CombinedValue.of(Type.getObjectType((String)desc), Collections.singleton(insn));
            }
            case 193: {
                return CombinedValue.of(Type.INT_TYPE, insn);
            }
            case 194: 
            case 195: 
            case 198: 
            case 199: {
                return null;
            }
        }
        throw new Error("Internal error.");
    }

    @Nullable
    public CombinedValue ternaryOperation(AbstractInsnNode insn, CombinedValue value1, CombinedValue value2, CombinedValue value3) throws AnalyzerException {
        return this.naryOperation(insn, Arrays.asList(value1, value2, value3));
    }

    @Nullable
    public CombinedValue naryOperation(AbstractInsnNode insn, List<? extends CombinedValue> values) throws AnalyzerException {
        int opcode = insn.getOpcode();
        if (opcode == 197) {
            return CombinedValue.of(Type.getType((String)((MultiANewArrayInsnNode)insn).desc), insn);
        }
        if (opcode == 186) {
            return CombinedValue.of(Type.getReturnType((String)((InvokeDynamicInsnNode)insn).desc), insn);
        }
        return CombinedValue.of(Type.getReturnType((String)((MethodInsnNode)insn).desc), insn);
    }

    public void returnOperation(AbstractInsnNode insn, CombinedValue value, CombinedValue expected) {
    }

    @Deprecated
    @Nullable
    public CombinedValue newValue(Type type) {
        return CombinedValue.of(type, CombinedValue.PREFILLED);
    }

    @Nullable
    public CombinedValue newOperation(AbstractInsnNode insn) throws AnalyzerException {
        switch (insn.getOpcode()) {
            case 1: {
                return CombinedValue.of(CombinedValue.OBJECT_TYPE, insn);
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 16: 
            case 17: {
                return CombinedValue.of(Type.INT_TYPE, insn);
            }
            case 9: 
            case 10: {
                return CombinedValue.of(Type.LONG_TYPE, insn);
            }
            case 11: 
            case 12: 
            case 13: {
                return CombinedValue.of(Type.FLOAT_TYPE, insn);
            }
            case 14: 
            case 15: {
                return CombinedValue.of(Type.DOUBLE_TYPE, insn);
            }
            case 18: {
                Object cst = ((LdcInsnNode)insn).cst;
                if (cst instanceof Integer) {
                    return CombinedValue.of(Type.INT_TYPE, insn);
                }
                if (cst instanceof Float) {
                    return CombinedValue.of(Type.FLOAT_TYPE, insn);
                }
                if (cst instanceof Long) {
                    return CombinedValue.of(Type.LONG_TYPE, insn);
                }
                if (cst instanceof Double) {
                    return CombinedValue.of(Type.DOUBLE_TYPE, insn);
                }
                if (cst instanceof String) {
                    return CombinedValue.of(Type.getObjectType((String)"java/lang/String"), insn);
                }
                if (cst instanceof Type) {
                    int sort = ((Type)cst).getSort();
                    if (sort == 10 || sort == 9) {
                        return CombinedValue.of(Type.getObjectType((String)"java/lang/Class"), insn);
                    }
                    if (sort == 11) {
                        return CombinedValue.of(Type.getObjectType((String)"java/lang/invoke/MethodType"), insn);
                    }
                    throw new IllegalArgumentException("Illegal LDC constant " + cst);
                }
                if (cst instanceof Handle) {
                    return CombinedValue.of(Type.getObjectType((String)"java/lang/invoke/MethodHandle"), insn);
                }
                throw new IllegalArgumentException("Illegal LDC constant " + cst);
            }
            case 168: {
                throw new UnsupportedOperationException("JSR not supported. Use JSRInlinerAdapter to inline JSR subroutines.");
            }
            case 178: {
                return CombinedValue.of(Type.getType((String)((FieldInsnNode)insn).desc), insn);
            }
            case 187: {
                return CombinedValue.of(Type.getObjectType((String)((TypeInsnNode)insn).desc), insn);
            }
        }
        throw new Error("Internal error.");
    }

    public CombinedValue copyOperation(AbstractInsnNode insn, CombinedValue value) throws AnalyzerException {
        return value;
    }

    @Nullable
    public CombinedValue binaryOperation(AbstractInsnNode insn, CombinedValue value1, CombinedValue value2) throws AnalyzerException {
        switch (insn.getOpcode()) {
            case 46: 
            case 51: 
            case 52: 
            case 53: 
            case 96: 
            case 100: 
            case 104: 
            case 108: 
            case 112: 
            case 120: 
            case 122: 
            case 124: 
            case 126: 
            case 128: 
            case 130: {
                return CombinedValue.of(Type.INT_TYPE, insn);
            }
            case 48: 
            case 98: 
            case 102: 
            case 106: 
            case 110: 
            case 114: {
                return CombinedValue.of(Type.FLOAT_TYPE, insn);
            }
            case 47: 
            case 97: 
            case 101: 
            case 105: 
            case 109: 
            case 113: 
            case 121: 
            case 123: 
            case 125: 
            case 127: 
            case 129: 
            case 131: {
                return CombinedValue.of(Type.LONG_TYPE, insn);
            }
            case 49: 
            case 99: 
            case 103: 
            case 107: 
            case 111: 
            case 115: {
                return CombinedValue.of(Type.DOUBLE_TYPE, insn);
            }
            case 50: {
                return CombinedValue.of(CombinedValue.OBJECT_TYPE, insn);
            }
            case 148: 
            case 149: 
            case 150: 
            case 151: 
            case 152: {
                return CombinedValue.of(Type.INT_TYPE, insn);
            }
            case 159: 
            case 160: 
            case 161: 
            case 162: 
            case 163: 
            case 164: 
            case 165: 
            case 166: 
            case 181: {
                return null;
            }
        }
        throw new Error("Internal error.");
    }

    @Nullable
    public CombinedValue merge(CombinedValue v, CombinedValue w) {
        if (v.equals(w)) {
            return v;
        }
        Type type = v.getType();
        if (!Objects.equals(type, w.getType())) {
            type = w.isReference() && v.isReference() ? CombinedValue.OBJECT_TYPE : null;
        }
        HashSet<AbstractInsnNode> s = new HashSet<AbstractInsnNode>();
        s.addAll(v.insns);
        s.addAll(w.insns);
        return CombinedValue.of(type, s);
    }
}

