/*
 * Decompiled with CFR 0.152.
 */
package org.minimallycorrect.javatransformer.internal.asm;

import java.util.Collections;
import java.util.Iterator;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.Nullable;
import org.minimallycorrect.javatransformer.api.code.IntermediateValue;
import org.minimallycorrect.javatransformer.internal.asm.AsmInstructions;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.analysis.Value;

public class CombinedValue
implements Value,
Opcodes {
    public static final Type OBJECT_TYPE = Type.getObjectType((String)"java/lang/Object");
    public static final AbstractInsnNode POPPED_FROM_BOTTOM = new InsnNode(0){

        public String toString() {
            return "Popped from empty stack.";
        }
    };
    public static final AbstractInsnNode PREFILLED = new InsnNode(0){

        public String toString() {
            return "Pre-filled value. Method parameter, this, or caught exception/NOP";
        }
    };
    private static final CombinedValue UNINITIALIZED_VALUE = new CombinedValue(null, Collections.emptySet());
    private static final CombinedValue INT_VALUE = new CombinedValue(Type.INT_TYPE, Collections.emptySet());
    private static final CombinedValue FLOAT_VALUE = new CombinedValue(Type.FLOAT_TYPE, Collections.emptySet());
    private static final CombinedValue LONG_VALUE = new CombinedValue(Type.LONG_TYPE, Collections.emptySet());
    private static final CombinedValue DOUBLE_VALUE = new CombinedValue(Type.DOUBLE_TYPE, Collections.emptySet());
    private static final CombinedValue REFERENCE_VALUE = new CombinedValue(OBJECT_TYPE, Collections.emptySet());
    public final Set<AbstractInsnNode> insns;
    @Nullable
    private final Type type;

    protected CombinedValue(@Nullable Type type, Set<AbstractInsnNode> insns) {
        this.type = type;
        this.insns = insns;
    }

    @Deprecated
    @Nullable
    public static CombinedValue of(@Nullable Type type) {
        return CombinedValue.of(type, Collections.emptySet());
    }

    @Nullable
    public static CombinedValue of(@Nullable Type type, AbstractInsnNode insn) {
        return CombinedValue.of(type, Collections.singleton(insn));
    }

    @Nullable
    public static CombinedValue of(@Nullable Type type, Set<AbstractInsnNode> insns) {
        if (type != null && type.getSort() == 0 && insns.size() == 1 && insns.contains(PREFILLED)) {
            return null;
        }
        if (!insns.isEmpty()) {
            return new CombinedValue(type, insns);
        }
        if (type == null) {
            return UNINITIALIZED_VALUE;
        }
        switch (type.getSort()) {
            case 0: {
                return null;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                return INT_VALUE;
            }
            case 6: {
                return FLOAT_VALUE;
            }
            case 7: {
                return LONG_VALUE;
            }
            case 8: {
                return DOUBLE_VALUE;
            }
            case 9: 
            case 10: {
                return type.getInternalName().equals("java/lang/Object") ? REFERENCE_VALUE : new CombinedValue(type, insns);
            }
        }
        throw new IllegalArgumentException("Unhandled type" + type.getSort() + " " + type);
    }

    @Nullable
    public Type getType() {
        return this.type;
    }

    public int getSize() {
        return this.type == Type.LONG_TYPE || this.type == Type.DOUBLE_TYPE ? 2 : 1;
    }

    public boolean isReference() {
        return this.type != null && (this.type.getSort() == 10 || this.type.getSort() == 9);
    }

    public boolean isInitialised() {
        return this.type != null;
    }

    @Nullable
    public Object getConstantValue() {
        Iterator<AbstractInsnNode> iterator = this.insns.iterator();
        if (!iterator.hasNext()) {
            return IntermediateValue.UNKNOWN;
        }
        Object value = AsmInstructions.getConstant(iterator.next());
        while (iterator.hasNext()) {
            Object newValue = AsmInstructions.getConstant(iterator.next());
            if (Objects.equals(newValue, value)) continue;
            return IntermediateValue.UNKNOWN;
        }
        return value;
    }

    public String getDescriptor() {
        if (this == UNINITIALIZED_VALUE || this.type == null) {
            return ".";
        }
        return this.type.getDescriptor();
    }

    public String toString() {
        return "type: " + this.getDescriptor() + " " + this.insns;
    }

    public boolean isPrefilled() {
        return this.insns != null && this.insns.contains(PREFILLED);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CombinedValue)) {
            return false;
        }
        CombinedValue other = (CombinedValue)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Set<AbstractInsnNode> this$insns = this.insns;
        Set<AbstractInsnNode> other$insns = other.insns;
        if (this$insns == null ? other$insns != null : !((Object)this$insns).equals(other$insns)) {
            return false;
        }
        Type this$type = this.getType();
        Type other$type = other.getType();
        return !(this$type == null ? other$type != null : !this$type.equals(other$type));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CombinedValue;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Set<AbstractInsnNode> $insns = this.insns;
        result = result * 59 + ($insns == null ? 43 : ((Object)$insns).hashCode());
        Type $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        return result;
    }
}

