/*
 * Decompiled with CFR 0.152.
 */
package org.minimallycorrect.javatransformer.internal.asm;

import java.util.HashMap;
import java.util.Map;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassWriter;

public class FilteringClassWriter
extends ClassWriter {
    public final Map<String, String> filters = new HashMap<String, String>();

    public FilteringClassWriter(int flags) {
        super(flags);
    }

    public FilteringClassWriter(ClassReader classReader, int flags) {
        super(classReader, flags);
    }

    public static void addFilter(Map<String, String> filters, String a, String b) {
        filters.put(a, b);
        String a2 = a.replace('.', '/');
        String b2 = b.replace('.', '/');
        filters.put(a2, b2);
        filters.put('L' + a2 + ';', 'L' + b2 + ';');
    }

    public int newClass(String value) {
        return super.newClass(this.replace(value));
    }

    public int newConst(Object value) {
        if (value instanceof String) {
            value = this.replace((String)value);
        }
        return super.newConst(value);
    }

    public int newNameType(String name, String desc) {
        return super.newNameType(name, this.replace(desc));
    }

    public int newHandle(int tag, String owner, String name, String desc) {
        return super.newHandle(tag, this.replace(owner), name, desc);
    }

    public int newField(String owner, String name, String desc) {
        return super.newField(this.replace(owner), name, desc);
    }

    private String replace(String s) {
        String replaced = this.filters.get(s);
        return replaced == null ? s : replaced;
    }

    public int newUTF8(String value) {
        return super.newUTF8(this.replace(value));
    }

    protected String getCommonSuperClass(String a, String b) {
        if (a.indexOf(46) != -1 && !a.startsWith("java.") || b.indexOf(46) != -1 && !b.startsWith("java.")) {
            throw new UnsupportedOperationException();
        }
        return super.getCommonSuperClass(a, b);
    }
}

