/*
 * Decompiled with CFR 0.152.
 */
package org.minimallycorrect.javatransformer.internal.util;

import java.util.function.Supplier;
import java.util.stream.Stream;
import org.minimallycorrect.javatransformer.internal.util.CollectionUtil;

public interface Splitter {
    public static final Splitter commaSplitter = Splitter.on(',');

    public static Splitter on(final char c) {
        return s -> CollectionUtil.stream(new Supplier<String>(){
            int base = -1;

            @Override
            public String get() {
                while (this.base != 0) {
                    int base = this.base;
                    if (base == -1) {
                        base = 0;
                    }
                    int next = s.indexOf(c, base);
                    int nextBase = next + 1;
                    if (next == -1) {
                        next = s.length();
                    }
                    String part = s.substring(base, next).trim();
                    this.base = nextBase;
                    if (part.isEmpty()) continue;
                    return part;
                }
                return null;
            }
        });
    }

    public Stream<String> split(String var1);

    default public Iterable<String> splitIterable(String s) {
        return this.split(s)::iterator;
    }
}

