/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.lib.lib.util;

import de.teamlapen.lib.lib.util.UtilLib;
import java.util.Collections;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StringUtils;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public abstract class SimpleSpawnerLogic {
    private static final int MOB_COUNT_DIV = (int)Math.pow(17.0, 2.0);
    @Nullable
    private ResourceLocation entityName = null;
    private int minSpawnDelay = 200;
    private int maxSpawnDelay = 800;
    private int activateRange = 16;
    private int spawnCount = 1;
    private int maxNearbyEntities = 4;
    private int spawnRange = 4;
    private int spawnDelay = 20;
    private int spawnedToday = 0;
    private long spawnedLast = 0L;
    private boolean flag = true;
    private EnumCreatureType limitType;

    @Nullable
    public ResourceLocation getEntityName() {
        return this.entityName;
    }

    public void setEntityName(@Nullable ResourceLocation entityName) {
        this.entityName = entityName;
    }

    public abstract BlockPos getSpawnerPosition();

    public abstract World getSpawnerWorld();

    public boolean isActivated() {
        if (this.entityName == null) {
            return false;
        }
        BlockPos blockpos = this.getSpawnerPosition();
        return this.getSpawnerWorld().func_175636_b((double)blockpos.func_177958_n() + 0.5, (double)blockpos.func_177956_o() + 0.5, (double)blockpos.func_177952_p() + 0.5, (double)this.activateRange);
    }

    public void readFromNbt(NBTTagCompound nbt) {
        String s;
        String n;
        this.entityName = nbt.func_74764_b("entity_name") ? ((n = nbt.func_74779_i("entity_name")).contains("vampirism.") ? new ResourceLocation("vampirism", n.replace("vampirism.", "")) : null) : (StringUtils.func_151246_b((String)(s = nbt.func_74779_i("id"))) ? null : new ResourceLocation(s));
        this.minSpawnDelay = nbt.func_74762_e("min_delay");
        this.maxSpawnDelay = nbt.func_74762_e("max_delay");
        this.maxNearbyEntities = nbt.func_74762_e("max_nearby");
        this.spawnDelay = nbt.func_74762_e("delay");
        this.activateRange = nbt.func_74762_e("activate_range");
        this.spawnRange = nbt.func_74762_e("spawn_range");
        this.spawnCount = nbt.func_74762_e("spawn_count");
        this.spawnedToday = nbt.func_74762_e("spawned_today");
        this.spawnedLast = nbt.func_74763_f("spawned_last");
        this.flag = nbt.func_74767_n("spawner_flag");
    }

    public void setActivateRange(int activateRange) {
        this.activateRange = activateRange;
    }

    public boolean setDelayToMin(int p_98268_1_) {
        if (p_98268_1_ == 1 && this.getSpawnerWorld().field_72995_K) {
            this.spawnDelay = this.minSpawnDelay;
            return true;
        }
        return false;
    }

    public void setLimitTotalEntities(EnumCreatureType creatureType) {
        this.limitType = creatureType;
    }

    public void setMaxNearbyEntities(int maxNearbyEntities) {
        this.maxNearbyEntities = maxNearbyEntities;
    }

    public void setMaxSpawnDelay(int maxSpawnDelay) {
        this.maxSpawnDelay = maxSpawnDelay;
    }

    public void setMinSpawnDelay(int minSpawnDelay) {
        this.minSpawnDelay = minSpawnDelay;
    }

    public void setSpawnCount(int spawnCount) {
        this.spawnCount = spawnCount;
    }

    public void setSpawnRange(int spawnRange) {
        this.spawnRange = spawnRange;
    }

    public void updateSpawner() {
        if (this.isActivated()) {
            BlockPos blockpos = this.getSpawnerPosition();
            if (!this.getSpawnerWorld().field_72995_K) {
                Entity entity;
                if (this.spawnDelay == -1) {
                    this.resetTimer();
                }
                if (this.spawnDelay > 0) {
                    --this.spawnDelay;
                    return;
                }
                if (this.getSpawnerWorld().func_82737_E() % 24000L < this.spawnedLast) {
                    this.spawnedToday = 0;
                    this.flag = true;
                }
                if (!this.flag) {
                    return;
                }
                boolean flag1 = false;
                for (int i = 0; i < this.spawnCount && (entity = EntityList.func_188429_b((ResourceLocation)this.getEntityName(), (World)this.getSpawnerWorld())) != null; ++i) {
                    int j = this.getSpawnerWorld().func_72872_a(entity.getClass(), this.getSpawningBox()).size();
                    if (j >= this.maxNearbyEntities) {
                        this.resetTimer();
                        break;
                    }
                    if (this.limitType != null) {
                        int total = this.getSpawnerWorld().countEntities(this.limitType, true);
                        if ((total = total * UtilLib.countPlayerLoadedChunks(this.getSpawnerWorld()) / MOB_COUNT_DIV) > this.limitType.func_75601_b()) {
                            this.resetTimer();
                            break;
                        }
                    }
                    if (!UtilLib.spawnEntityInWorld(this.getSpawnerWorld(), this.getSpawningBox(), entity, 1, Collections.emptyList())) continue;
                    this.onSpawned(entity);
                    flag1 = true;
                }
                if (flag1) {
                    this.resetTimer();
                    ++this.spawnedToday;
                    this.spawnedLast = this.getSpawnerWorld().func_82737_E() % 24000L;
                }
            }
        }
    }

    public void writeToNbt(NBTTagCompound nbt) {
        if (this.entityName != null) {
            nbt.func_74778_a("id", this.entityName.toString());
        }
        nbt.func_74768_a("min_delay", this.minSpawnDelay);
        nbt.func_74768_a("max_delay", this.maxSpawnDelay);
        nbt.func_74768_a("max_nearby", this.maxNearbyEntities);
        nbt.func_74768_a("delay", this.spawnDelay);
        nbt.func_74768_a("activate_range", this.activateRange);
        nbt.func_74768_a("spawn_range", this.spawnRange);
        nbt.func_74768_a("spawn_count", this.spawnCount);
        nbt.func_74768_a("spawned_today", this.spawnedToday);
        nbt.func_74772_a("spawned_last", this.spawnedLast);
        nbt.func_74757_a("spawner_flag", this.flag);
    }

    protected AxisAlignedBB getSpawningBox() {
        BlockPos blockpos = this.getSpawnerPosition();
        return new AxisAlignedBB((double)blockpos.func_177958_n(), (double)blockpos.func_177956_o(), (double)blockpos.func_177952_p(), (double)(blockpos.func_177958_n() + 1), (double)(blockpos.func_177956_o() + 1), (double)(blockpos.func_177952_p() + 1)).func_72314_b((double)this.spawnRange, (double)this.spawnRange, (double)this.spawnRange);
    }

    protected abstract void onReset();

    protected void onSpawned(Entity e) {
        if (e instanceof EntityLiving) {
            ((EntityLiving)e).func_70656_aK();
        }
    }

    private void resetTimer() {
        if (this.maxSpawnDelay <= this.minSpawnDelay) {
            this.spawnDelay = this.minSpawnDelay;
        } else {
            int i = this.maxSpawnDelay - this.minSpawnDelay;
            this.spawnDelay = this.minSpawnDelay + this.getSpawnerWorld().field_73012_v.nextInt(i);
        }
        this.onReset();
    }

    public int getSpawnedToday() {
        return this.spawnedToday;
    }

    public void setSpawn(boolean spawn) {
        this.flag = spawn;
    }
}

