/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.blocks;

import de.teamlapen.vampirism.api.entity.factions.IPlayableFaction;
import de.teamlapen.vampirism.blocks.VampirismBlockContainer;
import de.teamlapen.vampirism.core.ModBlocks;
import de.teamlapen.vampirism.entity.factions.FactionPlayerHandler;
import de.teamlapen.vampirism.tileentity.TileTotem;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockTotemTop
extends VampirismBlockContainer {
    protected static final AxisAlignedBB BBOX = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.7, 1.0);
    private static final String regName = "totem_top";

    public BlockTotemTop() {
        super(regName, Material.field_151576_e);
        this.func_149711_c(40.0f);
        this.func_149752_b(2000.0f);
        this.func_149672_a(SoundType.field_185851_d);
    }

    public boolean canEntityDestroy(IBlockState state, IBlockAccess world, BlockPos pos, Entity entity) {
        return false;
    }

    @Nullable
    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileTotem();
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return BBOX;
    }

    public float getExplosionResistance(World world, BlockPos pos, @Nullable Entity exploder, Explosion explosion) {
        return Float.MAX_VALUE;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        TileEntity tile = worldIn.func_175625_s(pos);
        if (tile instanceof TileTotem) {
            ((TileTotem)tile).updateTotem();
            worldIn.func_175641_c(pos, (Block)this, 1, 0);
        }
    }

    public boolean removedByPlayer(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        TileTotem tile = this.getTile(world, pos);
        if (tile != null && !tile.canPlayerRemoveBlock(player)) {
            return false;
        }
        return super.removedByPlayer(state, world, pos, player, willHarvest);
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        TileTotem tile = this.getTile(worldIn, pos);
        if (tile != null) {
            tile.onTileRemoved();
        }
        super.func_180663_b(worldIn, pos, state);
    }

    @Nullable
    private TileTotem getTile(World world, BlockPos pos) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileTotem) {
            return (TileTotem)tile;
        }
        return null;
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (worldIn.field_72995_K) {
            return true;
        }
        IPlayableFaction f = FactionPlayerHandler.get(playerIn).getCurrentFaction();
        TileTotem t = this.getTile(worldIn, pos);
        if (f != null && t != null && worldIn.func_180495_p(pos.func_177977_b()).func_177230_c().equals((Object)ModBlocks.totem_base)) {
            t.initiateCapture(f, playerIn);
            return true;
        }
        return super.func_180639_a(worldIn, pos, state, playerIn, hand, facing, hitX, hitY, hitZ);
    }
}

