/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.config;

import de.teamlapen.vampirism.VampirismMod;
import de.teamlapen.vampirism.api.VampirismAPI;
import de.teamlapen.vampirism.entity.converted.VampirismEntityRegistry;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.Loader;
import org.apache.commons.lang3.StringUtils;

public class BloodValueLoader {
    private static final String TAG = "BloodValueLoader";
    @Nullable
    private static File bloodValueWorldFile;

    public static void init(File configDir) {
        File bloodConfigFile = new File(configDir, "vampirism_blood_values.txt");
        try {
            Map<ResourceLocation, Integer> defaultValues = BloodValueLoader.loadBloodValuesFromReader(new InputStreamReader(BloodValueLoader.class.getResourceAsStream("/blood_values/default_blood_values.txt")), "default_blood_values.txt");
            VampirismAPI.entityRegistry().addBloodValues(defaultValues);
        }
        catch (IOException e) {
            VampirismMod.log.bigWarning(TAG, "Could not read default blood values, this should not happen and destroys the mod experience", new Object[0]);
            VampirismMod.log.e(TAG, e, "Exception", new Object[0]);
        }
        if (bloodConfigFile.exists()) {
            try {
                Map<ResourceLocation, Integer> override = BloodValueLoader.loadBloodValuesFromReader(new FileReader(bloodConfigFile), bloodConfigFile.getName());
                VampirismAPI.entityRegistry().overrideBloodValues(override);
                VampirismMod.log.i(TAG, "Successfully loaded additional blood value file", new Object[0]);
            }
            catch (IOException e) {
                VampirismMod.log.e(TAG, "Could not read blood values from config file %s", bloodConfigFile.getName());
            }
        }
        BloodValueLoader.loadBloodValuesModCompat("animania");
        BloodValueLoader.loadBloodValuesModCompat("ancientwarfarenpc");
        BloodValueLoader.loadBloodValuesModCompat("twilightforest");
        BloodValueLoader.loadBloodValuesModCompat("sophisticatedwolves");
        BloodValueLoader.loadBloodValuesModCompat("erebus");
        BloodValueLoader.loadBloodValuesModCompat("grimoireofgaia");
        BloodValueLoader.loadBloodValuesModCompat("tektopia");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map<ResourceLocation, Integer> loadBloodValuesFromReader(Reader r, String file) throws IOException {
        HashMap<ResourceLocation, Integer> bloodValues = new HashMap<ResourceLocation, Integer>();
        BufferedReader br = null;
        try {
            String line;
            br = new BufferedReader(r);
            while ((line = br.readLine()) != null) {
                int val;
                if (line.startsWith("#") || StringUtils.isBlank((CharSequence)line)) continue;
                String[] p = line.split("=");
                if (p.length != 2) {
                    VampirismMod.log.w("ReadBlood", "Line %s  in %s is not formatted properly", line, file);
                    continue;
                }
                try {
                    val = Integer.parseInt(p[1]);
                }
                catch (NumberFormatException e) {
                    VampirismMod.log.w("ReadBlood", "Line %s  in %s is not formatted properly", line, file);
                    continue;
                }
                bloodValues.put(new ResourceLocation(p[0]), val);
            }
        }
        finally {
            if (br != null) {
                br.close();
            }
            r.close();
        }
        return bloodValues;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean writeBloodValues(Writer w, Map<ResourceLocation, Integer> values, String comment) throws IOException {
        BufferedWriter bw = null;
        try {
            bw = new BufferedWriter(w);
            bw.write(35);
            bw.write(comment);
            bw.newLine();
            for (Map.Entry<ResourceLocation, Integer> entry : values.entrySet()) {
                bw.write(entry.getKey().toString());
                bw.write(61);
                bw.write(String.valueOf(entry.getValue()));
                bw.newLine();
            }
            bw.flush();
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            VampirismMod.log.e(TAG, e, "Failed to write blood values (%s)", comment);
        }
        finally {
            if (bw != null) {
                bw.close();
            }
            w.close();
        }
        return false;
    }

    public static void loadBloodValuesModCompat(String modid) {
        if (!Loader.isModLoaded((String)modid)) {
            return;
        }
        try {
            Map<ResourceLocation, Integer> defaultValues = BloodValueLoader.loadBloodValuesFromReader(new InputStreamReader(BloodValueLoader.class.getResourceAsStream("/blood_values/" + modid + ".txt")), modid + ".txt");
            VampirismAPI.entityRegistry().addBloodValues(defaultValues);
        }
        catch (IOException e) {
            VampirismMod.log.e(TAG, e, "[ModCompat]Could not read default blood values for mod %s, this should not happen", modid);
        }
        catch (NullPointerException e) {
            VampirismMod.log.e(TAG, e, "[ModCompat]Could not find packed (in JAR) blood value file for mod %s", modid);
        }
    }

    public static void loadDynamicBloodValues(File f) {
        try {
            Map<ResourceLocation, Integer> saved = BloodValueLoader.loadBloodValuesFromReader(new InputStreamReader(new FileInputStream(f)), f.getName());
            VampirismEntityRegistry.getBiteableEntryManager().addDynamic(saved);
        }
        catch (IOException e) {
            VampirismMod.log.e(TAG, e, "[ModCompat]Could not read saved blood values from world from file  %s", f);
        }
    }

    public static void saveDynamicBloodValues(File f) {
        Map<ResourceLocation, Integer> values = VampirismEntityRegistry.getBiteableEntryManager().getValuesToSave();
        if (!f.exists() && values.isEmpty()) {
            return;
        }
        if (!f.exists() && f.getParentFile() != null) {
            f.getParentFile().mkdirs();
        }
        try {
            if (!BloodValueLoader.writeBloodValues(new FileWriter(f), values, "Dynamically calculated blood values - DON'T EDIT")) {
                VampirismMod.log.w(TAG, "Could not write dynamic values to file", new Object[0]);
            }
        }
        catch (IOException e) {
            VampirismMod.log.e(TAG, e, "Failed to write dynamic values to file", new Object[0]);
        }
    }

    public static void onServerStarting(MinecraftServer server) {
        bloodValueWorldFile = new File(new File(server.func_71218_a(0).func_72860_G().func_75765_b(), "vampirism"), "dynamic-blood-values.txt");
        if (bloodValueWorldFile.exists()) {
            BloodValueLoader.loadDynamicBloodValues(bloodValueWorldFile);
        }
    }

    public static void onServerStopping() {
        if (bloodValueWorldFile != null) {
            BloodValueLoader.saveDynamicBloodValues(bloodValueWorldFile);
            VampirismEntityRegistry.getBiteableEntryManager().resetDynamic();
        } else {
            VampirismMod.log.w(TAG, "Can't save blood values. File does not exist", new Object[0]);
        }
    }
}

