/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.entity;

import de.teamlapen.vampirism.VampirismMod;
import javax.annotation.Nonnull;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.projectile.EntityThrowable;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;

public class EntityThrowableItem
extends EntityThrowable {
    private static final DataParameter<ItemStack> ITEM = EntityDataManager.func_187226_a(EntityThrowableItem.class, (DataSerializer)DataSerializers.field_187196_f);

    public EntityThrowableItem(World worldIn) {
        super(worldIn);
    }

    public EntityThrowableItem(World worldIn, EntityLivingBase thrower) {
        super(worldIn, thrower);
    }

    @Nonnull
    public ItemStack getItem() {
        return (ItemStack)this.func_184212_Q().func_187225_a(ITEM);
    }

    public void setItem(@Nonnull ItemStack stack) {
        if (!stack.func_190926_b() && !(stack.func_77973_b() instanceof IVampirismThrowableItem)) {
            throw new IllegalArgumentException("EntityThrowable only accepts IVampirismThrowableItem, but not " + stack);
        }
        this.func_184212_Q().func_187227_b(ITEM, (Object)stack);
        this.func_184212_Q().func_187217_b(ITEM);
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        ItemStack stack = new ItemStack(compound.func_74775_l("thrownItem"));
        if (stack.func_190926_b()) {
            this.func_70106_y();
        } else {
            this.setItem(stack);
        }
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        ItemStack stack = this.getItem();
        if (!stack.func_190926_b()) {
            compound.func_74782_a("thrownItem", (NBTBase)stack.func_77955_b(new NBTTagCompound()));
        }
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.func_184212_Q().func_187214_a(ITEM, (Object)ItemStack.field_190927_a);
    }

    protected float func_70185_h() {
        return 0.05f;
    }

    protected void func_70184_a(RayTraceResult result) {
        ItemStack stack = this.getItem();
        if (!stack.func_190926_b()) {
            Item item = stack.func_77973_b();
            if (item instanceof IVampirismThrowableItem) {
                ((IVampirismThrowableItem)item).onImpact(this, stack, result, this.field_70170_p.field_72995_K);
            } else {
                VampirismMod.log.w("EntityThrowableItem", "Saved item (%s) is not an instance of IVampirismThrowableItem. This should not be able to happen", stack);
            }
        }
        if (!this.field_70170_p.field_72995_K) {
            this.func_70106_y();
        }
    }

    public static interface IVampirismThrowableItem {
        public void onImpact(EntityThrowableItem var1, ItemStack var2, RayTraceResult var3, boolean var4);
    }
}

