/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.entity;

import com.google.common.base.Predicate;
import com.google.common.collect.Lists;
import de.teamlapen.vampirism.VampirismMod;
import de.teamlapen.vampirism.api.VampirismAPI;
import de.teamlapen.vampirism.api.entity.factions.IFaction;
import de.teamlapen.vampirism.api.entity.factions.IFactionEntity;
import de.teamlapen.vampirism.api.entity.factions.IPlayableFaction;
import de.teamlapen.vampirism.entity.factions.FactionPlayerHandler;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraftforge.fml.common.IEntitySelectorFactory;
import net.minecraftforge.fml.common.registry.GameRegistry;

public class VampirismEntitySelectors {
    private static final String FACTION = "vampirism:faction";
    private static final String LEVEL = "vampirism:level";
    private static final String MIN_LEVEL = "vampirism:minLevel";
    private static final String MAX_LEVEL = "vampirism:maxLevel";

    private static void addFactionSelector(List<Predicate<Entity>> list, Map<String, String> arguments, ICommandSender sender) {
        String faction = arguments.get(FACTION);
        if (faction != null) {
            IFaction[] factions;
            boolean invert = faction.startsWith("!");
            if (invert) {
                faction = faction.substring(1);
            }
            for (IFaction f : factions = VampirismAPI.factionRegistry().getFactions()) {
                if (!f.name().equalsIgnoreCase(faction)) continue;
                list.add((Predicate<Entity>)((Predicate)input -> {
                    if (input instanceof IFactionEntity) {
                        boolean flag1 = f.equals(((IFactionEntity)input).getFaction());
                        return invert != flag1;
                    }
                    if (f instanceof IPlayableFaction && input instanceof EntityPlayer) {
                        boolean flag1 = FactionPlayerHandler.get((EntityPlayer)input).isInFaction((IPlayableFaction)f);
                        return invert != flag1;
                    }
                    return invert;
                }));
                return;
            }
            list.add((Predicate<Entity>)((Predicate)input -> false));
            sender.func_145747_a((ITextComponent)new TextComponentString("Unknown faction: " + faction));
        }
    }

    private static void addLevelSelector(List<Predicate<Entity>> list, Map<String, String> arguments) {
        String maxLevel;
        String minLevel;
        String level = arguments.get(LEVEL);
        if (level != null) {
            try {
                int l = Integer.parseInt(level);
                list.add((Predicate<Entity>)((Predicate)input -> input instanceof EntityPlayer && FactionPlayerHandler.get((EntityPlayer)input).getCurrentLevel() == l));
            }
            catch (NumberFormatException e) {
                VampirismMod.log.w("EntitySelectors", "Failed to parse level (%s)", level);
                list.add((Predicate<Entity>)((Predicate)input -> false));
            }
        }
        if ((minLevel = arguments.get(MIN_LEVEL)) != null) {
            try {
                int l = Integer.parseInt(minLevel);
                list.add((Predicate<Entity>)((Predicate)input -> input instanceof EntityPlayer && FactionPlayerHandler.get((EntityPlayer)input).getCurrentLevel() >= l));
            }
            catch (NumberFormatException e) {
                VampirismMod.log.w("EntitySelectors", "Failed to parse level (%s)", level);
                list.add((Predicate<Entity>)((Predicate)input -> false));
            }
        }
        if ((maxLevel = arguments.get(MAX_LEVEL)) != null) {
            try {
                int l = Integer.parseInt(maxLevel);
                list.add((Predicate<Entity>)((Predicate)input -> input instanceof EntityPlayer && FactionPlayerHandler.get((EntityPlayer)input).getCurrentLevel() <= l));
            }
            catch (NumberFormatException e) {
                VampirismMod.log.w("EntitySelectors", "Failed to parse level (%s)", level);
                list.add((Predicate<Entity>)((Predicate)input -> false));
            }
        }
    }

    public static void registerSelectors() {
        GameRegistry.registerEntitySelector((IEntitySelectorFactory)new IEntitySelectorFactory(){

            @Nonnull
            public List<Predicate<Entity>> createPredicates(Map<String, String> arguments, String mainSelector, ICommandSender sender, Vec3d position) {
                ArrayList list = Lists.newArrayList();
                VampirismEntitySelectors.addFactionSelector(list, arguments, sender);
                VampirismEntitySelectors.addLevelSelector(list, arguments);
                return list;
            }
        }, (String[])new String[]{FACTION, LEVEL, MIN_LEVEL, MAX_LEVEL});
    }
}

