/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.entity.ai;

import de.teamlapen.vampirism.core.ModSounds;
import de.teamlapen.vampirism.entity.EntityCrossbowArrow;
import de.teamlapen.vampirism.entity.EntityVampirism;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.MathHelper;

public class EntityAIAttackRangedCrossbow
extends EntityAIBase {
    private final EntityVampirism entity;
    private final double moveSpeedAmp;
    private final float maxAttackDistance;
    private final IAttackWithCrossbow attacker;
    private int attackCooldown;
    private int seeTime;
    private int strafingTime;
    private boolean strafingClockwise;
    private boolean strafingBackwards;
    private int attackTime;

    public EntityAIAttackRangedCrossbow(EntityVampirism entity, IAttackWithCrossbow attacker, double speedAmplifier, int delay, float maxDistance) {
        this.entity = entity;
        this.attacker = attacker;
        this.moveSpeedAmp = speedAmplifier;
        this.attackCooldown = delay;
        this.maxAttackDistance = maxDistance * maxDistance;
        this.func_75248_a(3);
    }

    public void func_75251_c() {
        super.func_75251_c();
        this.seeTime = 0;
        this.attackTime = -1;
        this.attacker.stopTargeting();
    }

    public boolean func_75253_b() {
        return (this.func_75250_a() || !this.entity.func_70661_as().func_75500_f()) && this.attacker.isCrossbowInMainhand();
    }

    public boolean func_75250_a() {
        return this.entity.func_70638_az() != null && this.attacker.isCrossbowInMainhand();
    }

    public void func_75249_e() {
        super.func_75249_e();
        this.attacker.startTargeting();
    }

    public void func_75246_d() {
        EntityLivingBase entitylivingbase = this.entity.func_70638_az();
        if (entitylivingbase != null) {
            boolean couldSee;
            double d0 = this.entity.func_70092_e(entitylivingbase.field_70165_t, entitylivingbase.func_174813_aQ().field_72338_b, entitylivingbase.field_70161_v);
            boolean canSee = this.entity.func_70635_at().func_75522_a((Entity)entitylivingbase);
            boolean bl = couldSee = this.seeTime > 0;
            if (canSee != couldSee) {
                this.seeTime = 0;
            }
            this.seeTime = canSee ? ++this.seeTime : --this.seeTime;
            if (d0 <= (double)this.maxAttackDistance && this.seeTime >= 20) {
                this.entity.func_70661_as().func_75499_g();
                ++this.strafingTime;
            } else {
                this.entity.func_70661_as().func_75497_a((Entity)entitylivingbase, this.moveSpeedAmp);
                this.strafingTime = -1;
            }
            if (this.strafingTime >= 20) {
                if ((double)this.entity.func_70681_au().nextFloat() < 0.3) {
                    boolean bl2 = this.strafingClockwise = !this.strafingClockwise;
                }
                if ((double)this.entity.func_70681_au().nextFloat() < 0.3) {
                    this.strafingBackwards = !this.strafingBackwards;
                }
                this.strafingTime = 0;
            }
            if (this.strafingTime > -1) {
                if (d0 > (double)(this.maxAttackDistance * 0.75f)) {
                    this.strafingBackwards = false;
                } else if (d0 < (double)(this.maxAttackDistance * 0.25f)) {
                    this.strafingBackwards = true;
                }
                this.entity.func_70605_aq().func_188488_a(this.strafingBackwards ? -0.5f : 0.5f, this.strafingClockwise ? 0.5f : -0.5f);
                this.entity.func_70625_a((Entity)entitylivingbase, 30.0f, 30.0f);
            } else {
                this.entity.func_70671_ap().func_75651_a((Entity)entitylivingbase, 30.0f, 30.0f);
            }
            if (--this.attackTime <= 0 && this.seeTime >= -30) {
                this.attackWithCrossbow(entitylivingbase);
                this.attackTime = this.attackCooldown;
            }
        }
    }

    protected void attackWithCrossbow(EntityLivingBase target) {
        ItemStack arrows = this.attacker.getArrowStackForAttack(target);
        EntityCrossbowArrow entityArrow = EntityCrossbowArrow.createWithShooter(this.entity.func_130014_f_(), (EntityLivingBase)this.entity, 0.0, 0.3f, !this.entity.func_184638_cS(), arrows);
        double sx = target.field_70165_t - entityArrow.field_70165_t;
        double sy = target.func_174813_aQ().field_72338_b + (double)(target.field_70131_O / 3.0f) - entityArrow.field_70163_u;
        double sz = target.field_70161_v - entityArrow.field_70161_v;
        double dist = MathHelper.func_76133_a((double)(sx * sx + sz * sz));
        entityArrow.func_70186_c(sx, sy + dist * 0.2, sz, 1.6f, 13 - target.func_130014_f_().func_175659_aa().func_151525_a() * 4);
        this.entity.func_184185_a(ModSounds.crossbow, 0.5f, 1.0f);
        this.entity.func_130014_f_().func_72838_d((Entity)entityArrow);
    }

    public static interface IAttackWithCrossbow {
        @Nonnull
        public ItemStack getArrowStackForAttack(EntityLivingBase var1);

        public boolean isCrossbowInMainhand();

        public void startTargeting();

        public void stopTargeting();
    }
}

