/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.entity.ai;

import java.util.Random;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public abstract class EntityAIFlee
extends EntityAIBase {
    private final EntityCreature theCreature;
    private final double movementSpeed;
    private final World world;
    private final boolean restrictToHome;
    private double shelterX;
    private double shelterY;
    private double shelterZ;

    public EntityAIFlee(EntityCreature theCreature, double movementSpeed, boolean restrictToHome) {
        this.theCreature = theCreature;
        this.movementSpeed = movementSpeed;
        this.restrictToHome = restrictToHome;
        this.world = theCreature.func_130014_f_();
        this.func_75248_a(1);
    }

    public boolean continueExecuting() {
        return !this.theCreature.func_70661_as().func_75500_f();
    }

    public boolean func_75250_a() {
        if (!this.shouldFlee()) {
            return false;
        }
        Vec3d vec3 = this.findPossibleShelter();
        if (vec3 == null) {
            return false;
        }
        this.shelterX = vec3.field_72450_a;
        this.shelterY = vec3.field_72448_b;
        this.shelterZ = vec3.field_72449_c;
        return true;
    }

    public void func_75249_e() {
        this.theCreature.func_70661_as().func_75492_a(this.shelterX, this.shelterY, this.shelterZ, this.movementSpeed);
    }

    protected abstract boolean isPositionAcceptable(World var1, BlockPos var2);

    protected abstract boolean shouldFlee();

    private Vec3d findPossibleShelter() {
        Random random = this.theCreature.func_70681_au();
        BlockPos blockpos = new BlockPos(this.theCreature.field_70165_t, this.theCreature.func_174813_aQ().field_72338_b, this.theCreature.field_70161_v);
        for (int i = 0; i < 10; ++i) {
            BlockPos blockpos1 = blockpos.func_177982_a(random.nextInt(20) - 10, random.nextInt(6) - 3, random.nextInt(20) - 10);
            if (!this.isPositionAcceptable(this.world, blockpos1) || this.restrictToHome && this.theCreature.func_110175_bO() && !this.theCreature.func_180485_d(blockpos1)) continue;
            return new Vec3d((double)blockpos1.func_177958_n(), (double)blockpos1.func_177956_o(), (double)blockpos1.func_177952_p());
        }
        return null;
    }
}

