/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.entity.vampire;

import de.teamlapen.lib.lib.util.UtilLib;
import de.teamlapen.vampirism.api.VReference;
import de.teamlapen.vampirism.api.VampirismAPI;
import de.teamlapen.vampirism.api.difficulty.Difficulty;
import de.teamlapen.vampirism.api.entity.actions.EntityActionTier;
import de.teamlapen.vampirism.api.entity.actions.IEntityActionUser;
import de.teamlapen.vampirism.api.entity.vampire.IBasicVampire;
import de.teamlapen.vampirism.api.world.IVampirismVillage;
import de.teamlapen.vampirism.config.Balance;
import de.teamlapen.vampirism.core.ModPotions;
import de.teamlapen.vampirism.core.ModSounds;
import de.teamlapen.vampirism.entity.action.EntityActionHandler;
import de.teamlapen.vampirism.entity.ai.EntityAIAttackMeleeNoSun;
import de.teamlapen.vampirism.entity.ai.EntityAIAttackVillage;
import de.teamlapen.vampirism.entity.ai.EntityAIDefendVillage;
import de.teamlapen.vampirism.entity.ai.EntityAIMoveThroughVillageCustom;
import de.teamlapen.vampirism.entity.ai.EntityAIWatchClosestVisible;
import de.teamlapen.vampirism.entity.ai.VampireAIBiteNearbyEntity;
import de.teamlapen.vampirism.entity.ai.VampireAIFleeGarlic;
import de.teamlapen.vampirism.entity.ai.VampireAIFleeSun;
import de.teamlapen.vampirism.entity.ai.VampireAIFollowAdvanced;
import de.teamlapen.vampirism.entity.ai.VampireAIMoveToBiteable;
import de.teamlapen.vampirism.entity.ai.VampireAIRestrictSun;
import de.teamlapen.vampirism.entity.hunter.EntityHunterBase;
import de.teamlapen.vampirism.entity.vampire.EntityAdvancedVampire;
import de.teamlapen.vampirism.entity.vampire.EntityVampireBase;
import de.teamlapen.vampirism.world.loot.LootHandler;
import de.teamlapen.vampirism.world.villages.VampirismVillageHelper;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAvoidEntity;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIBreakDoor;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.PathNavigateGround;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.FMLCommonHandler;

public class EntityBasicVampire
extends EntityVampireBase
implements IBasicVampire,
IEntityActionUser {
    private static final DataParameter<Integer> LEVEL = EntityDataManager.func_187226_a(EntityBasicVampire.class, (DataSerializer)DataSerializers.field_187192_b);
    private final int MAX_LEVEL = 2;
    private final int ANGRY_TICKS_PER_ATTACK = 120;
    private int bloodtimer = 100;
    private EntityAdvancedVampire advancedLeader = null;
    private int angryTimer = 0;
    private EntityAIBase tasks_avoidHunter;
    @Nullable
    private IVampirismVillage cachedVillage;
    @Nullable
    private AxisAlignedBB village_attack_area;
    @Nullable
    private AxisAlignedBB village_defense_area;

    @Override
    public boolean func_70097_a(DamageSource damageSource, float p_70097_2_) {
        IVampirismVillage v;
        boolean flag = super.func_70097_a(damageSource, p_70097_2_);
        if (flag) {
            this.angryTimer += 120;
        }
        if ((v = this.getCurrentFriendlyVillage()) != null) {
            v.addOrRenewAggressor(damageSource.func_76346_g());
        }
        return flag;
    }

    public EntityBasicVampire(World world) {
        super(world, true);
        this.canSuckBloodFromPlayer = true;
        this.hasArms = true;
        this.setSpawnRestriction(EntityVampireBase.SpawnRestriction.SPECIAL);
        this.func_70105_a(0.6f, 1.95f);
        this.entitytier = EntityActionTier.Medium;
        this.entityActionHandler = new EntityActionHandler<EntityBasicVampire>(this);
    }

    @Override
    @Nullable
    public IVampirismVillage getCurrentFriendlyVillage() {
        return this.cachedVillage != null ? (this.cachedVillage.getControllingFaction() == VReference.VAMPIRE_FACTION ? this.cachedVillage : null) : null;
    }

    @Override
    public void drinkBlood(int amt, float saturationMod) {
        super.drinkBlood(amt, saturationMod);
        boolean dedicated = FMLCommonHandler.instance().getMinecraftServerInstance().func_71262_S();
        this.bloodtimer += amt * 40 + this.func_70681_au().nextInt(1000) * (dedicated ? 2 : 1);
    }

    @Nullable
    public EntityAdvancedVampire getAdvancedLeader() {
        return this.advancedLeader;
    }

    public void setAdvancedLeader(@Nullable EntityAdvancedVampire advancedLeader) {
        this.advancedLeader = advancedLeader;
    }

    @Override
    public int getLevel() {
        return (Integer)this.func_184212_Q().func_187225_a(LEVEL);
    }

    @Override
    public void setLevel(int level) {
        if (level >= 0) {
            this.func_184212_Q().func_187227_b(LEVEL, (Object)level);
            this.updateEntityAttributes();
            if (level == 2) {
                this.func_70690_d(new PotionEffect(MobEffects.field_76429_m, 1000000, 1));
            }
            if (level == 1) {
                this.func_184201_a(EntityEquipmentSlot.MAINHAND, new ItemStack(Items.field_151040_l));
            } else {
                this.func_184201_a(EntityEquipmentSlot.MAINHAND, ItemStack.field_190927_a);
            }
        }
    }

    @Override
    public int getMaxLevel() {
        return 2;
    }

    public int func_70627_aG() {
        return 600;
    }

    @Override
    public boolean isIgnoringSundamage() {
        float health = this.func_110143_aJ() / this.func_110138_aP();
        return super.isIgnoringSundamage() || this.angryTimer > 0 && health < 0.7f || health < 0.3f;
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (this.bloodtimer > 0) {
            --this.bloodtimer;
        }
        if (this.angryTimer > 0) {
            --this.angryTimer;
        }
        if (this.field_70173_aa % 9 == 3 && this.func_70644_a(MobEffects.field_76426_n)) {
            PotionEffect fireResistance = this.func_184596_c(MobEffects.field_76426_n);
            this.func_70688_c(fireResistance);
            this.func_70690_d(new PotionEffect(ModPotions.fire_protection, fireResistance.func_76459_b(), fireResistance.func_76458_c()));
        }
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.advancedLeader != null && !this.advancedLeader.func_70089_S()) {
            this.advancedLeader = null;
        }
        if (!this.field_70170_p.field_72995_K && this.field_70173_aa % 40 == 8) {
            this.cachedVillage = VampirismVillageHelper.getNearestVillage((Entity)this);
        }
    }

    public void func_70020_e(NBTTagCompound tagCompund) {
        super.func_70020_e(tagCompund);
        if (tagCompund.func_74764_b("level")) {
            this.setLevel(tagCompund.func_74762_e("level"));
        }
        if (tagCompund.func_74764_b("village_attack_area")) {
            this.attackVillage(UtilLib.intToBB(tagCompund.func_74759_k("village_attack_area")));
        } else if (tagCompund.func_74764_b("village_defense_area")) {
            this.defendVillage(UtilLib.intToBB(tagCompund.func_74759_k("village_defense_area")));
        }
    }

    public void func_70106_y() {
        super.func_70106_y();
        if (this.advancedLeader != null) {
            this.advancedLeader.decreaseFollowerCount();
        }
    }

    @Override
    public int suggestLevel(Difficulty d) {
        switch (this.field_70146_Z.nextInt(5)) {
            case 0: {
                return (int)((float)d.minPercLevel / 100.0f * 2.0f);
            }
            case 1: {
                return (int)((float)d.avgPercLevel / 100.0f * 2.0f);
            }
            case 2: {
                return (int)((float)d.maxPercLevel / 100.0f * 2.0f);
            }
        }
        return this.field_70146_Z.nextInt(3);
    }

    @Override
    public boolean wantsBlood() {
        return this.bloodtimer == 0;
    }

    @Override
    public void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        nbt.func_74768_a("level", this.getLevel());
        if (this.village_attack_area != null) {
            nbt.func_74783_a("village_attack_area", UtilLib.bbToInt(this.village_attack_area));
        } else if (this.village_defense_area != null) {
            nbt.func_74783_a("village_defense_area", UtilLib.bbToInt(this.village_defense_area));
        }
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.updateEntityAttributes();
    }

    @Override
    protected float calculateFireDamage(float amount) {
        float protectionMod = 1.0f;
        PotionEffect protection = this.func_70660_b(ModPotions.fire_protection);
        if (protection != null) {
            protectionMod = 1.0f / (2.0f + (float)protection.func_76458_c());
        }
        return (float)((double)(amount * protectionMod) * Balance.mobProps.VAMPIRE_FIRE_VULNERABILITY) * ((float)this.getLevel() * 0.5f + 1.0f);
    }

    protected void func_184610_a(boolean wasRecentlyHit, int lootingModifier, DamageSource source) {
        super.func_184610_a(wasRecentlyHit, lootingModifier, source);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.func_184212_Q().func_187214_a(LEVEL, (Object)-1);
    }

    protected SoundEvent func_184639_G() {
        return ModSounds.entity_vampire_scream;
    }

    protected int func_70693_a(EntityPlayer player) {
        return 6 + this.getLevel();
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return LootHandler.BASIC_VAMPIRE;
    }

    @Override
    public void attackVillage(AxisAlignedBB area) {
        this.field_70714_bg.func_85156_a(this.tasks_avoidHunter);
        this.village_attack_area = area;
    }

    @Override
    public void defendVillage(AxisAlignedBB area) {
        this.field_70714_bg.func_85156_a(this.tasks_avoidHunter);
        this.village_defense_area = area;
    }

    @Override
    @Nullable
    public AxisAlignedBB getTargetVillageArea() {
        return this.village_attack_area == null ? this.village_defense_area : this.village_attack_area;
    }

    @Override
    public boolean isAttackingVillage() {
        return this.village_attack_area != null;
    }

    @Override
    public void stopVillageAttackDefense() {
        this.func_96094_a("");
        if (this.village_defense_area != null) {
            this.field_70714_bg.func_75776_a(2, this.tasks_avoidHunter);
            this.village_defense_area = null;
        } else if (this.village_attack_area != null) {
            this.field_70714_bg.func_75776_a(2, this.tasks_avoidHunter);
            this.village_attack_area = null;
        }
    }

    @Override
    protected void func_184651_r() {
        super.func_184651_r();
        if (this.field_70170_p.func_175659_aa() == EnumDifficulty.HARD) {
            this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIBreakDoor((EntityLiving)this));
            ((PathNavigateGround)this.func_70661_as()).func_179688_b(true);
        }
        this.tasks_avoidHunter = new EntityAIAvoidEntity((EntityCreature)this, EntityCreature.class, VampirismAPI.factionRegistry().getPredicate(this.getFaction(), false, true, false, false, VReference.HUNTER_FACTION), 10.0f, 1.0, 1.1);
        this.field_70714_bg.func_75776_a(2, this.tasks_avoidHunter);
        this.field_70714_bg.func_75776_a(2, new VampireAIRestrictSun<EntityBasicVampire>(this));
        this.field_70714_bg.func_75776_a(3, new VampireAIFleeSun<EntityBasicVampire>(this, 0.9, false));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new VampireAIFleeGarlic(this, 0.9, false));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIAttackMeleeNoSun(this, 1.0, false));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new VampireAIBiteNearbyEntity(this));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new VampireAIFollowAdvanced(this, 1.0));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new VampireAIMoveToBiteable(this, 0.75));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAIMoveThroughVillageCustom(this, 0.6, true, 600));
        this.field_70714_bg.func_75776_a(9, (EntityAIBase)new EntityAIWander((EntityCreature)this, 0.7));
        this.field_70714_bg.func_75776_a(10, (EntityAIBase)new EntityAIWatchClosestVisible((EntityLiving)this, EntityPlayer.class, 20.0f, 0.6f));
        this.field_70714_bg.func_75776_a(10, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityHunterBase.class, 17.0f));
        this.field_70714_bg.func_75776_a(10, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
        this.field_70715_bh.func_75776_a(4, new EntityAIAttackVillage<EntityBasicVampire>(this));
        this.field_70715_bh.func_75776_a(4, new EntityAIDefendVillage<EntityBasicVampire>(this));
        this.field_70715_bh.func_75776_a(5, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, 5, true, false, VampirismAPI.factionRegistry().getPredicate(this.getFaction(), true, false, true, false, null)));
        this.field_70715_bh.func_75776_a(6, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityCreature.class, 5, true, false, VampirismAPI.factionRegistry().getPredicate(this.getFaction(), false, true, false, false, null)));
    }

    protected void updateEntityAttributes() {
        int l = Math.max(this.getLevel(), 0);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(Balance.mobProps.VAMPIRE_MAX_HEALTH + Balance.mobProps.VAMPIRE_MAX_HEALTH_PL * (double)l);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(Balance.mobProps.VAMPIRE_ATTACK_DAMAGE + Balance.mobProps.VAMPIRE_ATTACK_DAMAGE_PL * (double)l);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(Balance.mobProps.VAMPIRE_SPEED);
    }
}

