/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.inventory;

import de.teamlapen.lib.lib.util.FluidLib;
import de.teamlapen.lib.lib.util.ItemStackUtil;
import de.teamlapen.lib.lib.util.UtilLib;
import de.teamlapen.vampirism.VampirismMod;
import de.teamlapen.vampirism.api.entity.player.hunter.IHunterPlayer;
import de.teamlapen.vampirism.api.entity.player.skills.ISkill;
import de.teamlapen.vampirism.api.entity.player.skills.ISkillHandler;
import de.teamlapen.vampirism.api.items.IAlchemicalCauldronRecipe;
import java.util.Arrays;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.init.Enchantments;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class AlchemicalCauldronRecipe
implements IAlchemicalCauldronRecipe {
    private static final ISkill[] EMPTY_SKILLS = new ISkill[0];
    @Nonnull
    private final ItemStack output;
    @Nonnull
    private final ItemStack ingredient;
    private final FluidStack fluidStack;
    private final ItemStack fluidItem;
    @Nullable
    private ISkill[] skills = null;
    private int reqLevel = 0;
    private int cookingTime = 400;
    private float experience = 0.2f;
    @Nonnull
    private ItemStack descriptiveStack = ItemStack.field_190927_a;

    AlchemicalCauldronRecipe(@Nonnull ItemStack output, ItemStack liquid, @Nonnull ItemStack ingredient) {
        if (FluidLib.hasFluidItemCap(liquid)) {
            IFluidHandler handler = FluidLib.getFluidItemCap(liquid);
            FluidStack stack = handler.drain(Integer.MAX_VALUE, false);
            if (stack != null) {
                VampirismMod.log.d("AlchemicalCauldron", "Replaced %s liquid item with %s fluid stack", liquid, stack);
                this.fluidStack = stack;
                this.fluidItem = ItemStack.field_190927_a;
                this.descriptiveStack = liquid;
            } else {
                VampirismMod.log.d("AlchemicalCauldron", "Could not extract fluid from fluid container item %s", liquid);
                this.fluidStack = null;
                this.fluidItem = liquid;
            }
        } else {
            this.fluidItem = liquid;
            this.fluidStack = null;
        }
        this.ingredient = ingredient;
        if (output.func_190926_b()) {
            throw new IllegalArgumentException("AlchemicalCauldron: Output cannot be empty (" + liquid + "," + ingredient + ")");
        }
        this.output = output;
    }

    AlchemicalCauldronRecipe(@Nonnull ItemStack output, FluidStack fluidStack, @Nonnull ItemStack ingredient) {
        this.fluidStack = fluidStack;
        this.fluidItem = ItemStack.field_190927_a;
        this.ingredient = ingredient;
        if (output.func_190926_b()) {
            throw new IllegalArgumentException("AlchemicalCauldron: Output cannot be empty (" + fluidStack + "," + ingredient + ")");
        }
        this.output = output;
    }

    @Override
    public boolean areSameIngredients(IAlchemicalCauldronRecipe recipe) {
        if (recipe instanceof AlchemicalCauldronRecipe) {
            AlchemicalCauldronRecipe r2 = (AlchemicalCauldronRecipe)recipe;
            if (ItemStack.func_77989_b((ItemStack)r2.fluidItem, (ItemStack)this.fluidItem) && ItemStack.func_77989_b((ItemStack)r2.ingredient, (ItemStack)this.ingredient) && FluidLib.areFluidStacksEqual(r2.fluidStack, this.fluidStack)) {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean canBeCooked(int level, ISkillHandler<IHunterPlayer> skillHandler) {
        if (level < this.reqLevel) {
            return false;
        }
        if (this.skills == null) {
            return true;
        }
        for (ISkill s : this.skills) {
            if (skillHandler.isSkillEnabled(s)) continue;
            return false;
        }
        return true;
    }

    @Override
    @SafeVarargs
    public final IAlchemicalCauldronRecipe configure(int ticks, float exp, int reqLevel, ISkill ... reqSkills) {
        return this.setCookingTime(ticks).setExperience(exp).setRequirements(reqLevel, reqSkills);
    }

    @Override
    public int getCookingTime() {
        return this.cookingTime;
    }

    @Override
    @Nonnull
    public ItemStack getDescriptiveFluidStack() {
        if (!this.descriptiveStack.func_190926_b()) {
            return this.descriptiveStack;
        }
        if (!this.fluidItem.func_190926_b()) {
            return this.fluidItem;
        }
        this.descriptiveStack = new ItemStack(Items.field_151133_ar);
        this.addFluidStackDescription(this.descriptiveStack, this.fluidStack);
        return this.descriptiveStack;
    }

    @Override
    public float getExperience() {
        return this.experience;
    }

    @Override
    @Nonnull
    public ItemStack getIngredient() {
        return this.ingredient;
    }

    @Override
    @Nonnull
    public ItemStack getOutput() {
        return this.output;
    }

    @Override
    public int getRequiredLevel() {
        return this.reqLevel;
    }

    @Override
    @Nonnull
    public ISkill[] getRequiredSkills() {
        return this.skills == null ? EMPTY_SKILLS : this.skills;
    }

    @Override
    @Nullable
    public FluidStack isValidFluidItem(@Nonnull ItemStack stack) {
        if (this.fluidStack == null) {
            return null;
        }
        if (FluidLib.hasFluidItemCap(stack)) {
            IFluidHandler handler = FluidLib.getFluidItemCap(stack);
            FluidStack drained = handler.drain(this.fluidStack, false);
            if (drained == null || !drained.isFluidStackIdentical(this.fluidStack)) {
                return null;
            }
            return this.fluidStack.copy();
        }
        return null;
    }

    @Override
    @Nullable
    public FluidStack isValidFluidStack(FluidStack stack) {
        return this.fluidStack != null && stack != null && stack.containsFluid(this.fluidStack) ? this.fluidStack.copy() : null;
    }

    @Override
    public boolean isValidLiquidItem(@Nonnull ItemStack stack) {
        return !this.fluidItem.func_190926_b() && !stack.func_190926_b() && ItemStackUtil.doesStackContain(stack, this.fluidItem);
    }

    @Override
    public IAlchemicalCauldronRecipe setCookingTime(int ticks) {
        this.cookingTime = ticks;
        return this;
    }

    @Override
    public IAlchemicalCauldronRecipe setExperience(float exp) {
        this.experience = exp;
        return this;
    }

    @Override
    public IAlchemicalCauldronRecipe setRequirements(int reqLevel, ISkill ... reqSkills) {
        this.reqLevel = reqLevel;
        this.skills = reqSkills;
        return this;
    }

    public String toString() {
        return "AlchemicalCauldronRecipe{cookingTime=" + this.cookingTime + ", skills=" + Arrays.toString(this.skills) + ", output=" + this.output + ", ingredient=" + this.ingredient + ", reqLevel=" + this.reqLevel + ", experience=" + this.experience + ", fluidStack=" + this.fluidStack + ", fluidItem=" + this.fluidItem + '}';
    }

    private void addFluidStackDescription(ItemStack stack, FluidStack fluidStack) {
        NBTTagCompound nbt = stack.func_77978_p();
        if (nbt == null) {
            nbt = new NBTTagCompound();
        }
        NBTTagCompound display = nbt.func_150297_b("display", 10) ? nbt.func_74775_l("display") : new NBTTagCompound();
        NBTTagList lore = nbt.func_150297_b("Lore", 0) ? nbt.func_150295_c("Lore", 9) : new NBTTagList();
        lore.func_74742_a((NBTBase)new NBTTagString(UtilLib.translate("text.vampirism.liquid_container")));
        display.func_74782_a("Lore", (NBTBase)lore);
        nbt.func_74782_a("display", (NBTBase)display);
        stack.func_77982_d(nbt);
        stack.func_77966_a(Enchantments.field_185307_s, 1);
        stack.func_151001_c(fluidStack.getLocalizedName() + ": " + fluidStack.amount + "mB");
    }
}

