/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.inventory;

import de.teamlapen.lib.lib.inventory.InventoryContainer;
import de.teamlapen.lib.lib.inventory.InventoryHelper;
import de.teamlapen.vampirism.VampirismMod;
import de.teamlapen.vampirism.api.VReference;
import de.teamlapen.vampirism.core.ModBlocks;
import de.teamlapen.vampirism.core.ModItems;
import de.teamlapen.vampirism.entity.factions.FactionPlayerHandler;
import de.teamlapen.vampirism.inventory.HunterTableInventory;
import de.teamlapen.vampirism.player.hunter.HunterLevelingConf;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCraftResult;
import net.minecraft.inventory.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;

public class HunterTableContainer
extends InventoryContainer {
    public static final Item[] items = new Item[]{Items.field_151122_aG, ModItems.vampire_fang, ModItems.pure_blood, ModItems.vampire_book};
    private final HunterTableInventory inventory;
    private final SlotResult slotResult;
    private final int hunterLevel;
    private final HunterLevelingConf levelingConf = HunterLevelingConf.instance();
    private final BlockPos pos;
    private ItemStack missing = ItemStack.field_190927_a;
    public boolean endVersion = false;
    public boolean wearingHat = false;

    public HunterTableContainer(EntityPlayer player, BlockPos pos) {
        super(player.field_71071_by, new HunterTableInventory(items));
        this.inventory = (HunterTableInventory)this.tile;
        this.inventory.setChangeListener(this);
        this.pos = pos;
        this.slotResult = new SlotResult(this, (IInventory)new InventoryCraftResult(){

            public int func_70297_j_() {
                return 1;
            }
        }, 0, 146, 28);
        this.func_75146_a(this.slotResult);
        this.hunterLevel = FactionPlayerHandler.get(player).getCurrentLevel(VReference.HUNTER_FACTION);
        try {
            IBlockState state = player.field_70170_p.func_180495_p(pos);
            if (((Object)((Object)ModBlocks.hunter_table2)).equals(state.func_177230_c())) {
                this.endVersion = true;
            }
            for (ItemStack s : player.func_184193_aE()) {
                if (!((Object)((Object)ModItems.hunter_hat1_head)).equals(s.func_77973_b()) && !((Object)((Object)ModItems.hunter_hat0_head)).equals(s.func_77973_b())) continue;
                this.wearingHat = true;
            }
        }
        catch (Exception e) {
            VampirismMod.log.e("Easter", e, "Failed", new Object[0]);
        }
    }

    @Override
    public boolean func_75145_c(EntityPlayer playerIn) {
        return playerIn.func_70092_e((double)this.pos.func_177958_n() + 0.5, (double)this.pos.func_177956_o() + 0.5, (double)this.pos.func_177952_p() + 0.5) <= 64.0;
    }

    public HunterTableInventory getHunterInventory() {
        return this.inventory;
    }

    public ItemStack getMissingItems() {
        return this.missing;
    }

    public boolean isLevelValid() {
        return this.levelingConf.isLevelValidForTable(this.hunterLevel + 1) && (this.hunterLevel != 14 || this.endVersion);
    }

    public void func_75134_a(EntityPlayer playerIn) {
        super.func_75134_a(playerIn);
        if (!playerIn.func_130014_f_().field_72995_K) {
            for (int i = 0; i < this.inventory.func_70302_i_(); ++i) {
                ItemStack itemstack = this.inventory.func_70304_b(i);
                if (itemstack.func_190926_b()) continue;
                playerIn.func_71019_a(itemstack, false);
            }
        }
    }

    @Override
    public void onInventoryChanged() {
        if (this.inventory != null && this.isLevelValid()) {
            int[] req = this.levelingConf.getItemRequirementsForTable(this.hunterLevel + 1);
            this.missing = this.checkItems(req[0], req[1], req[2], req[3]);
            if (this.missing.func_190926_b()) {
                this.slotResult.field_75224_c.func_70299_a(0, new ItemStack((Item)ModItems.hunter_intel, 1, this.levelingConf.getHunterIntelMetaForLevel(this.hunterLevel + 1)));
            } else {
                this.slotResult.field_75224_c.func_70299_a(0, ItemStack.field_190927_a);
            }
        }
    }

    protected void onPickupResult() {
        int[] req = this.levelingConf.getItemRequirementsForTable(this.hunterLevel + 1);
        InventoryHelper.removeItems(this.inventory, new int[]{1, req[0], req[1], req[3]});
        this.onInventoryChanged();
    }

    private ItemStack checkItems(int fangs, int blood, int bloodMeta, int par3) {
        return InventoryHelper.checkItems(this.inventory, items, new int[]{1, fangs, blood, par3}, new int[]{Short.MAX_VALUE, Short.MAX_VALUE, bloodMeta == 0 ? Short.MAX_VALUE : -bloodMeta, Short.MAX_VALUE});
    }

    private class SlotResult
    extends Slot {
        private final HunterTableContainer container;

        public SlotResult(HunterTableContainer container, IInventory inventory, int index, int xPosition, int yPosition) {
            super(inventory, index, xPosition, yPosition);
            this.container = container;
        }

        public boolean func_75214_a(ItemStack stack) {
            return false;
        }

        public ItemStack func_190901_a(EntityPlayer playerIn, ItemStack stack) {
            this.container.onPickupResult();
            return stack;
        }
    }
}

