/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.inventory;

import de.teamlapen.vampirism.api.items.IHunterWeaponRecipe;
import de.teamlapen.vampirism.blocks.BlockWeaponTable;
import de.teamlapen.vampirism.inventory.HunterWeaponCraftingManager;
import de.teamlapen.vampirism.player.hunter.HunterPlayer;
import javax.annotation.Nullable;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class HunterWeaponTableCraftingSlot
extends Slot {
    private final EntityPlayer player;
    private final World world;
    private final BlockPos pos;
    private final InventoryCrafting craftMatrix;
    private int amountCrafted = 0;

    public HunterWeaponTableCraftingSlot(EntityPlayer player, World world, BlockPos pos, InventoryCrafting craftingInventory, IInventory inventoryIn, int index, int xPosition, int yPosition) {
        super(inventoryIn, index, xPosition, yPosition);
        this.player = player;
        this.craftMatrix = craftingInventory;
        this.world = world;
        this.pos = pos;
    }

    public ItemStack func_75209_a(int amount) {
        if (this.func_75216_d()) {
            this.amountCrafted += Math.min(amount, this.func_75211_c().func_190916_E());
        }
        return super.func_75209_a(amount);
    }

    public boolean func_75214_a(@Nullable ItemStack stack) {
        return false;
    }

    public ItemStack func_190901_a(EntityPlayer playerIn, ItemStack stack) {
        this.func_75208_c(stack);
        int lava = 0;
        IBlockState blockState = this.world.func_180495_p(this.pos);
        if (blockState.func_177230_c() instanceof BlockWeaponTable) {
            lava = (Integer)blockState.func_177229_b((IProperty)BlockWeaponTable.LAVA);
        }
        HunterPlayer hunterPlayer = HunterPlayer.get(playerIn);
        IHunterWeaponRecipe recipe = HunterWeaponCraftingManager.getInstance().findMatchingRecipe(this.craftMatrix, playerIn.func_130014_f_(), hunterPlayer.getLevel(), hunterPlayer.getSkillHandler(), lava);
        if (recipe != null && recipe.getRequiredLavaUnits() > 0) {
            lava = Math.max(0, lava - recipe.getRequiredLavaUnits());
            if (blockState.func_177230_c() instanceof BlockWeaponTable) {
                this.world.func_175656_a(this.pos, blockState.func_177226_a((IProperty)BlockWeaponTable.LAVA, (Comparable)Integer.valueOf(lava)));
            }
        }
        NonNullList<ItemStack> remaining = recipe == null ? HunterWeaponCraftingManager.getInstance().getRemainingItems(this.craftMatrix, playerIn.func_130014_f_(), hunterPlayer.getLevel(), hunterPlayer.getSkillHandler(), lava) : recipe.getRemainingItems(this.craftMatrix);
        for (int i = 0; i < remaining.size(); ++i) {
            ItemStack itemstack = this.craftMatrix.func_70301_a(i);
            ItemStack itemstack1 = (ItemStack)remaining.get(i);
            if (!itemstack.func_190926_b()) {
                this.craftMatrix.func_70298_a(i, 1);
                itemstack = this.craftMatrix.func_70301_a(i);
            }
            if (itemstack1.func_190926_b()) continue;
            if (itemstack.func_190926_b()) {
                this.craftMatrix.func_70299_a(i, itemstack1);
                continue;
            }
            if (ItemStack.func_179545_c((ItemStack)itemstack, (ItemStack)itemstack1) && ItemStack.func_77970_a((ItemStack)itemstack, (ItemStack)itemstack1)) {
                itemstack1.func_190917_f(itemstack.func_190916_E());
                this.craftMatrix.func_70299_a(i, itemstack1);
                continue;
            }
            if (this.player.field_71071_by.func_70441_a(itemstack1)) continue;
            this.player.func_71019_a(itemstack1, false);
        }
        if (recipe != null && !this.world.field_72995_K) {
            this.world.func_175718_b(1030, this.pos, 0);
        }
        return stack;
    }

    protected void func_75208_c(ItemStack stack) {
        if (this.amountCrafted > 0) {
            stack.func_77980_a(this.player.func_130014_f_(), this.player, this.amountCrafted);
        }
        this.amountCrafted = 0;
    }

    protected void func_75210_a(ItemStack stack, int amount) {
        this.amountCrafted += amount;
        this.func_75208_c(stack);
    }
}

