/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.items;

import de.teamlapen.vampirism.config.Configs;
import de.teamlapen.vampirism.core.ModFluids;
import de.teamlapen.vampirism.items.ItemBloodBottle;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.FluidTankProperties;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fluids.capability.IFluidTankProperties;

public class BloodBottleFluidHandler
implements IFluidHandlerItem,
ICapabilityProvider {
    public static final int MULTIPLIER = 100;
    private final int capacity;
    @Nonnull
    protected ItemStack container;

    public static int getAdjustedAmount(int amt) {
        return amt - amt % 100;
    }

    public BloodBottleFluidHandler(@Nonnull ItemStack container, int capacity) {
        this.container = container;
        this.capacity = capacity;
    }

    @Nullable
    public FluidStack drain(FluidStack resource, boolean doDrain) {
        if (this.container.func_190916_E() != 1 || resource == null || resource.amount <= 0 || !ModFluids.blood.equals(resource.getFluid())) {
            return null;
        }
        return this.drain(resource.amount, doDrain);
    }

    @Nullable
    public FluidStack drain(int maxDrain, boolean doDrain) {
        int currentAmt = this.getBlood(this.container);
        if (currentAmt == 0) {
            return null;
        }
        FluidStack stack = new FluidStack(ModFluids.blood, Math.min(currentAmt, BloodBottleFluidHandler.getAdjustedAmount(maxDrain)));
        if (doDrain) {
            this.setBlood(this.container, currentAmt - stack.amount);
            if (this.getBlood(this.container) == 0 && Configs.autoConvertGlasBottles) {
                this.container = new ItemStack(Items.field_151069_bo);
            }
        }
        return stack;
    }

    public int fill(FluidStack resource, boolean doFill) {
        if (resource == null) {
            return 0;
        }
        if (!resource.getFluid().equals(ModFluids.blood)) {
            return 0;
        }
        if (!doFill) {
            return Math.min(this.capacity - this.getBlood(this.container), BloodBottleFluidHandler.getAdjustedAmount(resource.amount));
        }
        int itemamt = this.getBlood(this.container);
        int toFill = Math.min(this.capacity - itemamt, BloodBottleFluidHandler.getAdjustedAmount(resource.amount));
        this.setBlood(this.container, itemamt + toFill);
        return toFill;
    }

    public int getBlood(ItemStack stack) {
        return stack.func_77973_b() instanceof ItemBloodBottle ? stack.func_77952_i() * 100 : 0;
    }

    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        return (T)(capability == CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY ? this : null);
    }

    @Nonnull
    public ItemStack getContainer() {
        return this.container;
    }

    public IFluidTankProperties[] getTankProperties() {
        return new IFluidTankProperties[]{new FluidTankProperties(new FluidStack(ModFluids.blood, this.getBlood(this.container)), this.capacity)};
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY;
    }

    public void setBlood(ItemStack stack, int amt) {
        stack.func_77964_b(amt / 100);
    }
}

