/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.items;

import com.google.common.collect.Multimap;
import de.teamlapen.vampirism.api.items.IItemWithTier;
import de.teamlapen.vampirism.items.IItemWithTierNBTImpl;
import de.teamlapen.vampirism.items.VampirismHunterArmor;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemArmorOfSwiftness
extends VampirismHunterArmor
implements IItemWithTierNBTImpl {
    private static final String baseRegName = "armor_of_swiftness";
    private final int[] DAMAGE_REDUCTION_ULTIMATE = new int[]{3, 6, 8, 3};
    private final int[] DAMAGE_REDUCTION_ENHANCED = new int[]{2, 5, 6, 2};
    private final int[] DAMAGE_REDUCTION_NORMAL = new int[]{1, 2, 3, 1};

    public ItemArmorOfSwiftness(EntityEquipmentSlot equipmentSlotIn) {
        super(ItemArmor.ArmorMaterial.LEATHER, equipmentSlotIn, baseRegName);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        this.addTierInformation(stack, tooltip);
    }

    public String getArmorTexture(ItemStack stack, Entity entity, EntityEquipmentSlot slot, String type) {
        if (type == null) {
            return this.getTextureLocationLeather(slot);
        }
        switch (this.getTier(stack)) {
            case ENHANCED: {
                return this.getTextureLocation("swiftness_enhanced", slot, type);
            }
            case ULTIMATE: {
                return this.getTextureLocation("swiftness_ultimate", slot, type);
            }
        }
        return this.getTextureLocation("swiftness", slot, type);
    }

    @Override
    public Multimap<String, AttributeModifier> getAttributeModifiers(EntityEquipmentSlot equipmentSlot, ItemStack stack) {
        Multimap<String, AttributeModifier> multimap = super.getAttributeModifiers(equipmentSlot, stack);
        if (equipmentSlot == this.field_77881_a) {
            IItemWithTier.TIER tier = this.getTier(stack);
            multimap.put((Object)SharedMonsterAttributes.field_111263_d.func_111108_a(), (Object)new AttributeModifier(VAMPIRISM_ARMOR_MODIFIER[equipmentSlot.func_188454_b()], "Armor Swiftness", this.getSpeedBoost(tier), 2));
        }
        return multimap;
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (this.func_194125_a(tab)) {
            for (IItemWithTier.TIER t : IItemWithTier.TIER.values()) {
                items.add((Object)this.setTier(new ItemStack((Item)this), t));
            }
        }
    }

    @Override
    public void onArmorTick(World world, EntityPlayer player, ItemStack itemStack) {
        super.onArmorTick(world, player, itemStack);
        if (player.field_70173_aa % 45 == 3 && this.field_77881_a == EntityEquipmentSlot.CHEST) {
            boolean flag = true;
            int boost = Integer.MAX_VALUE;
            for (ItemStack stack : player.field_71071_by.field_70460_b) {
                if (!stack.func_190926_b() && stack.func_77973_b() instanceof ItemArmorOfSwiftness) {
                    int b = this.getJumpBoost(this.getTier(stack));
                    if (b >= boost) continue;
                    boost = b;
                    continue;
                }
                flag = false;
                break;
            }
            if (flag && boost > -1) {
                player.func_70690_d(new PotionEffect(MobEffects.field_76430_j, 50, boost, false, false));
            }
        }
    }

    @Override
    protected int getDamageReduction(int slot, ItemStack stack) {
        IItemWithTier.TIER tier = this.getTier(stack);
        switch (tier) {
            case ULTIMATE: {
                return this.DAMAGE_REDUCTION_ULTIMATE[slot];
            }
            case ENHANCED: {
                return this.DAMAGE_REDUCTION_ENHANCED[slot];
            }
        }
        return this.DAMAGE_REDUCTION_NORMAL[slot];
    }

    private int getJumpBoost(IItemWithTier.TIER tier) {
        switch (tier) {
            case ULTIMATE: {
                return 1;
            }
            case ENHANCED: {
                return 0;
            }
        }
        return -1;
    }

    private double getSpeedBoost(IItemWithTier.TIER tier) {
        switch (tier) {
            case ULTIMATE: {
                return 0.1;
            }
            case ENHANCED: {
                return 0.075;
            }
        }
        return 0.035;
    }

    private String getTextureLocationLeather(EntityEquipmentSlot slot) {
        return String.format("minecraft:textures/models/armor/leather_layer_%d.png", slot == EntityEquipmentSlot.LEGS ? 2 : 1);
    }
}

