/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.items;

import de.teamlapen.lib.lib.util.UtilLib;
import de.teamlapen.vampirism.VampirismMod;
import de.teamlapen.vampirism.api.EnumStrength;
import de.teamlapen.vampirism.api.items.IItemWithTier;
import de.teamlapen.vampirism.items.VampirismItem;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemHolyWaterBottle
extends VampirismItem
implements IItemWithTier {
    public static final String regName = "holy_water_bottle";

    public ItemHolyWaterBottle(String regName) {
        super(regName);
        this.func_77625_d(1);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        IItemWithTier.TIER t = this.getTier(stack);
        if (t != IItemWithTier.TIER.NORMAL) {
            tooltip.add(TextFormatting.AQUA + UtilLib.translate("text.vampirism.item_tier." + t.name().toLowerCase()));
        }
    }

    public ItemStack getStack(IItemWithTier.TIER tier) {
        return this.setTier(new ItemStack((Item)this), tier);
    }

    public EnumStrength getStrength(IItemWithTier.TIER tier) {
        switch (tier) {
            case NORMAL: {
                return EnumStrength.WEAK;
            }
            case ENHANCED: {
                return EnumStrength.MEDIUM;
            }
            case ULTIMATE: {
                return EnumStrength.STRONG;
            }
        }
        return EnumStrength.NONE;
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (this.func_194125_a(tab)) {
            for (IItemWithTier.TIER t : IItemWithTier.TIER.values()) {
                items.add((Object)this.setTier(new ItemStack((Item)this), t));
            }
        }
    }

    @Override
    public IItemWithTier.TIER getTier(@Nonnull ItemStack stack) {
        NBTTagCompound tag = UtilLib.checkNBT(stack);
        if (tag.func_74764_b("tier")) {
            try {
                return IItemWithTier.TIER.valueOf(tag.func_74779_i("tier"));
            }
            catch (IllegalArgumentException e) {
                VampirismMod.log.e("HolyWaterBottle", e, "Unknown item tier %s", tag.func_74779_i("tier"));
            }
        }
        return IItemWithTier.TIER.NORMAL;
    }

    @Override
    @Nonnull
    public ItemStack setTier(@Nonnull ItemStack stack, IItemWithTier.TIER tier) {
        NBTTagCompound tag = UtilLib.checkNBT(stack);
        tag.func_74778_a("tier", tier.name());
        return stack;
    }
}

