/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.items;

import com.google.common.collect.Multimap;
import de.teamlapen.vampirism.api.VReference;
import de.teamlapen.vampirism.api.items.IItemWithTier;
import de.teamlapen.vampirism.items.IItemWithTierNBTImpl;
import de.teamlapen.vampirism.items.VampirismHunterArmor;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemObsidianArmor
extends VampirismHunterArmor
implements IItemWithTierNBTImpl {
    private static final String baseRegName = "obsidian_armor";
    private final int[] DAMAGE_REDUCTION_ULTIMATE = new int[]{5, 10, 11, 5};
    private final int[] DAMAGE_REDUCTION_ENHANCED = new int[]{4, 8, 10, 4};
    private final int[] DAMAGE_REDUCTION_NORMAL = new int[]{3, 7, 9, 3};
    private final float[] SPEED_REDUCTION = new float[]{-0.025f, -0.1f, -0.05f, -0.025f};

    public static boolean isFullyEquipped(EntityPlayer player) {
        for (ItemStack stack : player.field_71071_by.field_70460_b) {
            if (!stack.func_190926_b() && stack.func_77973_b() instanceof ItemObsidianArmor) continue;
            return false;
        }
        return true;
    }

    public ItemObsidianArmor(EntityEquipmentSlot equipmentSlotIn) {
        super(VReference.OBSIDIAN_ARMOR_MATERIAL, equipmentSlotIn, baseRegName);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        this.addTierInformation(stack, tooltip);
    }

    public String getArmorTexture(ItemStack stack, Entity entity, EntityEquipmentSlot slot, String type) {
        switch (this.getTier(stack)) {
            case ENHANCED: {
                return this.getTextureLocation("obsidian_armor_of_hell_enhanced", slot, type);
            }
            case ULTIMATE: {
                return this.getTextureLocation("obsidian_armor_of_hell_ultimate", slot, type);
            }
        }
        return this.getTextureLocation("obsidian_armor_of_hell", slot, type);
    }

    @Override
    public Multimap<String, AttributeModifier> getAttributeModifiers(EntityEquipmentSlot slot, ItemStack stack) {
        Multimap<String, AttributeModifier> map = super.getAttributeModifiers(slot, stack);
        if (slot == this.field_77881_a) {
            map.put((Object)SharedMonsterAttributes.field_111263_d.func_111108_a(), (Object)new AttributeModifier(VAMPIRISM_ARMOR_MODIFIER[slot.func_188454_b()], "Speed modifier", (double)this.getSpeedReduction(slot.func_188454_b(), stack), 2));
        }
        return map;
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (this.func_194125_a(tab)) {
            for (IItemWithTier.TIER t : IItemWithTier.TIER.values()) {
                items.add((Object)this.setTier(new ItemStack((Item)this), t));
            }
        }
    }

    @Override
    protected int getDamageReduction(int slot, ItemStack stack) {
        IItemWithTier.TIER tier = this.getTier(stack);
        switch (tier) {
            case ULTIMATE: {
                return this.DAMAGE_REDUCTION_ULTIMATE[slot];
            }
            case ENHANCED: {
                return this.DAMAGE_REDUCTION_ENHANCED[slot];
            }
        }
        return this.DAMAGE_REDUCTION_NORMAL[slot];
    }

    private float getSpeedReduction(int slot, ItemStack stack) {
        return this.SPEED_REDUCTION[slot];
    }
}

