/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.items;

import de.teamlapen.lib.VampLib;
import de.teamlapen.lib.lib.util.UtilLib;
import de.teamlapen.vampirism.VampirismMod;
import de.teamlapen.vampirism.api.VReference;
import de.teamlapen.vampirism.api.entity.player.vampire.IVampirePlayer;
import de.teamlapen.vampirism.api.items.IBloodChargeable;
import de.teamlapen.vampirism.config.Balance;
import de.teamlapen.vampirism.core.ModParticles;
import de.teamlapen.vampirism.entity.factions.FactionPlayerHandler;
import de.teamlapen.vampirism.items.VampirismItemWeapon;
import de.teamlapen.vampirism.player.vampire.VampirePlayer;
import de.teamlapen.vampirism.player.vampire.skills.VampireSkills;
import de.teamlapen.vampirism.util.Helper;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagByte;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagFloat;
import net.minecraft.util.ActionResult;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class VampirismVampireSword
extends VampirismItemWeapon
implements IBloodChargeable {
    public static final String DO_NOT_NAME_STRING = "DO_NOT_NAME";
    private final float minStrength = 0.2f;
    private final float minSpeed = 0.15f;

    public VampirismVampireSword(String regName, Item.ToolMaterial material, float attackSpeedModifier) {
        super(regName, material, attackSpeedModifier);
    }

    public VampirismVampireSword(String regName, Item.ToolMaterial material) {
        super(regName, material);
    }

    public VampirismVampireSword(String regName, Item.ToolMaterial material, float attackSpeedModifier, float attackDamage) {
        super(regName, material, attackSpeedModifier, attackDamage);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        float charged = this.getCharged(stack);
        float trained = this.getTrained(stack, (EntityLivingBase)Minecraft.func_71410_x().field_71439_g);
        tooltip.add(UtilLib.translate("text.vampirism.sword_charged") + " " + (int)Math.ceil(charged * 100.0f) + "%");
        tooltip.add(UtilLib.translate("text.vampirism.sword_trained") + " " + (int)Math.ceil(trained * 100.0f) + "%");
        if (Minecraft.func_71410_x().field_71439_g != null && !VReference.VAMPIRE_FACTION.equals(FactionPlayerHandler.get((EntityPlayer)Minecraft.func_71410_x().field_71439_g).getCurrentFaction())) {
            tooltip.add(UtilLib.translateFormatted("text.vampirism.can_only_be_used_by", UtilLib.translate(VReference.VAMPIRE_FACTION.getUnlocalizedNamePlural())));
        }
    }

    @Override
    public boolean canBeCharged(ItemStack stack) {
        return this.getCharged(stack) < 1.0f;
    }

    @Override
    public int charge(ItemStack stack, int amount) {
        float factor = this.getChargingFactor(stack);
        float charge = this.getCharged(stack);
        float actual = Math.min(factor * (float)amount, 1.0f - charge);
        this.setCharged(stack, charge + actual);
        return (int)(actual / factor);
    }

    public void doNotName(ItemStack stack) {
        stack.func_77983_a("dont_name", (NBTBase)new NBTTagByte(127));
    }

    public float getAttackDamageModifier(ItemStack stack) {
        return this.getCharged(stack) > 0.0f ? 1.0f : 0.2f;
    }

    public float getAttackSpeedModifier(ItemStack stack) {
        return 0.15f + 0.85f * this.getTrained(stack);
    }

    public int func_77626_a(ItemStack stack) {
        return 40;
    }

    @Override
    public boolean func_77644_a(ItemStack stack, EntityLivingBase target, EntityLivingBase attacker) {
        if (attacker instanceof EntityPlayer && (double)target.func_110143_aJ() <= (double)target.func_110138_aP() * Balance.vps.SWORD_FINISHER_MAX_HEALTH_PERC && !Helper.isVampire((Entity)target) && VampirePlayer.get((EntityPlayer)attacker).getSkillHandler().isSkillEnabled(VampireSkills.sword_finisher)) {
            DamageSource dmg = DamageSource.func_76365_a((EntityPlayer)((EntityPlayer)attacker)).func_76348_h();
            target.func_70097_a(dmg, 10000.0f);
            Vec3d center = new Vec3d((Vec3i)target.func_180425_c());
            center.func_72441_c(0.0, (double)target.field_70131_O / 2.0, 0.0);
            VampLib.proxy.getParticleHandler().spawnParticles(target.field_70170_p, ModParticles.GENERIC_PARTICLE, center.field_72450_a, center.field_72448_b, center.field_72449_c, 15, 0.5, target.func_70681_au(), 132, 12, 0xE02020);
        }
        return super.func_77644_a(stack, target, attacker);
    }

    public boolean isFullyCharged(ItemStack stack) {
        return this.getCharged(stack) == 1.0f;
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        ItemStack stack = playerIn.func_184586_b(handIn);
        VampirePlayer vampire = VampirePlayer.get(playerIn);
        if (vampire.getLevel() == 0) {
            return new ActionResult(EnumActionResult.PASS, (Object)stack);
        }
        if (this.canBeCharged(stack) && playerIn.func_70093_af() && (playerIn.func_184812_l_() || vampire.getBloodLevel() >= 2) && vampire.getSkillHandler().isSkillEnabled(VampireSkills.blood_charge)) {
            playerIn.func_184598_c(handIn);
            return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
        }
        return new ActionResult(EnumActionResult.PASS, (Object)stack);
    }

    public ItemStack func_77654_b(ItemStack stack, World worldIn, EntityLivingBase entityLiving) {
        if (!(entityLiving instanceof EntityPlayer)) {
            return stack;
        }
        IVampirePlayer vampire = VReference.VAMPIRE_FACTION.getPlayerCapability((EntityPlayer)entityLiving);
        if (((EntityPlayer)entityLiving).func_184812_l_() || vampire.useBlood(2, false)) {
            this.charge(stack, 200);
        }
        if (this.getCharged(stack) == 1.0f) {
            this.tryName(stack, (EntityPlayer)entityLiving);
        }
        return stack;
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        float charged;
        if (worldIn.field_72995_K && (isSelected || itemSlot == 0) && (charged = this.getCharged(stack)) > 0.0f && entityIn.field_70173_aa % (int)(8.0f + 80.0f * (1.0f - charged)) == 0 && entityIn instanceof EntityLivingBase) {
            boolean secondHand;
            boolean bl = secondHand = !isSelected && ((EntityLivingBase)entityIn).func_184586_b(EnumHand.OFF_HAND).equals(stack);
            if (isSelected || secondHand) {
                this.spawnChargedParticle((EntityLivingBase)entityIn, isSelected);
            }
        }
    }

    public void onUsingTick(ItemStack stack, EntityLivingBase player, int count) {
        if (player.func_130014_f_().field_72995_K && count % 3 == 0) {
            this.spawnChargingParticle(player, player.func_184614_ca().equals(stack));
        }
    }

    public void setCharged(@Nonnull ItemStack stack, float value) {
        stack.func_77983_a("charged", (NBTBase)new NBTTagFloat(MathHelper.func_76131_a((float)value, (float)0.0f, (float)1.0f)));
    }

    public void setTrained(@Nonnull ItemStack stack, @Nonnull EntityLivingBase player, float value) {
        NBTTagCompound nbt = stack.func_190925_c("trained");
        nbt.func_74776_a(player.getPersistentID().toString(), MathHelper.func_76131_a((float)value, (float)0.0f, (float)1.0f));
    }

    public void tryName(ItemStack stack, EntityPlayer player) {
        if (!(stack.func_82837_s() || stack.func_77942_o() && stack.func_77978_p().func_74767_n("dont_name"))) {
            player.openGui((Object)VampirismMod.instance, 11, player.func_130014_f_(), (int)player.field_70165_t, (int)player.field_70163_u, (int)player.field_70161_v);
            player.field_70170_p.func_184134_a(player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundEvents.field_187802_ec, SoundCategory.PLAYERS, 1.0f, 1.0f, false);
        }
    }

    public boolean updateTrainedCached(@Nonnull ItemStack stack, @Nonnull EntityLivingBase player) {
        float trained;
        float cached = this.getTrained(stack);
        if (cached != (trained = this.getTrained(stack, player))) {
            stack.func_77983_a("trained-cache", (NBTBase)new NBTTagFloat(trained));
            return true;
        }
        return false;
    }

    @Override
    protected final float getAttackDamage(ItemStack stack) {
        return this.getBaseAttackDamage(stack) * this.getAttackDamageModifier(stack);
    }

    @Override
    protected final float getAttackSpeed(ItemStack stack) {
        return this.getBaseAttackSpeed(stack) * this.getAttackSpeedModifier(stack);
    }

    protected float getBaseAttackDamage(ItemStack stack) {
        return super.getAttackDamage(stack);
    }

    protected float getBaseAttackSpeed(ItemStack stack) {
        return super.getAttackSpeed(stack);
    }

    protected float getCharged(@Nonnull ItemStack stack) {
        if (stack.func_77942_o()) {
            return stack.func_77978_p().func_74760_g("charged");
        }
        return 0.0f;
    }

    protected abstract float getChargingFactor(ItemStack var1);

    protected float getTrained(@Nonnull ItemStack stack, @Nullable EntityLivingBase player) {
        if (player == null) {
            return this.getTrained(stack);
        }
        UUID id = player.getPersistentID();
        NBTTagCompound nbt = stack.func_179543_a("trained");
        if (nbt != null && nbt.func_74764_b(id.toString())) {
            return nbt.func_74760_g(id.toString());
        }
        return 0.0f;
    }

    protected float getTrained(@Nonnull ItemStack stack) {
        NBTTagCompound nbt;
        if (stack.func_77942_o() && (nbt = stack.func_77978_p()).func_74764_b("trained-cache")) {
            return nbt.func_74760_g("trained-cache");
        }
        return 0.0f;
    }

    @SideOnly(value=Side.CLIENT)
    private void spawnChargedParticle(EntityLivingBase player, boolean mainHand) {
        Vec3d mainPos = UtilLib.getItemPosition(player, mainHand);
        for (int j = 0; j < 3; ++j) {
            Vec3d pos = mainPos.func_72441_c((double)((player.func_70681_au().nextFloat() - 0.5f) * 0.1f), (double)((player.func_70681_au().nextFloat() - 0.3f) * 0.9f), (double)((player.func_70681_au().nextFloat() - 0.5f) * 0.1f));
            VampLib.proxy.getParticleHandler().spawnParticle(player.func_130014_f_(), ModParticles.FLYING_BLOOD, pos.field_72450_a, pos.field_72448_b, pos.field_72449_c, pos.field_72450_a + ((double)player.func_70681_au().nextFloat() - 0.5) * 0.2, pos.field_72448_b + ((double)player.func_70681_au().nextFloat() - 0.5) * 0.2, pos.field_72449_c + ((double)player.func_70681_au().nextFloat() - 0.5) * 0.2, (int)(4.0f / (player.func_70681_au().nextFloat() * 0.9f + 0.1f)), 177);
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void spawnChargingParticle(EntityLivingBase player, boolean mainHand) {
        Vec3d pos = UtilLib.getItemPosition(player, mainHand);
        if (player.func_70678_g(1.0f) > 0.0f) {
            return;
        }
        pos = pos.func_72441_c((double)((player.func_70681_au().nextFloat() - 0.5f) * 0.1f), (double)((player.func_70681_au().nextFloat() - 0.3f) * 0.9f), (double)((player.func_70681_au().nextFloat() - 0.5f) * 0.1f));
        Vec3d playerPos = new Vec3d(player.field_70165_t, player.field_70163_u + (double)player.func_70047_e() - (double)0.2f, player.field_70161_v);
        VampLib.proxy.getParticleHandler().spawnParticle(player.func_130014_f_(), ModParticles.FLYING_BLOOD, playerPos.field_72450_a, playerPos.field_72448_b, playerPos.field_72449_c, pos.field_72450_a, pos.field_72448_b, pos.field_72449_c, (int)(4.0f / (player.func_70681_au().nextFloat() * 0.6f + 0.1f)));
    }

    public boolean onEntitySwing(EntityLivingBase entityLiving, ItemStack stack) {
        return !Helper.isVampire((Entity)entityLiving);
    }

    public boolean onLeftClickEntity(ItemStack stack, EntityPlayer player, Entity entity) {
        return !Helper.isVampire((Entity)player);
    }
}

