/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.modcompat.jei;

import de.teamlapen.lib.lib.util.UtilLib;
import de.teamlapen.vampirism.api.entity.player.skills.ISkill;
import de.teamlapen.vampirism.api.items.IHunterWeaponRecipe;
import java.awt.Color;
import javax.annotation.Nonnull;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.BlankRecipeWrapper;
import net.minecraft.client.Minecraft;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class HunterWeaponRecipeWrapper
extends BlankRecipeWrapper {
    private static final ItemStack lavaStack = new ItemStack(Items.field_151129_at);
    @Nonnull
    private final IHunterWeaponRecipe recipe;

    protected HunterWeaponRecipeWrapper(@Nonnull IHunterWeaponRecipe recipe) {
        this.recipe = recipe;
    }

    @SideOnly(value=Side.CLIENT)
    public void drawInfo(@Nonnull Minecraft minecraft, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
        if (this.recipe.getRequiredLavaUnits() > 0) {
            minecraft.func_175599_af().func_175042_a(lavaStack, 83, 13);
        }
        int x = 2;
        int y = 80;
        if (this.recipe.getMinHunterLevel() > 1) {
            String level = UtilLib.translateFormatted("gui.vampirism.hunter_weapon_table.level", this.recipe.getMinHunterLevel());
            minecraft.field_71466_p.func_78276_b(level, x, y, Color.gray.getRGB());
            y += minecraft.field_71466_p.field_78288_b + 2;
        }
        if (this.recipe.getRequiredSkills().length > 0) {
            StringBuilder skills = new StringBuilder();
            for (ISkill skill : this.recipe.getRequiredSkills()) {
                skills.append(UtilLib.translate(skill.getUnlocalizedName())).append(" ");
            }
            String skillText = UtilLib.translateFormatted("gui.vampirism.hunter_weapon_table.skill", skills.toString());
            minecraft.field_71466_p.func_78279_b(skillText, x, y, 132, Color.gray.getRGB());
        }
    }

    public void getIngredients(IIngredients ingredients) {
        if (this.recipe.getRequiredLavaUnits() > 0) {
            FluidStack fluidInput = new FluidStack(FluidRegistry.LAVA, this.recipe.getRequiredLavaUnits() * 200);
            ingredients.setInput(FluidStack.class, (Object)fluidInput);
        }
    }
}

