/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.player.actions;

import de.teamlapen.vampirism.VampirismMod;
import de.teamlapen.vampirism.api.VampirismAPI;
import de.teamlapen.vampirism.api.entity.factions.IPlayableFaction;
import de.teamlapen.vampirism.api.entity.player.IFactionPlayer;
import de.teamlapen.vampirism.api.entity.player.actions.IAction;
import de.teamlapen.vampirism.api.entity.player.actions.IActionHandler;
import de.teamlapen.vampirism.api.entity.player.actions.ILastingAction;
import de.teamlapen.vampirism.core.VampirismRegistries;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.server.permission.PermissionAPI;

public class ActionHandler<T extends IFactionPlayer>
implements IActionHandler<T> {
    private static final String TAG = "ActionHandler";
    private final Object2IntMap<ResourceLocation> cooldownTimers;
    private final Object2IntMap<ResourceLocation> activeTimers;
    private final T player;
    private final List<IAction> unlockedActions = new ArrayList<IAction>();
    private boolean dirty = false;

    public ActionHandler(T player) {
        this.player = player;
        List<IAction> actions = VampirismAPI.actionManager().getActionsForFaction((IPlayableFaction)player.getFaction());
        this.cooldownTimers = new Object2IntOpenHashMap(actions.size(), 0.9f);
        this.activeTimers = new Object2IntOpenHashMap(actions.size(), 0.9f);
    }

    @Override
    public void deactivateAllActions() {
        for (ResourceLocation r : this.activeTimers.keySet()) {
            ILastingAction action = (ILastingAction)VampirismRegistries.ACTIONS.getValue(r);
            assert (action != null);
            int cooldown = action.getCooldown();
            this.cooldownTimers.put((Object)r, cooldown);
            action.onDeactivated(this.player);
        }
    }

    @Override
    public List<IAction> getAvailableActions() {
        ArrayList<IAction> actions = new ArrayList<IAction>();
        for (IAction action : this.unlockedActions) {
            if (action.canUse((IFactionPlayer)this.player) != IAction.PERM.ALLOWED) continue;
            actions.add(action);
        }
        return actions;
    }

    @Override
    public float getPercentageForAction(@Nonnull IAction action) {
        if (this.activeTimers.containsKey((Object)action.getRegistryName())) {
            return (float)((Integer)this.activeTimers.get((Object)action.getRegistryName())).intValue() / (float)((ILastingAction)action).getDuration(this.player.getLevel());
        }
        if (this.cooldownTimers.containsKey((Object)action.getRegistryName())) {
            return (float)(-((Integer)this.cooldownTimers.get((Object)action.getRegistryName())).intValue()) / (float)action.getCooldown();
        }
        return 0.0f;
    }

    @Override
    public boolean isActionActive(@Nonnull ILastingAction action) {
        return this.activeTimers.containsKey((Object)action.getRegistryName());
    }

    @Override
    public boolean isActionActive(ResourceLocation id) {
        return this.activeTimers.containsKey((Object)id);
    }

    @Override
    public boolean isActionUnlocked(IAction action) {
        return this.unlockedActions.contains(action);
    }

    public void loadFromNbt(NBTTagCompound nbt) {
        this.activeTimers.clear();
        this.cooldownTimers.clear();
        if (nbt.func_74764_b("actions_active")) {
            this.loadTimerMapFromNBT(nbt.func_74775_l("actions_active"), this.activeTimers);
        }
        if (nbt.func_74764_b("actions_cooldown")) {
            this.loadTimerMapFromNBT(nbt.func_74775_l("actions_cooldown"), this.cooldownTimers);
        }
    }

    public void onActionsReactivated() {
        if (!this.player.isRemote()) {
            for (ResourceLocation id : this.activeTimers.keySet()) {
                ILastingAction action = (ILastingAction)VampirismRegistries.ACTIONS.getValue(id);
                assert (action != null);
                action.onReActivated(this.player);
            }
        }
    }

    public void readUpdateFromServer(NBTTagCompound nbt) {
        if (nbt.func_74764_b("actions_active")) {
            ILastingAction action;
            NBTTagCompound active = nbt.func_74775_l("actions_active");
            ObjectIterator it = this.activeTimers.object2IntEntrySet().iterator();
            while (it.hasNext()) {
                Object2IntMap.Entry client_active = (Object2IntMap.Entry)it.next();
                String key = ((ResourceLocation)client_active.getKey()).toString();
                if (active.func_74764_b(key)) {
                    client_active.setValue(active.func_74762_e(key));
                    nbt.func_82580_o(key);
                    continue;
                }
                action = (ILastingAction)VampirismRegistries.ACTIONS.getValue((ResourceLocation)client_active.getKey());
                assert (action != null);
                action.onDeactivated(this.player);
                it.remove();
            }
            for (String key : active.func_150296_c()) {
                ResourceLocation id = new ResourceLocation(key);
                action = (ILastingAction)VampirismRegistries.ACTIONS.getValue(id);
                if (action == null) {
                    VampirismMod.log.e(TAG, "Action %s is not available client side", key);
                    continue;
                }
                action.onActivatedClient(this.player);
                this.activeTimers.put((Object)id, active.func_74762_e(key));
            }
        }
        if (nbt.func_74764_b("actions_cooldown")) {
            this.cooldownTimers.clear();
            this.loadTimerMapFromNBT(nbt.func_74775_l("actions_cooldown"), this.cooldownTimers);
        }
    }

    @Override
    public void relockActions(Collection<IAction> actions) {
        this.unlockedActions.removeAll(actions);
        for (IAction action : actions) {
            if (!(action instanceof ILastingAction) || !this.isActionActive((ILastingAction)action)) continue;
            this.toggleAction(action);
        }
    }

    @Override
    public void resetTimers() {
        for (ResourceLocation id : this.activeTimers.keySet()) {
            ILastingAction action = (ILastingAction)VampirismRegistries.ACTIONS.getValue(id);
            assert (action != null);
            action.onDeactivated(this.player);
        }
        this.activeTimers.clear();
        this.cooldownTimers.clear();
        this.dirty = true;
    }

    public void saveToNbt(NBTTagCompound nbt) {
        nbt.func_74782_a("actions_active", (NBTBase)this.writeTimersToNBT((ObjectSet<Object2IntMap.Entry<ResourceLocation>>)this.activeTimers.object2IntEntrySet()));
        nbt.func_74782_a("actions_cooldown", (NBTBase)this.writeTimersToNBT((ObjectSet<Object2IntMap.Entry<ResourceLocation>>)this.cooldownTimers.object2IntEntrySet()));
    }

    @Override
    public IAction.PERM toggleAction(IAction action) {
        ResourceLocation id = action.getRegistryName();
        if (this.activeTimers.containsKey((Object)id)) {
            int cooldown = action.getCooldown();
            if (((ILastingAction)action).allowReducedCooldown()) {
                cooldown -= ((Integer)this.activeTimers.get((Object)id)).intValue();
            }
            ((ILastingAction)action).onDeactivated(this.player);
            this.activeTimers.remove((Object)id);
            this.cooldownTimers.put((Object)id, Math.max(cooldown, 1));
            this.dirty = true;
            return IAction.PERM.ALLOWED;
        }
        if (this.cooldownTimers.containsKey((Object)id)) {
            return IAction.PERM.COOLDOWN;
        }
        if (!this.isActionUnlocked(action)) {
            return IAction.PERM.NOT_UNLOCKED;
        }
        if (!this.isActionAllowedPermission(action)) {
            return IAction.PERM.DISALLOWED;
        }
        IAction.PERM r = action.canUse((IFactionPlayer)this.player);
        if (r == IAction.PERM.ALLOWED) {
            if (action.onActivated((IFactionPlayer)this.player)) {
                if (action instanceof ILastingAction) {
                    this.activeTimers.put((Object)id, ((ILastingAction)action).getDuration(this.player.getLevel()));
                } else {
                    this.cooldownTimers.put((Object)id, action.getCooldown());
                }
                this.dirty = true;
            }
            return IAction.PERM.ALLOWED;
        }
        return r;
    }

    @Override
    public void unlockActions(Collection<IAction> actions) {
        for (IAction action : actions) {
            if (VampirismRegistries.ACTIONS.containsValue((IForgeRegistryEntry)action)) continue;
            throw new ActionNotRegisteredException(action);
        }
        this.unlockedActions.addAll(actions);
    }

    private boolean isActionAllowedPermission(IAction action) {
        ResourceLocation id = action.getRegistryName();
        return this.player.getRepresentingEntity().field_70170_p.field_72995_K || PermissionAPI.hasPermission((EntityPlayer)this.player.getRepresentingPlayer(), (String)("vampirism.action." + id.func_110624_b() + "." + id.func_110623_a()));
    }

    public boolean updateActions() {
        Object2IntMap.Entry entry;
        ObjectIterator it = this.cooldownTimers.object2IntEntrySet().iterator();
        while (it.hasNext()) {
            entry = (Object2IntMap.Entry)it.next();
            int value = entry.getIntValue();
            if (value <= 1) {
                it.remove();
                continue;
            }
            entry.setValue(value - 1);
        }
        it = this.activeTimers.object2IntEntrySet().iterator();
        while (it.hasNext()) {
            entry = (Object2IntMap.Entry)it.next();
            int newtimer = entry.getIntValue() - 1;
            ILastingAction action = (ILastingAction)VampirismRegistries.ACTIONS.getValue((ResourceLocation)entry.getKey());
            assert (action != null);
            if (newtimer == 0) {
                action.onDeactivated(this.player);
                this.cooldownTimers.put(entry.getKey(), action.getCooldown());
                it.remove();
                this.dirty = true;
                continue;
            }
            if (action.onUpdate(this.player)) {
                entry.setValue(1);
                continue;
            }
            entry.setValue(newtimer);
        }
        if (this.dirty) {
            this.dirty = false;
            return true;
        }
        return false;
    }

    public void writeUpdateForClient(NBTTagCompound nbt) {
        nbt.func_74782_a("actions_active", (NBTBase)this.writeTimersToNBT((ObjectSet<Object2IntMap.Entry<ResourceLocation>>)this.activeTimers.object2IntEntrySet()));
        nbt.func_74782_a("actions_cooldown", (NBTBase)this.writeTimersToNBT((ObjectSet<Object2IntMap.Entry<ResourceLocation>>)this.cooldownTimers.object2IntEntrySet()));
    }

    private void loadTimerMapFromNBT(NBTTagCompound nbt, Object2IntMap<ResourceLocation> map) {
        for (String key : nbt.func_150296_c()) {
            ResourceLocation id = new ResourceLocation(key);
            IAction action = (IAction)VampirismRegistries.ACTIONS.getValue(id);
            if (action == null) {
                VampirismMod.log.w(TAG, "Did not find action with key %s", key);
                continue;
            }
            map.put((Object)id, nbt.func_74762_e(key));
        }
    }

    private NBTTagCompound writeTimersToNBT(ObjectSet<Object2IntMap.Entry<ResourceLocation>> set) {
        NBTTagCompound nbt = new NBTTagCompound();
        for (Object2IntMap.Entry entry : set) {
            nbt.func_74768_a(((ResourceLocation)entry.getKey()).toString(), entry.getIntValue());
        }
        return nbt;
    }

    public static class ActionNotRegisteredException
    extends RuntimeException {
        public ActionNotRegisteredException(String name) {
            super("Action " + name + " is not registered. You cannot use it otherwise");
        }

        public ActionNotRegisteredException(IAction action) {
            this(action.toString());
        }
    }
}

