/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.player.hunter.actions;

import de.teamlapen.vampirism.api.entity.player.actions.ILastingAction;
import de.teamlapen.vampirism.api.entity.player.hunter.DefaultHunterAction;
import de.teamlapen.vampirism.api.entity.player.hunter.IHunterPlayer;
import de.teamlapen.vampirism.config.Balance;
import de.teamlapen.vampirism.player.hunter.HunterPlayer;
import de.teamlapen.vampirism.player.hunter.actions.HunterActions;
import de.teamlapen.vampirism.util.Helper;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.math.AxisAlignedBB;

public class AwarenessHunterAction
extends DefaultHunterAction
implements ILastingAction<IHunterPlayer> {
    public AwarenessHunterAction() {
        super(null);
    }

    @Override
    public int getCooldown() {
        return Balance.hpa.AWARENESS_COOLDOWN;
    }

    @Override
    public boolean canBeUsedBy(IHunterPlayer player) {
        return !player.getActionHandler().isActionActive(HunterActions.disguise_hunter);
    }

    @Override
    public int getMinU() {
        return 16;
    }

    @Override
    public int getMinV() {
        return 48;
    }

    @Override
    public String getUnlocalizedName() {
        return "action.vampirism.hunter.awareness";
    }

    @Override
    public boolean isEnabled() {
        return Balance.hpa.AWARENESS_ENABLED;
    }

    @Override
    protected boolean activate(IHunterPlayer player) {
        this.onUpdate(player);
        return true;
    }

    @Override
    public int getDuration(int level) {
        return Balance.hpa.AWARENESS_DURATION;
    }

    @Override
    public void onActivatedClient(IHunterPlayer player) {
        this.onUpdate(player);
    }

    @Override
    public void onDeactivated(IHunterPlayer player) {
        ((HunterPlayer)player).getSpecialAttributes().resetVampireNearby();
    }

    @Override
    public void onReActivated(IHunterPlayer player) {
        this.onUpdate(player);
    }

    @Override
    public boolean onUpdate(IHunterPlayer player) {
        if (player.getRepresentingEntity().field_70173_aa % 20 != 0) {
            if (((HunterPlayer)player).getSpecialAttributes().isVampireNearby()) {
                ((HunterPlayer)player).getSpecialAttributes().nearbyVampire();
            }
        } else if (this.nearbyVampire(player)) {
            ((HunterPlayer)player).getSpecialAttributes().nearbyVampire();
        } else {
            ((HunterPlayer)player).getSpecialAttributes().resetVampireNearby();
        }
        return false;
    }

    private boolean nearbyVampire(IHunterPlayer player) {
        List entities = player.getRepresentingEntity().func_130014_f_().func_72872_a(EntityLivingBase.class, new AxisAlignedBB(player.getRepresentingEntity().field_70165_t - (double)Balance.hpa.AWARENESS_RADIUS, player.getRepresentingEntity().field_70163_u - (double)Balance.hpa.AWARENESS_RADIUS + 1.0, player.getRepresentingEntity().field_70161_v - (double)Balance.hpa.AWARENESS_RADIUS, player.getRepresentingEntity().field_70165_t + (double)Balance.hpa.AWARENESS_RADIUS, player.getRepresentingEntity().field_70163_u + (double)Balance.hpa.AWARENESS_RADIUS + 1.0, player.getRepresentingEntity().field_70161_v + (double)Balance.hpa.AWARENESS_RADIUS));
        for (EntityLivingBase e : entities) {
            if (!Helper.isVampire((Entity)e)) continue;
            return true;
        }
        return false;
    }
}

