/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.player.skills;

import com.google.common.collect.Lists;
import de.teamlapen.vampirism.VampirismMod;
import de.teamlapen.vampirism.api.VampirismAPI;
import de.teamlapen.vampirism.api.entity.factions.IPlayableFaction;
import de.teamlapen.vampirism.api.entity.player.skills.ISkill;
import de.teamlapen.vampirism.api.entity.player.skills.ISkillManager;
import de.teamlapen.vampirism.api.entity.player.skills.SkillEvent;
import de.teamlapen.vampirism.api.entity.player.skills.SkillNode;
import de.teamlapen.vampirism.core.VampirismRegistries;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.command.ICommandSender;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class SkillManager
implements ISkillManager {
    private final Map<ResourceLocation, SkillNode> rootNodes = new HashMap<ResourceLocation, SkillNode>();
    private final Map<ResourceLocation, Integer[]> skillNodeSizeMap = new HashMap<ResourceLocation, Integer[]>();

    public void buildSkillTrees() {
        for (IPlayableFaction f : VampirismAPI.factionRegistry().getPlayableFactions()) {
            this.buildSkillTree(f);
        }
    }

    @Override
    public SkillNode createSkillNode(@Nonnull SkillNode parent, ISkill ... skills) {
        Objects.requireNonNull(parent);
        List<ISkill> skillList = Arrays.asList(skills);
        if (skillList.contains(null)) {
            throw new IllegalArgumentException("Can't use null skill");
        }
        assert (skills.length > 0);
        ISkill[] moddedSkills = this.fireAddSkillsEvent(parent.getFaction(), skillList);
        if (moddedSkills.length == 0) {
            throw new IllegalArgumentException("Cannot remove all skills from a skill node");
        }
        SkillNode node = new SkillNode(parent, moddedSkills);
        MinecraftForge.EVENT_BUS.post((Event)new SkillEvent.CreatedNode(node.getFaction(), node));
        return node;
    }

    @SideOnly(value=Side.CLIENT)
    public Integer[] getDisplayInfo(IPlayableFaction faction) {
        if (!this.skillNodeSizeMap.containsKey(faction.getKey())) {
            this.skillNodeSizeMap.put(faction.getKey(), this.createDisplayInfo(this.getRootSkillNode(faction)));
        }
        return this.skillNodeSizeMap.get(faction.getKey());
    }

    @Override
    public SkillNode getRootSkillNode(IPlayableFaction faction) {
        return this.rootNodes.get(faction.getKey());
    }

    @Override
    public List<ISkill> getSkillsForFaction(IPlayableFaction faction) {
        ArrayList list = Lists.newArrayList((Iterable)VampirismRegistries.SKILLS.getValues());
        list.removeIf(skill -> !faction.equals(skill.getFaction()));
        return list;
    }

    public void printSkills(IPlayableFaction faction, ICommandSender sender) {
        for (ISkill s : this.getSkillsForFaction(faction)) {
            sender.func_145747_a((ITextComponent)new TextComponentString("ID: " + VampirismRegistries.SKILLS.getKey((IForgeRegistryEntry)s) + " Skill: " + s));
        }
    }

    private void buildSkillTree(IPlayableFaction faction) {
        ISkill root = this.getRootSkill(faction);
        SkillNode rootNode = new SkillNode(faction, root);
        this.rootNodes.put(faction.getKey(), rootNode);
        MinecraftForge.EVENT_BUS.post((Event)new SkillEvent.CreatedNode(faction, rootNode));
        this.setRenderPos(rootNode, 0);
    }

    private int calculateEndPoints(SkillNode start) {
        if (start.getChildren().size() == 0) {
            return 1;
        }
        int count = 0;
        for (SkillNode node : start.getChildren()) {
            count += this.calculateEndPoints(node);
        }
        return count;
    }

    private int calculateMaxSkillDepth(SkillNode start) {
        int max = start.getDepth();
        for (SkillNode node : start.getChildren()) {
            int n = this.calculateMaxSkillDepth(node);
            if (n <= max) continue;
            max = n;
        }
        return max;
    }

    private int calculateMaxSkillsPerNode(SkillNode start) {
        int max = start.getElements().length;
        for (SkillNode node : start.getChildren()) {
            int n = this.calculateMaxSkillsPerNode(node);
            if (n <= max) continue;
            max = n;
        }
        return max;
    }

    private Integer[] createDisplayInfo(SkillNode root) {
        Integer[] info = new Integer[]{this.calculateEndPoints(root), this.calculateMaxSkillsPerNode(root), this.calculateMaxSkillDepth(root) + 1};
        return info;
    }

    private ISkill[] fireAddSkillsEvent(IPlayableFaction faction, List<ISkill> skills) {
        SkillEvent.AddSkills event = new SkillEvent.AddSkills(faction, skills);
        MinecraftForge.EVENT_BUS.post((Event)event);
        event.getSkills().remove(null);
        return event.getSkills().toArray(new ISkill[event.getSkills().size()]);
    }

    @Nonnull
    private ISkill getRootSkill(IPlayableFaction faction) {
        ISkill skill = (ISkill)VampirismRegistries.SKILLS.getValue(faction.getKey());
        if (skill == null) {
            VampirismMod.log.bigWarning("SkillManager", "No root skill exists for faction %s", faction.getKey());
            throw new IllegalStateException("You need to register a root skill for your faction " + faction.getKey());
        }
        return skill;
    }

    private void setRenderPos(SkillNode base, int column) {
        int i;
        int left = -(base.getElements().length * 2 - 1) / 2;
        for (ISkill skill : base.getElements()) {
            skill.setRenderPos(base.getDepth() * 2, column + left);
            left += 2;
        }
        int[] widths = new int[base.getChildren().size()];
        int total = 0;
        for (i = 0; i < widths.length; ++i) {
            SkillNode node = base.getChildren().get(i);
            widths[i] = this.calculateMaxSkillsPerNode(node) * this.calculateEndPoints(node) * 2;
            total += widths[i];
        }
        left = -total / 2;
        for (i = 0; i < widths.length; ++i) {
            this.setRenderPos(base.getChildren().get(i), column + left + widths[i] / 2);
            left += widths[i];
        }
    }
}

