/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.player.vampire.actions;

import de.teamlapen.vampirism.advancements.VampireActionTrigger;
import de.teamlapen.vampirism.api.EnumStrength;
import de.teamlapen.vampirism.api.entity.player.actions.ILastingAction;
import de.teamlapen.vampirism.api.entity.player.vampire.DefaultVampireAction;
import de.teamlapen.vampirism.api.entity.player.vampire.IVampirePlayer;
import de.teamlapen.vampirism.config.Balance;
import de.teamlapen.vampirism.config.Configs;
import de.teamlapen.vampirism.core.ModAdvancements;
import de.teamlapen.vampirism.player.vampire.VampirePlayer;
import de.teamlapen.vampirism.player.vampire.actions.VampireActions;
import java.util.UUID;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.MobEffects;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.WorldProviderEnd;

public class BatVampireAction
extends DefaultVampireAction
implements ILastingAction<IVampirePlayer> {
    private static final float BAT_HEIGHT = 0.8f;
    public static final float BAT_EYE_HEIGHT = 0.68f;
    private static final float BAT_WIDTH = 0.6f;
    public final UUID healthModifierUUID = UUID.fromString("4392fccb-4bfd-4290-b2e6-5cc91429053c");
    private final float PLAYER_WIDTH = 0.6f;
    private final float PLAYER_HEIGHT = 1.8f;

    public static void updatePlayerBatSize(EntityPlayer player) {
        float width = 0.6f;
        float height = 0.8f;
        if (player.func_70093_af()) {
            height = 0.65f;
        }
        if (player.func_70608_bn()) {
            height = 0.2f;
            width = 0.2f;
        }
        if (player.field_70130_N != width || player.field_70131_O != height) {
            AxisAlignedBB axisalignedbb = player.func_174813_aQ();
            axisalignedbb = new AxisAlignedBB(axisalignedbb.field_72340_a, axisalignedbb.field_72338_b, axisalignedbb.field_72339_c, axisalignedbb.field_72340_a + (double)width, axisalignedbb.field_72338_b + (double)height, axisalignedbb.field_72339_c + (double)width);
            if (!player.func_130014_f_().func_184143_b(axisalignedbb) && !VampirePlayer.get(player).setEntitySize(width, height)) {
                return;
            }
        }
    }

    public BatVampireAction() {
        super(null);
    }

    @Override
    public boolean activate(IVampirePlayer vampire) {
        EntityPlayer player = vampire.getRepresentingPlayer();
        float oldMax = player.func_110138_aP();
        float oldHealth = player.func_110143_aJ();
        this.setModifier(player, true);
        float newMax = player.func_110138_aP();
        float mult = newMax / oldMax;
        float newHealth = mult * oldHealth;
        if (newHealth < 1.0f) {
            newHealth = 1.0f;
        }
        player.func_70606_j(newHealth);
        this.setPlayerBat(player, true);
        ((VampirePlayer)vampire).getSpecialAttributes().bat = true;
        if (player instanceof EntityPlayerMP) {
            ModAdvancements.TRIGGER_VAMPIRE_ACTION.trigger((EntityPlayerMP)player, VampireActionTrigger.Action.BAT);
        }
        return true;
    }

    @Override
    public boolean canBeUsedBy(IVampirePlayer vampire) {
        return !vampire.isGettingSundamage() && vampire.isGettingGarlicDamage() == EnumStrength.NONE && !vampire.getActionHandler().isActionActive(VampireActions.vampire_rage) && !vampire.getRepresentingPlayer().func_70090_H() && (Configs.bat_mode_in_end || !(vampire.getRepresentingPlayer().func_130014_f_().field_73011_w instanceof WorldProviderEnd));
    }

    @Override
    public int getCooldown() {
        return Balance.vpa.BAT_COOLDOWN * 20 + 1;
    }

    @Override
    public int getDuration(int level) {
        return MathHelper.func_76125_a((int)Balance.vpa.BAT_DURATION, (int)10, (int)0x6666665) * 20;
    }

    @Override
    public int getMinU() {
        return 64;
    }

    @Override
    public int getMinV() {
        return 0;
    }

    @Override
    public String getUnlocalizedName() {
        return "action.vampirism.vampire.bat_skill";
    }

    @Override
    public boolean isEnabled() {
        return Balance.vpa.BAT_ENABLED;
    }

    @Override
    public void onActivatedClient(IVampirePlayer vampire) {
        if (!((VampirePlayer)vampire).getSpecialAttributes().bat) {
            this.setPlayerBat(vampire.getRepresentingPlayer(), true);
            ((VampirePlayer)vampire).getSpecialAttributes().bat = true;
        }
    }

    @Override
    public void onDeactivated(IVampirePlayer vampire) {
        EntityPlayer player = vampire.getRepresentingPlayer();
        float oldMax = player.func_110138_aP();
        float oldHealth = player.func_110143_aJ();
        this.setModifier(player, false);
        float newMax = player.func_110138_aP();
        float mult = newMax / oldMax;
        float newHealth = mult * oldHealth;
        player.func_70606_j(newHealth);
        if (!player.field_70122_E) {
            player.func_70690_d(new PotionEffect(MobEffects.field_76429_m, 20, 100, false, false));
        }
        this.setPlayerBat(player, false);
        ((VampirePlayer)vampire).getSpecialAttributes().bat = false;
    }

    @Override
    public void onReActivated(IVampirePlayer vampire) {
        this.setModifier(vampire.getRepresentingPlayer(), true);
        if (!((VampirePlayer)vampire).getSpecialAttributes().bat) {
            this.setPlayerBat(vampire.getRepresentingPlayer(), true);
            ((VampirePlayer)vampire).getSpecialAttributes().bat = true;
        }
    }

    @Override
    public boolean onUpdate(IVampirePlayer vampire) {
        if (vampire.isGettingSundamage() && !vampire.isRemote()) {
            vampire.getRepresentingPlayer().func_145747_a((ITextComponent)new TextComponentTranslation("text.vampirism.cant_fly_day", new Object[0]));
            return true;
        }
        if (vampire.isGettingGarlicDamage() != EnumStrength.NONE && !vampire.isRemote()) {
            vampire.getRepresentingEntity().func_145747_a((ITextComponent)new TextComponentTranslation("text.vampirism.cant_fly_garlic", new Object[0]));
            return true;
        }
        if (!Configs.bat_mode_in_end && vampire.getRepresentingPlayer().func_130014_f_().field_73011_w instanceof WorldProviderEnd) {
            vampire.getRepresentingPlayer().func_145747_a((ITextComponent)new TextComponentTranslation("text.vampirism.cant_fly_end", new Object[0]));
            return true;
        }
        return vampire.getRepresentingPlayer().func_70090_H();
    }

    private void setFlightSpeed(EntityPlayer player, float speed) {
        player.field_71075_bZ.field_75096_f = speed;
    }

    private void setModifier(EntityPlayer player, boolean enabled) {
        if (enabled) {
            IAttributeInstance health = player.func_110148_a(SharedMonsterAttributes.field_111267_a);
            if (health.func_111127_a(this.healthModifierUUID) == null) {
                health.func_111121_a(new AttributeModifier(this.healthModifierUUID, "Bat Health Reduction", -Balance.vpa.BAT_HEALTH_REDUCTION, 2).func_111168_a(false));
            }
            player.field_71075_bZ.field_75101_c = true;
            player.field_71075_bZ.field_75100_b = true;
            this.setFlightSpeed(player, (float)Balance.vpa.BAT_FLIGHT_SPEED);
            player.func_71016_p();
        } else {
            IAttributeInstance health = player.func_110148_a(SharedMonsterAttributes.field_111267_a);
            AttributeModifier m = health.func_111127_a(this.healthModifierUUID);
            if (m != null) {
                health.func_111124_b(m);
            }
            if (!player.field_71075_bZ.field_75098_d) {
                player.field_71075_bZ.field_75101_c = false;
            }
            player.field_71075_bZ.field_75100_b = false;
            this.setFlightSpeed(player, 0.05f);
            player.func_71016_p();
        }
    }

    private void setPlayerBat(EntityPlayer player, boolean bat) {
        if (bat) {
            BatVampireAction.updatePlayerBatSize(player);
        }
        if (bat) {
            player.func_70107_b(player.field_70165_t, player.field_70163_u + 0.9999999403953552, player.field_70161_v);
        }
        player.eyeHeight = bat ? 0.68f : player.getDefaultEyeHeight();
    }
}

