/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.player.vampire.skills;

import de.teamlapen.lib.lib.util.UtilLib;
import de.teamlapen.vampirism.api.VReference;
import de.teamlapen.vampirism.api.VampirismAPI;
import de.teamlapen.vampirism.api.entity.player.actions.IAction;
import de.teamlapen.vampirism.api.entity.player.skills.ISkill;
import de.teamlapen.vampirism.api.entity.player.skills.ISkillManager;
import de.teamlapen.vampirism.api.entity.player.skills.SkillNode;
import de.teamlapen.vampirism.api.entity.player.vampire.IVampirePlayer;
import de.teamlapen.vampirism.config.Balance;
import de.teamlapen.vampirism.player.skills.ActionSkill;
import de.teamlapen.vampirism.player.skills.VampirismSkill;
import de.teamlapen.vampirism.player.vampire.VampirePlayer;
import de.teamlapen.vampirism.player.vampire.actions.VampireActions;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

@GameRegistry.ObjectHolder(value="vampirism")
public class VampireSkills {
    public static final ISkill night_vision = (ISkill)UtilLib.getNull();
    public static final ISkill vampire_regeneration = (ISkill)UtilLib.getNull();
    public static final ISkill bat = (ISkill)UtilLib.getNull();
    public static final ISkill summon_bats = (ISkill)UtilLib.getNull();
    public static final ISkill less_sundamage = (ISkill)UtilLib.getNull();
    public static final ISkill water_resistance = (ISkill)UtilLib.getNull();
    public static final ISkill less_blood_thirst = (ISkill)UtilLib.getNull();
    public static final ISkill vampire_disguise = (ISkill)UtilLib.getNull();
    public static final ISkill vampire_invisibility = (ISkill)UtilLib.getNull();
    public static final ISkill vampire_rage = (ISkill)UtilLib.getNull();
    public static final ISkill freeze = (ISkill)UtilLib.getNull();
    public static final ISkill sunscreen = (ISkill)UtilLib.getNull();
    public static final ISkill vampire_jump = (ISkill)UtilLib.getNull();
    public static final ISkill vampire_speed = (ISkill)UtilLib.getNull();
    public static final ISkill blood_vision = (ISkill)UtilLib.getNull();
    public static final ISkill creeper_avoided = (ISkill)UtilLib.getNull();
    public static final ISkill vampire_forest_fog = (ISkill)UtilLib.getNull();
    public static final ISkill teleport = (ISkill)UtilLib.getNull();
    public static final ISkill blood_charge = (ISkill)UtilLib.getNull();
    public static final ISkill sword_finisher = (ISkill)UtilLib.getNull();
    public static final ISkill dark_blood_projectile = (ISkill)UtilLib.getNull();
    public static final ISkill half_invulnerable = (ISkill)UtilLib.getNull();
    public static final ISkill advanced_biter = (ISkill)UtilLib.getNull();
    public static final ISkill garlic_blood_vision = (ISkill)UtilLib.getNull();

    public static void registerVampireSkills(IForgeRegistry<ISkill> registry) {
        registry.register((IForgeRegistryEntry)new VampirismSkill.SimpleVampireSkill(VReference.VAMPIRE_FACTION.getKey(), 32, 0, false));
        registry.register((IForgeRegistryEntry)new VampirismSkill.SimpleVampireSkill("night_vision", 48, 0, false){

            @Override
            public String getUnlocalizedName() {
                return "text.vampirism.skill.night_vision";
            }

            @Override
            protected void onDisabled(IVampirePlayer player) {
                player.unUnlockVision(VReference.vision_nightVision);
            }

            @Override
            protected void onEnabled(IVampirePlayer player) {
                player.unlockVision(VReference.vision_nightVision);
                player.activateVision(VReference.vision_nightVision);
            }
        });
        registry.register(new ActionSkill("vampire_regeneration", (IAction)VampireActions.regen));
        registry.register(new ActionSkill("bat", (IAction)VampireActions.bat));
        registry.register(new ActionSkill("summon_bats", (IAction)VampireActions.summon_bat, true));
        VampirismSkill.SimpleVampireSkill damage = new VampirismSkill.SimpleVampireSkill("less_sundamage", 96, 0, false);
        damage.registerAttributeModifier(VReference.sunDamage, "EB47EDC1-ED4E-4CD8-BDDC-BE40956042A2", Balance.vps.SUNDAMAGE_REDUCTION1, 2);
        registry.register((IForgeRegistryEntry)damage);
        VampirismSkill.SimpleVampireSkill damage2 = new VampirismSkill.SimpleVampireSkill("water_resistance", 208, 0, true){

            @Override
            protected void onDisabled(IVampirePlayer player) {
                ((VampirePlayer)player).getSpecialAttributes().waterResistance = false;
            }

            @Override
            protected void onEnabled(IVampirePlayer player) {
                ((VampirePlayer)player).getSpecialAttributes().waterResistance = true;
            }
        };
        registry.register((IForgeRegistryEntry)damage2);
        registry.register(new VampirismSkill.SimpleVampireSkill("less_blood_thirst", 80, 0, true).registerAttributeModifier(VReference.bloodExhaustion, "980ad86f-fe76-433b-b26a-c4060e0e6751", Balance.vps.BLOOD_THIRST_REDUCTION1, 2));
        registry.register(new ActionSkill("vampire_disguise", (IAction)VampireActions.disguise_vampire));
        registry.register(new ActionSkill("vampire_invisibility", (IAction)VampireActions.vampire_invisibility));
        registry.register(new ActionSkill("vampire_rage", (IAction)VampireActions.vampire_rage, true));
        VampirismSkill.SimpleVampireSkill advanced_biter = new VampirismSkill.SimpleVampireSkill("advanced_biter", 128, 0, false){

            @Override
            protected void onDisabled(IVampirePlayer player) {
                ((VampirePlayer)player).getSpecialAttributes().advanced_biter = false;
            }

            @Override
            protected void onEnabled(IVampirePlayer player) {
                ((VampirePlayer)player).getSpecialAttributes().advanced_biter = true;
            }
        };
        advanced_biter.setHasDefaultDescription();
        advanced_biter.registerAttributeModifier(VReference.biteDamage, "A08CAB62-EE88-4DB9-8F62-E9EF108A4E87", Balance.vps.BITE_DAMAGE_MULT, 1);
        registry.register((IForgeRegistryEntry)advanced_biter);
        registry.register((IForgeRegistryEntry)new VampirismSkill.SimpleVampireSkill("blood_charge", 240, 0, true));
        registry.register(new ActionSkill("freeze", (IAction)VampireActions.freeze, true));
        registry.register(new ActionSkill("sunscreen", (IAction)VampireActions.sunscreen, true));
        VampirismSkill.SimpleVampireSkill jump = new VampirismSkill.SimpleVampireSkill("vampire_jump", 160, 0, false){

            @Override
            public String getUnlocalizedName() {
                return "effect.jump";
            }

            @Override
            protected void onDisabled(IVampirePlayer player) {
                ((VampirePlayer)player).getSpecialAttributes().setJumpBoost(0);
            }

            @Override
            protected void onEnabled(IVampirePlayer player) {
                ((VampirePlayer)player).getSpecialAttributes().setJumpBoost(Balance.vps.JUMP_BOOST + 1);
            }
        };
        registry.register((IForgeRegistryEntry)jump);
        VampirismSkill.SimpleVampireSkill speed = new VampirismSkill.SimpleVampireSkill("vampire_speed", 144, 0, false){

            @Override
            public String getUnlocalizedName() {
                return "effect.moveSpeed";
            }
        };
        speed.registerAttributeModifier(SharedMonsterAttributes.field_111263_d, "96dc968d-818f-4271-8dbf-6b799d603ad8", Balance.vps.SPEED_BOOST, 2);
        registry.register((IForgeRegistryEntry)speed);
        registry.register((IForgeRegistryEntry)new VampirismSkill.SimpleVampireSkill("blood_vision", 176, 0, true){

            @Override
            protected void onDisabled(IVampirePlayer player) {
                player.unUnlockVision(VReference.vision_bloodVision);
            }

            @Override
            protected void onEnabled(IVampirePlayer player) {
                player.unlockVision(VReference.vision_bloodVision);
            }
        });
        registry.register((IForgeRegistryEntry)new VampirismSkill.SimpleVampireSkill("creeper_avoided", 192, 0, false){

            @Override
            public String getLocalizedDescription() {
                if (Balance.vps.DISABLE_AVOIDED_BY_CREEPERS) {
                    return TextFormatting.RED + "Disabled by admin" + TextFormatting.RESET;
                }
                return super.getLocalizedDescription();
            }

            @Override
            public String getUnlocalizedName() {
                return "text.vampirism.skill.avoided_by_creepers";
            }

            @Override
            protected void onDisabled(IVampirePlayer player) {
                ((VampirePlayer)player).getSpecialAttributes().avoided_by_creepers = false;
            }

            @Override
            protected void onEnabled(IVampirePlayer player) {
                ((VampirePlayer)player).getSpecialAttributes().avoided_by_creepers = true;
            }
        });
        registry.register((IForgeRegistryEntry)new VampirismSkill.SimpleVampireSkill("vampire_forest_fog", 224, 0, true){

            @Override
            protected void onDisabled(IVampirePlayer player) {
                ((VampirePlayer)player).getSpecialAttributes().increasedVampireFogDistance = false;
            }

            @Override
            protected void onEnabled(IVampirePlayer player) {
                ((VampirePlayer)player).getSpecialAttributes().increasedVampireFogDistance = true;
            }
        });
        registry.register(new ActionSkill("teleport", (IAction)VampireActions.teleport));
        registry.register((IForgeRegistryEntry)new VampirismSkill.SimpleVampireSkill("sword_finisher", 0, 16, true){

            @Override
            public String getLocalizedDescription() {
                return UtilLib.translateFormatted("text.vampirism.skill.sword_finisher.desc", (int)(Balance.vps.SWORD_FINISHER_MAX_HEALTH_PERC * 100.0));
            }
        });
        registry.register(new ActionSkill("dark_blood_projectile", (IAction)VampireActions.dark_blood_projectile));
        registry.register(new ActionSkill("half_invulnerable", (IAction)VampireActions.half_invulnerable, true));
        registry.register((IForgeRegistryEntry)new VampirismSkill.SimpleVampireSkill(new ResourceLocation("vampirism", "garlic_blood_vision"), 16, 16, true){

            @Override
            protected void onDisabled(IVampirePlayer player) {
                ((VampirePlayer)player).getSpecialAttributes().garlic_blood_vision = false;
            }

            @Override
            protected void onEnabled(IVampirePlayer player) {
                ((VampirePlayer)player).getSpecialAttributes().garlic_blood_vision = true;
            }
        });
    }

    public static void buildSkillTree(SkillNode root) {
        ISkillManager skillManager = VampirismAPI.skillManager();
        SkillNode skill2 = skillManager.createSkillNode(root, night_vision);
        SkillNode skill3 = skillManager.createSkillNode(skill2, vampire_regeneration);
        SkillNode skill4 = skillManager.createSkillNode(skill3, bat);
        VampireSkills.registerOffensiveSkills(skillManager, skill4);
        VampireSkills.registerUtilSkills(skillManager, skill4);
        VampireSkills.registerDefensiveSkills(skillManager, skill4);
    }

    private static void registerUtilSkills(ISkillManager skillManager, SkillNode start) {
        SkillNode skill1 = skillManager.createSkillNode(start, summon_bats);
        SkillNode skill2 = skillManager.createSkillNode(skill1, less_sundamage, water_resistance);
        SkillNode skill3 = skillManager.createSkillNode(skill2, less_blood_thirst);
        SkillNode skill4 = skillManager.createSkillNode(skill3, vampire_disguise);
        SkillNode skill5 = skillManager.createSkillNode(skill4, half_invulnerable);
        SkillNode skill6 = skillManager.createSkillNode(skill5, vampire_invisibility);
    }

    private static void registerOffensiveSkills(ISkillManager skillManager, SkillNode start) {
        SkillNode skill1 = skillManager.createSkillNode(start, vampire_rage);
        SkillNode skill2 = skillManager.createSkillNode(skill1, advanced_biter);
        SkillNode skill3 = skillManager.createSkillNode(skill2, sword_finisher);
        SkillNode skill4 = skillManager.createSkillNode(skill3, dark_blood_projectile);
        SkillNode skill5 = skillManager.createSkillNode(skill4, blood_charge);
        SkillNode skill6 = skillManager.createSkillNode(skill5, freeze);
    }

    private static void registerDefensiveSkills(ISkillManager skillManager, SkillNode start) {
        SkillNode skill1 = skillManager.createSkillNode(start, sunscreen);
        SkillNode skill2 = skillManager.createSkillNode(skill1, vampire_jump, vampire_speed);
        SkillNode skill3 = skillManager.createSkillNode(skill2, blood_vision);
        SkillNode skill4 = skillManager.createSkillNode(skill3, creeper_avoided);
        SkillNode skill5 = skillManager.createSkillNode(skill4, vampire_forest_fog, garlic_blood_vision);
        SkillNode skill6 = skillManager.createSkillNode(skill5, teleport);
    }

    public static void fixMapping(RegistryEvent.MissingMappings.Mapping<ISkill> m) {
        if (new ResourceLocation("vampirism:bite1").equals((Object)m.key) || new ResourceLocation("vampirism:bite2").equals((Object)m.key)) {
            m.ignore();
        }
    }
}

