/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.world;

import com.google.common.collect.Maps;
import de.teamlapen.vampirism.VampirismMod;
import de.teamlapen.vampirism.api.EnumStrength;
import de.teamlapen.vampirism.api.world.IGarlicChunkHandler;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.command.ICommandSender;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;

public class GarlicChunkHandler
implements IGarlicChunkHandler {
    private final HashMap<ChunkPos, EnumStrength> strengthHashMap = Maps.newHashMap();
    private final HashMap<Integer, Emitter> emitterHashMap = Maps.newHashMap();

    @Override
    public void clear() {
        this.strengthHashMap.clear();
        this.emitterHashMap.clear();
    }

    @Override
    @Nonnull
    public EnumStrength getStrengthAtChunk(ChunkPos pos) {
        EnumStrength s = this.strengthHashMap.get(pos);
        return s == null ? EnumStrength.NONE : s;
    }

    public void printDebug(ICommandSender sender) {
        for (Emitter emitter : this.emitterHashMap.values()) {
            sender.func_145747_a((ITextComponent)new TextComponentString("E: " + emitter.toString()));
        }
        for (Map.Entry entry : this.strengthHashMap.entrySet()) {
            sender.func_145747_a((ITextComponent)new TextComponentString("S: " + entry.toString()));
        }
    }

    @Override
    public int registerGarlicBlock(EnumStrength strength, ChunkPos ... pos) {
        for (ChunkPos p : pos) {
            if (p != null) continue;
            throw new IllegalArgumentException("Garlic emitter position should not be null");
        }
        Emitter e = new Emitter(strength, pos);
        int hash = e.hashCode();
        if (this.isHostingClient()) {
            return hash;
        }
        this.emitterHashMap.put(hash, e);
        this.rebuildStrengthMap();
        return hash;
    }

    @Override
    public void removeGarlicBlock(int id) {
        if (this.isHostingClient()) {
            return;
        }
        Emitter e = this.emitterHashMap.remove(id);
        if (e == null) {
            VampirismMod.log.d("GarlicChunkHandler", "Removed emitter did not exist", new Object[0]);
        }
        this.rebuildStrengthMap();
    }

    private boolean isHostingClient() {
        return FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT && FMLCommonHandler.instance().getMinecraftServerInstance() != null;
    }

    private void rebuildStrengthMap() {
        this.strengthHashMap.clear();
        for (Emitter e : this.emitterHashMap.values()) {
            for (ChunkPos pos : e.pos) {
                EnumStrength old = this.strengthHashMap.get(pos);
                if (old != null && !e.strength.isStrongerThan(old)) continue;
                this.strengthHashMap.put(pos, e.strength);
            }
        }
    }

    private class Emitter {
        final EnumStrength strength;
        final ChunkPos[] pos;

        private Emitter(EnumStrength strength, ChunkPos[] pos) {
            this.strength = strength;
            this.pos = pos;
        }

        public String toString() {
            return "Emitter{pos=" + Arrays.toString(this.pos) + ", strength=" + (Object)((Object)this.strength) + '}';
        }
    }

    public static class Provider
    implements IGarlicChunkHandler.Provider {
        private final HashMap<Integer, IGarlicChunkHandler> handlers = Maps.newHashMap();

        @Override
        public void clear() {
            for (IGarlicChunkHandler handler : this.handlers.values()) {
                handler.clear();
            }
            this.handlers.clear();
        }

        @Override
        @Nonnull
        public IGarlicChunkHandler getHandler(World world) {
            return this.handlers.computeIfAbsent(world.field_73011_w.getDimension(), k -> new GarlicChunkHandler());
        }
    }
}

