/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbquests;

import com.feed_the_beast.ftblib.events.FTBLibPreInitRegistryEvent;
import com.feed_the_beast.ftblib.lib.gui.GuiIcons;
import com.feed_the_beast.ftblib.lib.icon.Icon;
import com.feed_the_beast.ftblib.lib.util.BlockUtils;
import com.feed_the_beast.ftbquests.FTBQuests;
import com.feed_the_beast.ftbquests.block.BlockDetector;
import com.feed_the_beast.ftbquests.block.BlockLootCrateOpener;
import com.feed_the_beast.ftbquests.block.BlockLootCrateStorage;
import com.feed_the_beast.ftbquests.block.BlockProgressDetector;
import com.feed_the_beast.ftbquests.block.BlockProgressScreen;
import com.feed_the_beast.ftbquests.block.BlockProgressScreenPart;
import com.feed_the_beast.ftbquests.block.BlockQuestBarrier;
import com.feed_the_beast.ftbquests.block.BlockQuestChest;
import com.feed_the_beast.ftbquests.block.BlockRewardCollector;
import com.feed_the_beast.ftbquests.block.BlockTaskScreen;
import com.feed_the_beast.ftbquests.block.BlockTaskScreenPart;
import com.feed_the_beast.ftbquests.block.FTBQuestsBlocks;
import com.feed_the_beast.ftbquests.block.ItemBlockBarrier;
import com.feed_the_beast.ftbquests.block.ItemBlockDetector;
import com.feed_the_beast.ftbquests.block.ItemBlockProgressScreen;
import com.feed_the_beast.ftbquests.block.ItemBlockTaskScreen;
import com.feed_the_beast.ftbquests.client.ClientQuestFile;
import com.feed_the_beast.ftbquests.events.ClearFileCacheEvent;
import com.feed_the_beast.ftbquests.item.FTBQuestsItems;
import com.feed_the_beast.ftbquests.item.ItemCustomIcon;
import com.feed_the_beast.ftbquests.item.ItemLootCrate;
import com.feed_the_beast.ftbquests.item.ItemQuestBook;
import com.feed_the_beast.ftbquests.quest.QuestData;
import com.feed_the_beast.ftbquests.quest.QuestFile;
import com.feed_the_beast.ftbquests.quest.ServerQuestFile;
import com.feed_the_beast.ftbquests.quest.loot.LootCrate;
import com.feed_the_beast.ftbquests.quest.reward.AdvancementReward;
import com.feed_the_beast.ftbquests.quest.reward.ChoiceReward;
import com.feed_the_beast.ftbquests.quest.reward.CommandReward;
import com.feed_the_beast.ftbquests.quest.reward.CustomReward;
import com.feed_the_beast.ftbquests.quest.reward.FTBQuestsRewards;
import com.feed_the_beast.ftbquests.quest.reward.ItemReward;
import com.feed_the_beast.ftbquests.quest.reward.LootReward;
import com.feed_the_beast.ftbquests.quest.reward.RandomReward;
import com.feed_the_beast.ftbquests.quest.reward.RewardType;
import com.feed_the_beast.ftbquests.quest.reward.ToastReward;
import com.feed_the_beast.ftbquests.quest.reward.XPLevelsReward;
import com.feed_the_beast.ftbquests.quest.reward.XPReward;
import com.feed_the_beast.ftbquests.quest.task.AdvancementTask;
import com.feed_the_beast.ftbquests.quest.task.CheckmarkTask;
import com.feed_the_beast.ftbquests.quest.task.CustomTask;
import com.feed_the_beast.ftbquests.quest.task.DimensionTask;
import com.feed_the_beast.ftbquests.quest.task.FTBQuestsTasks;
import com.feed_the_beast.ftbquests.quest.task.FluidTask;
import com.feed_the_beast.ftbquests.quest.task.ForgeEnergyTask;
import com.feed_the_beast.ftbquests.quest.task.InteractionTask;
import com.feed_the_beast.ftbquests.quest.task.ItemTask;
import com.feed_the_beast.ftbquests.quest.task.KillTask;
import com.feed_the_beast.ftbquests.quest.task.LocationTask;
import com.feed_the_beast.ftbquests.quest.task.ObservationTask;
import com.feed_the_beast.ftbquests.quest.task.StatTask;
import com.feed_the_beast.ftbquests.quest.task.Task;
import com.feed_the_beast.ftbquests.quest.task.TaskData;
import com.feed_the_beast.ftbquests.quest.task.TaskType;
import com.feed_the_beast.ftbquests.quest.task.XPTask;
import com.feed_the_beast.ftbquests.tile.TileLootCrateOpener;
import com.feed_the_beast.ftbquests.tile.TileLootCrateStorage;
import com.feed_the_beast.ftbquests.tile.TileProgressDetector;
import com.feed_the_beast.ftbquests.tile.TileProgressScreenCore;
import com.feed_the_beast.ftbquests.tile.TileProgressScreenPart;
import com.feed_the_beast.ftbquests.tile.TileQuestBarrier;
import com.feed_the_beast.ftbquests.tile.TileQuestChest;
import com.feed_the_beast.ftbquests.tile.TileRewardCollector;
import com.feed_the_beast.ftbquests.tile.TileTaskScreenCore;
import com.feed_the_beast.ftbquests.tile.TileTaskScreenPart;
import com.feed_the_beast.ftbquests.util.ConfigQuestObject;
import com.feed_the_beast.ftbquests.util.FTBQuestsInventoryListener;
import com.feed_the_beast.ftbquests.util.RayMatcher;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.ints.IntSets;
import java.util.List;
import java.util.ListIterator;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.player.PlayerDropsEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber(modid="ftbquests")
public class FTBQuestsEventHandler {
    private static List<KillTask> killTasks = null;
    private static List<Task> autoSubmitTasks = null;
    private static List<InteractionTask> interactionTasks = null;

    private static Block withName(Block block, String name) {
        block.func_149647_a(FTBQuests.TAB);
        block.setRegistryName(name);
        block.func_149663_c("ftbquests." + name);
        return block;
    }

    private static Item withName(Item item, String name) {
        item.func_77637_a(FTBQuests.TAB);
        item.setRegistryName(name);
        item.func_77655_b("ftbquests." + name);
        return item;
    }

    @SubscribeEvent
    public static void registerBlocks(RegistryEvent.Register<Block> event) {
        event.getRegistry().registerAll((IForgeRegistryEntry[])new Block[]{FTBQuestsEventHandler.withName((Block)new BlockTaskScreen(), "screen"), FTBQuestsEventHandler.withName((Block)new BlockTaskScreenPart(), "screen_part"), FTBQuestsEventHandler.withName(new BlockProgressDetector(), "progress_detector"), FTBQuestsEventHandler.withName(new BlockDetector(), "detector"), FTBQuestsEventHandler.withName((Block)new BlockProgressScreen(), "progress_screen"), FTBQuestsEventHandler.withName((Block)new BlockProgressScreenPart(), "progress_screen_part"), FTBQuestsEventHandler.withName((Block)new BlockQuestChest(), "chest"), FTBQuestsEventHandler.withName((Block)new BlockLootCrateStorage(), "loot_crate_storage"), FTBQuestsEventHandler.withName((Block)new BlockLootCrateOpener(), "loot_crate_opener"), FTBQuestsEventHandler.withName(new BlockQuestBarrier(), "barrier"), FTBQuestsEventHandler.withName((Block)new BlockRewardCollector(), "reward_collector")});
        GameRegistry.registerTileEntity(TileTaskScreenCore.class, (ResourceLocation)new ResourceLocation("ftbquests", "screen_core"));
        GameRegistry.registerTileEntity(TileTaskScreenPart.class, (ResourceLocation)new ResourceLocation("ftbquests", "screen_part"));
        GameRegistry.registerTileEntity(TileProgressDetector.class, (ResourceLocation)new ResourceLocation("ftbquests", "progress_detector"));
        GameRegistry.registerTileEntity(TileProgressScreenCore.class, (ResourceLocation)new ResourceLocation("ftbquests", "progress_screen_core"));
        GameRegistry.registerTileEntity(TileProgressScreenPart.class, (ResourceLocation)new ResourceLocation("ftbquests", "progress_screen_part"));
        GameRegistry.registerTileEntity(TileQuestChest.class, (ResourceLocation)new ResourceLocation("ftbquests", "chest"));
        GameRegistry.registerTileEntity(TileLootCrateStorage.class, (ResourceLocation)new ResourceLocation("ftbquests", "loot_crate_storage"));
        GameRegistry.registerTileEntity(TileLootCrateOpener.class, (ResourceLocation)new ResourceLocation("ftbquests", "loot_crate_opener"));
        GameRegistry.registerTileEntity(TileQuestBarrier.class, (ResourceLocation)new ResourceLocation("ftbquests", "barrier"));
        GameRegistry.registerTileEntity(TileRewardCollector.class, (ResourceLocation)new ResourceLocation("ftbquests", "reward_collector"));
        for (BlockDetector.Variant variant : BlockDetector.Variant.VALUES) {
            GameRegistry.registerTileEntity(variant.clazz, (ResourceLocation)new ResourceLocation("ftbquests", variant.func_176610_l() + "_detector"));
        }
    }

    @SubscribeEvent
    public static void registerItems(RegistryEvent.Register<Item> event) {
        event.getRegistry().registerAll((IForgeRegistryEntry[])new Item[]{(Item)new ItemBlockTaskScreen(FTBQuestsBlocks.SCREEN).setRegistryName("screen"), (Item)new ItemBlock(FTBQuestsBlocks.PROGRESS_DETECTOR).setRegistryName("progress_detector"), (Item)new ItemBlockDetector(FTBQuestsBlocks.DETECTOR).setRegistryName("detector"), (Item)new ItemBlockProgressScreen(FTBQuestsBlocks.PROGRESS_SCREEN).setRegistryName("progress_screen"), (Item)new ItemBlock(FTBQuestsBlocks.CHEST).setRegistryName("chest"), (Item)new ItemBlock(FTBQuestsBlocks.LOOT_CRATE_STORAGE).setRegistryName("loot_crate_storage"), (Item)new ItemBlock(FTBQuestsBlocks.LOOT_CRATE_OPENER).setRegistryName("loot_crate_opener"), (Item)new ItemBlockBarrier(FTBQuestsBlocks.BARRIER).setRegistryName("barrier"), (Item)new ItemBlock(FTBQuestsBlocks.REWARD_COLLECTOR).setRegistryName("reward_collector"), FTBQuestsEventHandler.withName(new ItemQuestBook(), "book"), FTBQuestsEventHandler.withName(new ItemLootCrate(), "lootcrate"), FTBQuestsEventHandler.withName(new ItemCustomIcon(), "custom_icon")});
    }

    @SubscribeEvent
    public static void registerTasks(RegistryEvent.Register<TaskType> event) {
        event.getRegistry().registerAll((IForgeRegistryEntry[])new TaskType[]{FTBQuestsTasks.ITEM = ((TaskType)new TaskType(ItemTask::new).setRegistryName("item")).setIcon(Icon.getIcon((String)"minecraft:items/diamond")), FTBQuestsTasks.FLUID = ((TaskType)new TaskType(FluidTask::new).setRegistryName("fluid")).setIcon(Icon.getIcon((String)FluidRegistry.WATER.getStill(new FluidStack(FluidRegistry.WATER, 1000)).toString()).combineWith(Icon.getIcon((String)FluidTask.TANK_TEXTURE.toString()))), FTBQuestsTasks.FORGE_ENERGY = ((TaskType)new TaskType(ForgeEnergyTask::new).setRegistryName("forge_energy")).setIcon(Icon.getIcon((String)ForgeEnergyTask.EMPTY_TEXTURE.toString()).combineWith(Icon.getIcon((String)ForgeEnergyTask.FULL_TEXTURE.toString()))), FTBQuestsTasks.CUSTOM = ((TaskType)new TaskType(CustomTask::new).setRegistryName("custom")).setIcon(GuiIcons.COLOR_HSB), FTBQuestsTasks.XP = ((TaskType)new TaskType(XPTask::new).setRegistryName("xp")).setIcon(Icon.getIcon((String)"minecraft:items/experience_bottle")), FTBQuestsTasks.DIMENSION = ((TaskType)new TaskType(DimensionTask::new).setRegistryName("dimension")).setIcon(Icon.getIcon((String)"minecraft:blocks/portal")), FTBQuestsTasks.STAT = ((TaskType)new TaskType(StatTask::new).setRegistryName("stat")).setIcon(Icon.getIcon((String)"minecraft:items/iron_sword")), FTBQuestsTasks.KILL = ((TaskType)new TaskType(KillTask::new).setRegistryName("kill")).setIcon(Icon.getIcon((String)"minecraft:items/diamond_sword")), FTBQuestsTasks.LOCATION = ((TaskType)new TaskType(LocationTask::new).setRegistryName("location")).setIcon(Icon.getIcon((String)"minecraft:items/compass_00")), FTBQuestsTasks.CHECKMARK = ((TaskType)new TaskType(CheckmarkTask::new).setRegistryName("checkmark")).setIcon(GuiIcons.ACCEPT_GRAY), FTBQuestsTasks.ADVANCEMENT = ((TaskType)new TaskType(AdvancementTask::new).setRegistryName("advancement")).setIcon(Icon.getIcon((String)"minecraft:items/wheat")), FTBQuestsTasks.OBSERVATION = ((TaskType)new TaskType(ObservationTask::new).setRegistryName("observation")).setIcon(GuiIcons.ART), FTBQuestsTasks.INTERACTION = ((TaskType)new TaskType(InteractionTask::new).setRegistryName("interaction")).setIcon(GuiIcons.BELL)});
        FTBQuests.PROXY.setTaskGuiProviders();
    }

    @SubscribeEvent
    public static void registerRewards(RegistryEvent.Register<RewardType> event) {
        event.getRegistry().registerAll((IForgeRegistryEntry[])new RewardType[]{FTBQuestsRewards.ITEM = ((RewardType)new RewardType(ItemReward::new).setRegistryName("item")).setIcon(Icon.getIcon((String)"minecraft:items/diamond")), FTBQuestsRewards.CHOICE = ((RewardType)new RewardType(ChoiceReward::new).setRegistryName("choice")).setIcon(GuiIcons.COLOR_RGB).setExcludeFromListRewards(true), FTBQuestsRewards.RANDOM = ((RewardType)new RewardType(RandomReward::new).setRegistryName("random")).setIcon(GuiIcons.DICE).setExcludeFromListRewards(true), FTBQuestsRewards.LOOT = ((RewardType)new RewardType(LootReward::new).setRegistryName("loot")).setIcon(GuiIcons.MONEY_BAG).setExcludeFromListRewards(true), FTBQuestsRewards.COMMAND = ((RewardType)new RewardType(CommandReward::new).setRegistryName("command")).setIcon(Icon.getIcon((String)"minecraft:blocks/command_block_back")), FTBQuestsRewards.CUSTOM = ((RewardType)new RewardType(CustomReward::new).setRegistryName("custom")).setIcon(GuiIcons.COLOR_HSB), FTBQuestsRewards.XP = ((RewardType)new RewardType(XPReward::new).setRegistryName("xp")).setIcon(Icon.getIcon((String)"minecraft:items/experience_bottle")), FTBQuestsRewards.XP_LEVELS = ((RewardType)new RewardType(XPLevelsReward::new).setRegistryName("xp_levels")).setIcon(Icon.getIcon((String)"minecraft:items/experience_bottle")), FTBQuestsRewards.ADVANCEMENT = ((RewardType)new RewardType(AdvancementReward::new).setRegistryName("advancement")).setIcon(Icon.getIcon((String)"minecraft:items/wheat")), FTBQuestsRewards.TOAST = ((RewardType)new RewardType(ToastReward::new).setRegistryName("toast")).setIcon(Icon.getIcon((String)"minecraft:items/sign"))});
        FTBQuests.PROXY.setRewardGuiProviders();
    }

    @SubscribeEvent
    public static void registerFTBLib(FTBLibPreInitRegistryEvent event) {
        event.getRegistry().registerConfigValueProvider("ftbquests_object", () -> new ConfigQuestObject((QuestFile)ClientQuestFile.INSTANCE, 0, (IntSet)IntSets.EMPTY_SET));
    }

    @SubscribeEvent
    public static void onFileCacheClear(ClearFileCacheEvent event) {
        killTasks = null;
        autoSubmitTasks = null;
        interactionTasks = null;
    }

    @SubscribeEvent
    public static void onLivingDrops(LivingDropsEvent event) {
        EntityLivingBase e = event.getEntityLiving();
        if (e.field_70170_p.field_72995_K || e instanceof EntityPlayer) {
            return;
        }
        if (ServerQuestFile.INSTANCE == null || !ServerQuestFile.INSTANCE.dropLootCrates) {
            return;
        }
        LootCrate crate = ServerQuestFile.INSTANCE.getRandomLootCrate((Entity)e, e.field_70170_p.field_73012_v);
        if (crate != null) {
            EntityItem ei = new EntityItem(e.field_70170_p, e.field_70165_t, e.field_70163_u, e.field_70161_v, crate.createStack());
            ei.func_174867_a(10);
            event.getDrops().add(ei);
        }
    }

    @SubscribeEvent
    public static void onPlayerKill(LivingDeathEvent event) {
        if (event.getSource().func_76346_g() instanceof EntityPlayerMP) {
            if (killTasks == null) {
                killTasks = ServerQuestFile.INSTANCE.collect(KillTask.class);
            }
            if (killTasks.isEmpty()) {
                return;
            }
            EntityPlayerMP player = (EntityPlayerMP)event.getSource().func_76346_g();
            QuestData data = ServerQuestFile.INSTANCE.getData((Entity)player);
            if (data == null) {
                return;
            }
            for (KillTask task : killTasks) {
                TaskData taskData = data.getTaskData(task);
                if (taskData.progress >= task.getMaxProgress() || !task.quest.canStartTasks(data)) continue;
                ((KillTask.Data)taskData).kill(event.getEntityLiving());
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.END && !event.player.field_70170_p.field_72995_K && ServerQuestFile.INSTANCE != null) {
            if (autoSubmitTasks == null) {
                autoSubmitTasks = ServerQuestFile.INSTANCE.collect(Task.class, o -> o instanceof Task && ((Task)o).autoSubmitOnPlayerTick() > 0);
            }
            if (autoSubmitTasks.isEmpty()) {
                return;
            }
            QuestData data = ServerQuestFile.INSTANCE.getData((Entity)event.player);
            if (data == null) {
                return;
            }
            if (autoSubmitTasks == null || autoSubmitTasks.isEmpty()) {
                return;
            }
            long t = event.player.field_70170_p.func_82737_E();
            for (Task task : autoSubmitTasks) {
                TaskData taskData;
                long d = task.autoSubmitOnPlayerTick();
                if (d <= 0L || t % d != 0L || (taskData = data.getTaskData(task)).isComplete() || !task.quest.canStartTasks(data)) continue;
                taskData.submitTask((EntityPlayerMP)event.player);
            }
        }
    }

    @SubscribeEvent
    public static void onItemCrafted(PlayerEvent.ItemCraftedEvent event) {
        if (event.player instanceof EntityPlayerMP && !event.crafting.func_190926_b()) {
            FTBQuestsInventoryListener.detect((EntityPlayerMP)event.player, event.crafting, 0);
        }
    }

    @SubscribeEvent
    public static void onItemSmelt(PlayerEvent.ItemSmeltedEvent event) {
        if (event.player instanceof EntityPlayerMP && !event.smelting.func_190926_b()) {
            FTBQuestsInventoryListener.detect((EntityPlayerMP)event.player, event.smelting, 0);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void onPlayerClone(PlayerEvent.Clone event) {
        if (!event.isWasDeath()) {
            return;
        }
        EntityPlayer player = event.getEntityPlayer();
        EntityPlayer oldPlayer = event.getOriginal();
        if (player instanceof FakePlayer || player.field_70170_p.func_82736_K().func_82766_b("keepInventory")) {
            return;
        }
        for (int i = 0; i < oldPlayer.field_71071_by.field_70462_a.size(); ++i) {
            ItemStack stack = (ItemStack)oldPlayer.field_71071_by.field_70462_a.get(i);
            if (stack.func_77973_b() != FTBQuestsItems.BOOK || !player.func_191521_c(stack)) continue;
            oldPlayer.field_71071_by.field_70462_a.set(i, (Object)ItemStack.field_190927_a);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void onPlayerDropsEvent(PlayerDropsEvent event) {
        EntityPlayer player = event.getEntityPlayer();
        if (player instanceof FakePlayer || player.field_70170_p.func_82736_K().func_82766_b("keepInventory")) {
            return;
        }
        ListIterator iterator = event.getDrops().listIterator();
        while (iterator.hasNext()) {
            EntityItem drop = (EntityItem)iterator.next();
            ItemStack stack = drop.func_92059_d();
            if (stack.func_77973_b() != FTBQuestsItems.BOOK || !player.func_191521_c(stack)) continue;
            iterator.remove();
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void onBlockRightClick(PlayerInteractEvent.RightClickBlock event) {
        if (event.getWorld().field_72995_K) {
            return;
        }
        if (interactionTasks == null) {
            interactionTasks = ServerQuestFile.INSTANCE.collect(InteractionTask.class);
        }
        if (interactionTasks.isEmpty()) {
            return;
        }
        QuestData data = ServerQuestFile.INSTANCE.getData((Entity)event.getEntityPlayer());
        if (data == null) {
            return;
        }
        RayMatcher.Data matcherData = RayMatcher.Data.get(event.getWorld().func_180495_p(event.getPos()), event.getWorld().func_175625_s(event.getPos()), null);
        for (InteractionTask task : interactionTasks) {
            TaskData taskData = data.getTaskData(task);
            if (taskData.isComplete() || !task.matcher.matches(matcherData) || !task.quest.canStartTasks(data)) continue;
            taskData.submitTask((EntityPlayerMP)event.getEntityPlayer());
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void onEntityRightClick(PlayerInteractEvent.EntityInteract event) {
        if (event.getWorld().field_72995_K) {
            return;
        }
        if (interactionTasks == null) {
            interactionTasks = ServerQuestFile.INSTANCE.collect(InteractionTask.class);
        }
        if (interactionTasks.isEmpty()) {
            return;
        }
        QuestData data = ServerQuestFile.INSTANCE.getData((Entity)event.getEntityPlayer());
        if (data == null) {
            return;
        }
        RayMatcher.Data matcherData = RayMatcher.Data.get(BlockUtils.AIR_STATE, null, event.getTarget());
        for (InteractionTask task : interactionTasks) {
            TaskData taskData = data.getTaskData(task);
            if (taskData.isComplete() || !task.matcher.matches(matcherData) || !task.quest.canStartTasks(data)) continue;
            taskData.submitTask((EntityPlayerMP)event.getEntityPlayer());
        }
    }
}

