/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbquests.gui.tree;

import com.feed_the_beast.ftblib.lib.gui.ContextMenuItem;
import com.feed_the_beast.ftblib.lib.gui.GuiHelper;
import com.feed_the_beast.ftblib.lib.gui.GuiIcons;
import com.feed_the_beast.ftblib.lib.gui.Panel;
import com.feed_the_beast.ftblib.lib.icon.Icon;
import com.feed_the_beast.ftblib.lib.util.FileUtils;
import com.feed_the_beast.ftblib.lib.util.misc.MouseButton;
import com.feed_the_beast.ftbquests.client.ClientQuestFile;
import com.feed_the_beast.ftbquests.gui.GuiRewardTables;
import com.feed_the_beast.ftbquests.gui.tree.ButtonTab;
import com.feed_the_beast.ftbquests.net.edit.MessageChangeProgress;
import com.feed_the_beast.ftbquests.quest.ChangeProgress;
import com.feed_the_beast.ftbquests.quest.Chapter;
import com.feed_the_beast.ftbquests.quest.Quest;
import com.feed_the_beast.ftbquests.quest.theme.ThemeLoader;
import com.feed_the_beast.ftbquests.quest.theme.property.ThemeProperties;
import java.io.File;
import java.util.ArrayList;
import java.util.Calendar;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.event.ClickEvent;

public class ButtonEditSettings
extends ButtonTab {
    public ButtonEditSettings(Panel panel) {
        super(panel, I18n.func_135052_a((String)"gui.settings", (Object[])new Object[0]), (Icon)ThemeProperties.SETTINGS_ICON.get());
    }

    public void onClicked(MouseButton button) {
        GuiHelper.playClickSound();
        if (this.treeGui.contextMenu != null) {
            this.treeGui.closeContextMenu();
            return;
        }
        ArrayList<ContextMenuItem> contextMenu = new ArrayList<ContextMenuItem>();
        contextMenu.add(new ContextMenuItem(I18n.func_135052_a((String)"ftbquests.gui.edit_file", (Object[])new Object[0]), (Icon)ThemeProperties.SETTINGS_ICON.get(), this.treeGui.file::onEditButtonClicked));
        contextMenu.add(new ContextMenuItem(I18n.func_135052_a((String)"ftbquests.gui.reset_progress", (Object[])new Object[0]), (Icon)ThemeProperties.RELOAD_ICON.get(), () -> new MessageChangeProgress(ClientQuestFile.INSTANCE.self.getTeamUID(), this.treeGui.file.id, ChangeProgress.RESET).sendToServer()).setYesNo(I18n.func_135052_a((String)"ftbquests.gui.reset_progress_q", (Object[])new Object[0])));
        contextMenu.add(new ContextMenuItem(I18n.func_135052_a((String)"ftbquests.gui.complete_instantly", (Object[])new Object[0]), (Icon)ThemeProperties.CHECK_ICON.get(), () -> new MessageChangeProgress(ClientQuestFile.INSTANCE.self.getTeamUID(), this.treeGui.file.id, ChangeProgress.COMPLETE).sendToServer()).setYesNo(I18n.func_135052_a((String)"ftbquests.gui.complete_instantly_q", (Object[])new Object[0])));
        contextMenu.add(new ContextMenuItem(I18n.func_135052_a((String)"ftbquests.reward_tables", (Object[])new Object[0]), (Icon)ThemeProperties.REWARD_TABLE_ICON.get(), () -> new GuiRewardTables().openGui()));
        contextMenu.add(new ContextMenuItem(I18n.func_135052_a((String)"ftbquests.gui.save_as_file", (Object[])new Object[0]), (Icon)ThemeProperties.DOWNLOAD_ICON.get(), () -> {
            try {
                Calendar time = Calendar.getInstance();
                StringBuilder fileName = new StringBuilder("local/ftbquests/saved/");
                this.appendNum(fileName, time.get(1), '-');
                this.appendNum(fileName, time.get(2) + 1, '-');
                this.appendNum(fileName, time.get(5), '-');
                this.appendNum(fileName, time.get(11), '-');
                this.appendNum(fileName, time.get(12), '-');
                this.appendNum(fileName, time.get(13), '\u0000');
                File file = new File(Minecraft.func_71410_x().field_71412_D, fileName.toString()).getCanonicalFile();
                ClientQuestFile.INSTANCE.writeDataFull(file);
                TextComponentTranslation component = new TextComponentTranslation("ftbquests.gui.saved_as_file", new Object[]{file.getPath().replace(Minecraft.func_71410_x().field_71412_D.getCanonicalFile().getAbsolutePath(), "")});
                component.func_150256_b().func_150241_a(new ClickEvent(ClickEvent.Action.OPEN_FILE, file.getAbsolutePath()));
                Minecraft.func_71410_x().field_71439_g.func_145747_a((ITextComponent)component);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }));
        contextMenu.add(new ContextMenuItem(I18n.func_135052_a((String)"ftbquests.gui.export_spreadsheet", (Object[])new Object[0]), (Icon)ThemeProperties.DOWNLOAD_ICON.get(), () -> {
            try {
                int maxQuests = 0;
                for (Chapter chapter : ClientQuestFile.INSTANCE.chapters) {
                    maxQuests = Math.max(maxQuests, chapter.quests.size());
                }
                String[][] cells = new String[ClientQuestFile.INSTANCE.chapters.size() * 2][maxQuests + 1];
                for (int x = 0; x < ClientQuestFile.INSTANCE.chapters.size(); ++x) {
                    Chapter c = (Chapter)ClientQuestFile.INSTANCE.chapters.get(x);
                    cells[x * 2][0] = c.getUnformattedTitle();
                    for (int y = 0; y < c.quests.size(); ++y) {
                        Quest q = c.quests.get(y);
                        cells[x * 2][y + 1] = q.getUnformattedTitle();
                    }
                }
                Calendar time = Calendar.getInstance();
                StringBuilder fileName = new StringBuilder("local/ftbquests/saved/");
                this.appendNum(fileName, time.get(1), '-');
                this.appendNum(fileName, time.get(2) + 1, '-');
                this.appendNum(fileName, time.get(5), '-');
                this.appendNum(fileName, time.get(11), '-');
                this.appendNum(fileName, time.get(12), '-');
                this.appendNum(fileName, time.get(13), '\u0000');
                fileName.append(".csv");
                File file = new File(Minecraft.func_71410_x().field_71412_D, fileName.toString());
                ArrayList<String> csv = new ArrayList<String>();
                for (int y = 0; y < maxQuests + 1; ++y) {
                    StringBuilder builder = new StringBuilder();
                    for (int x = 0; x < ClientQuestFile.INSTANCE.chapters.size() * 2; ++x) {
                        if (x > 0) {
                            builder.append(',');
                        }
                        builder.append('\"');
                        builder.append(cells[x][y] == null ? "" : cells[x][y]);
                        builder.append('\"');
                    }
                    csv.add(builder.toString());
                }
                FileUtils.saveSafe((File)file, csv);
                Minecraft.func_71410_x().field_71439_g.func_145747_a((ITextComponent)new TextComponentTranslation("ftbquests.gui.saved_as_file", new Object[]{fileName.toString()}));
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }));
        contextMenu.add(new ContextMenuItem(I18n.func_135052_a((String)"ftbquests.gui.reload_theme", (Object[])new Object[0]), (Icon)ThemeProperties.RELOAD_ICON.get(), () -> {
            Minecraft mc = Minecraft.func_71410_x();
            mc.func_110434_K().func_110549_a(mc.func_110442_L());
            ThemeLoader.loadTheme(mc.func_110442_L());
            ClientQuestFile.INSTANCE.refreshGui();
        }));
        contextMenu.add(new ContextMenuItem(I18n.func_135052_a((String)"ftbquests.gui.wiki", (Object[])new Object[0]), GuiIcons.INFO, () -> this.handleClick("https://faq.ftb.world/books/ftb-quests-112")));
        this.treeGui.openContextMenu(contextMenu);
    }

    private void appendNum(StringBuilder sb, int num, char c) {
        if (num < 10) {
            sb.append('0');
        }
        sb.append(num);
        if (c != '\u0000') {
            sb.append(c);
        }
    }
}

