/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbquests.integration.customnpcs;

import com.feed_the_beast.ftblib.lib.config.ConfigGroup;
import com.feed_the_beast.ftblib.lib.io.DataIn;
import com.feed_the_beast.ftblib.lib.io.DataOut;
import com.feed_the_beast.ftbquests.integration.customnpcs.CustomNPCsIntegration;
import com.feed_the_beast.ftbquests.quest.Quest;
import com.feed_the_beast.ftbquests.quest.reward.Reward;
import com.feed_the_beast.ftbquests.quest.reward.RewardType;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import noppes.npcs.controllers.data.PlayerData;

public class NPCFactionReward
extends Reward {
    public int npcFaction = 0;
    public int points = 1;
    public boolean add = true;

    public NPCFactionReward(Quest quest) {
        super(quest);
    }

    @Override
    public RewardType getType() {
        return CustomNPCsIntegration.FACTION_REWARD;
    }

    @Override
    public void writeData(NBTTagCompound nbt) {
        super.writeData(nbt);
        nbt.func_74768_a("npc_faction", this.npcFaction);
        nbt.func_74768_a("points", this.points);
        nbt.func_74757_a("add", this.add);
    }

    @Override
    public void readData(NBTTagCompound nbt) {
        super.readData(nbt);
        this.npcFaction = nbt.func_74762_e("npc_faction");
        this.points = nbt.func_74762_e("required_points");
        this.add = nbt.func_74767_n("add");
    }

    @Override
    public void writeNetData(DataOut data) {
        super.writeNetData(data);
        data.writeVarInt(this.npcFaction);
        data.writeVarInt(this.points);
        data.writeBoolean(this.add);
    }

    @Override
    public void readNetData(DataIn data) {
        super.readNetData(data);
        this.npcFaction = data.readVarInt();
        this.points = data.readVarInt();
        this.add = data.readBoolean();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void getConfig(ConfigGroup config) {
        super.getConfig(config);
        config.addInt("id", () -> this.npcFaction, v -> {
            this.npcFaction = v;
        }, 0, 0, Integer.MAX_VALUE);
        config.addInt("points", () -> this.points, v -> {
            this.points = v;
        }, 1, 0, Integer.MAX_VALUE);
        config.addBool("add", () -> this.add, v -> {
            this.add = v;
        }, true);
    }

    @Override
    public void claim(EntityPlayerMP player, boolean notify) {
        PlayerData data = PlayerData.get((EntityPlayer)player);
        if (data != null && data.factionData.factionData.containsKey(this.npcFaction)) {
            if (this.add) {
                data.factionData.increasePoints((EntityPlayer)player, this.npcFaction, this.points);
            } else {
                data.factionData.factionData.put(this.npcFaction, this.points);
            }
        }
    }
}

