/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbquests.integration.customnpcs;

import com.feed_the_beast.ftblib.lib.config.ConfigGroup;
import com.feed_the_beast.ftblib.lib.io.DataIn;
import com.feed_the_beast.ftblib.lib.io.DataOut;
import com.feed_the_beast.ftbquests.integration.customnpcs.CustomNPCsIntegration;
import com.feed_the_beast.ftbquests.quest.reward.Reward;
import com.feed_the_beast.ftbquests.quest.reward.RewardType;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import noppes.npcs.controllers.PlayerQuestController;
import noppes.npcs.controllers.data.PlayerData;
import noppes.npcs.controllers.data.Quest;
import noppes.npcs.controllers.data.QuestData;

public class NPCQuestReward
extends Reward {
    public int npcQuest = 0;

    public NPCQuestReward(com.feed_the_beast.ftbquests.quest.Quest quest) {
        super(quest);
    }

    @Override
    public RewardType getType() {
        return CustomNPCsIntegration.QUEST_REWARD;
    }

    @Override
    public void writeData(NBTTagCompound nbt) {
        super.writeData(nbt);
        nbt.func_74768_a("npc_quest", this.npcQuest);
    }

    @Override
    public void readData(NBTTagCompound nbt) {
        super.readData(nbt);
        this.npcQuest = nbt.func_74762_e("npc_quest");
    }

    @Override
    public void writeNetData(DataOut data) {
        super.writeNetData(data);
        data.writeVarInt(this.npcQuest);
    }

    @Override
    public void readNetData(DataIn data) {
        super.readNetData(data);
        this.npcQuest = data.readVarInt();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void getConfig(ConfigGroup config) {
        super.getConfig(config);
        config.addInt("id", () -> this.npcQuest, v -> {
            this.npcQuest = v;
        }, 0, 0, Integer.MAX_VALUE);
    }

    @Override
    public void claim(EntityPlayerMP player, boolean notify) {
        QuestData qd;
        PlayerData data = PlayerData.get((EntityPlayer)player);
        QuestData questData = qd = data == null ? null : (QuestData)data.questData.activeQuests.get(this.npcQuest);
        if (qd != null) {
            PlayerQuestController.setQuestFinished((Quest)qd.quest, (EntityPlayer)player);
        }
    }
}

