/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbquests.net;

import com.feed_the_beast.ftblib.lib.data.ForgeTeam;
import com.feed_the_beast.ftblib.lib.io.DataIn;
import com.feed_the_beast.ftblib.lib.io.DataOut;
import com.feed_the_beast.ftblib.lib.net.MessageToClient;
import com.feed_the_beast.ftblib.lib.net.NetworkWrapper;
import com.feed_the_beast.ftbquests.client.ClientQuestData;
import com.feed_the_beast.ftbquests.client.ClientQuestFile;
import com.feed_the_beast.ftbquests.net.FTBQuestsNetHandler;
import com.feed_the_beast.ftbquests.quest.Chapter;
import com.feed_the_beast.ftbquests.quest.Quest;
import com.feed_the_beast.ftbquests.quest.task.Task;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class MessageCreateTeamData
extends MessageToClient {
    private short uid;
    private String id;
    private ITextComponent name;

    public MessageCreateTeamData() {
    }

    public MessageCreateTeamData(ForgeTeam team) {
        this.uid = team.getUID();
        this.id = team.getId();
        this.name = team.getTitle();
    }

    public NetworkWrapper getWrapper() {
        return FTBQuestsNetHandler.GENERAL;
    }

    public void writeData(DataOut data) {
        data.writeShort((int)this.uid);
        data.writeString(this.id);
        data.writeTextComponent(this.name);
    }

    public void readData(DataIn data) {
        this.uid = data.readShort();
        this.id = data.readString();
        this.name = data.readTextComponent();
    }

    @SideOnly(value=Side.CLIENT)
    public void onMessage() {
        if (ClientQuestFile.exists()) {
            ClientQuestData data = new ClientQuestData(this.uid, this.id, this.name);
            for (Chapter chapter : ClientQuestFile.INSTANCE.chapters) {
                for (Quest quest : chapter.quests) {
                    for (Task task : quest.tasks) {
                        data.createTaskData(task);
                    }
                }
            }
            ClientQuestFile.INSTANCE.addData(data);
        }
    }
}

