/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbquests.quest;

import com.feed_the_beast.ftblib.lib.client.ClientUtils;
import com.feed_the_beast.ftblib.lib.config.ConfigGroup;
import com.feed_the_beast.ftblib.lib.config.ConfigString;
import com.feed_the_beast.ftblib.lib.config.ConfigValue;
import com.feed_the_beast.ftblib.lib.config.EnumTristate;
import com.feed_the_beast.ftblib.lib.icon.Icon;
import com.feed_the_beast.ftblib.lib.icon.IconAnimation;
import com.feed_the_beast.ftblib.lib.io.Bits;
import com.feed_the_beast.ftblib.lib.io.DataIn;
import com.feed_the_beast.ftblib.lib.io.DataOut;
import com.feed_the_beast.ftblib.lib.util.ListUtils;
import com.feed_the_beast.ftblib.lib.util.StringUtils;
import com.feed_the_beast.ftbquests.FTBQuests;
import com.feed_the_beast.ftbquests.client.FTBQuestsClient;
import com.feed_the_beast.ftbquests.events.ObjectCompletedEvent;
import com.feed_the_beast.ftbquests.gui.tree.GuiQuestTree;
import com.feed_the_beast.ftbquests.integration.jei.FTBQuestsJEIHelper;
import com.feed_the_beast.ftbquests.net.MessageDisplayCompletionToast;
import com.feed_the_beast.ftbquests.net.edit.MessageMoveQuest;
import com.feed_the_beast.ftbquests.quest.ChangeProgress;
import com.feed_the_beast.ftbquests.quest.Chapter;
import com.feed_the_beast.ftbquests.quest.DependencyRequirement;
import com.feed_the_beast.ftbquests.quest.Movable;
import com.feed_the_beast.ftbquests.quest.QuestData;
import com.feed_the_beast.ftbquests.quest.QuestFile;
import com.feed_the_beast.ftbquests.quest.QuestObject;
import com.feed_the_beast.ftbquests.quest.QuestObjectBase;
import com.feed_the_beast.ftbquests.quest.QuestObjectType;
import com.feed_the_beast.ftbquests.quest.QuestShape;
import com.feed_the_beast.ftbquests.quest.ServerQuestFile;
import com.feed_the_beast.ftbquests.quest.reward.Reward;
import com.feed_the_beast.ftbquests.quest.task.Task;
import com.feed_the_beast.ftbquests.util.ConfigQuestObject;
import it.unimi.dsi.fastutil.ints.Int2ByteOpenHashMap;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.function.Predicate;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagIntArray;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public final class Quest
extends QuestObject
implements Movable {
    public Chapter chapter;
    public String subtitle;
    public double x;
    public double y;
    public boolean hide;
    public String shape;
    public final List<String> description;
    public final Set<QuestObject> dependencies;
    public boolean canRepeat;
    public final List<Task> tasks;
    public final List<Reward> rewards;
    public DependencyRequirement dependencyRequirement;
    public String guidePage;
    public String customClick;
    public boolean hideDependencyLines;
    public int minRequiredDependencies;
    public boolean hideTextUntilComplete;
    public EnumTristate disableJEI;
    public double size;
    public boolean optional;
    public int minWidth;
    private String cachedDescription = null;
    private String[] cachedText = null;

    public Quest(Chapter c) {
        this.chapter = c;
        this.subtitle = "";
        this.x = 0.0;
        this.y = 0.0;
        this.shape = "";
        this.description = new ArrayList<String>();
        this.canRepeat = false;
        this.dependencies = new HashSet<QuestObject>(0);
        this.tasks = new ArrayList<Task>(1);
        this.rewards = new ArrayList<Reward>(1);
        this.guidePage = "";
        this.customClick = "";
        this.hideDependencyLines = false;
        this.hide = false;
        this.dependencyRequirement = DependencyRequirement.ALL_COMPLETED;
        this.minRequiredDependencies = 0;
        this.hideTextUntilComplete = false;
        this.disableJEI = EnumTristate.DEFAULT;
        this.size = 1.0;
        this.optional = false;
        this.minWidth = 0;
    }

    @Override
    public QuestObjectType getObjectType() {
        return QuestObjectType.QUEST;
    }

    @Override
    public QuestFile getQuestFile() {
        return this.chapter.file;
    }

    @Override
    public Chapter getQuestChapter() {
        return this.chapter;
    }

    @Override
    public int getParentID() {
        return this.chapter.id;
    }

    @Override
    public void writeData(NBTTagCompound nbt) {
        super.writeData(nbt);
        nbt.func_74780_a("x", this.x);
        nbt.func_74780_a("y", this.y);
        if (!this.shape.isEmpty()) {
            nbt.func_74778_a("shape", this.shape);
        }
        if (!this.subtitle.isEmpty()) {
            nbt.func_74778_a("description", this.subtitle);
        }
        if (!this.description.isEmpty()) {
            NBTTagList array = new NBTTagList();
            for (String value : this.description) {
                array.func_74742_a((NBTBase)new NBTTagString(value));
            }
            nbt.func_74782_a("text", (NBTBase)array);
        }
        if (this.canRepeat) {
            nbt.func_74757_a("can_repeat", true);
        }
        if (!this.guidePage.isEmpty()) {
            nbt.func_74778_a("guide_page", this.guidePage);
        }
        if (!this.customClick.isEmpty()) {
            nbt.func_74778_a("custom_click", this.customClick);
        }
        if (this.hideDependencyLines) {
            nbt.func_74757_a("hide_dependency_lines", true);
        }
        if (this.minRequiredDependencies > 0) {
            nbt.func_74768_a("min_required_dependencies", (int)((byte)this.minRequiredDependencies));
        }
        this.removeInvalidDependencies();
        if (!this.dependencies.isEmpty()) {
            NBTTagList list = new NBTTagList();
            for (QuestObject dep : this.dependencies) {
                list.func_74742_a((NBTBase)new NBTTagString(dep.getCodeString()));
            }
            nbt.func_74782_a("dependencies", (NBTBase)list);
        }
        if (this.hide) {
            nbt.func_74757_a("hide", true);
        }
        if (this.dependencyRequirement != DependencyRequirement.ALL_COMPLETED) {
            nbt.func_74778_a("dependency_requirement", this.dependencyRequirement.getId());
        }
        if (this.hideTextUntilComplete) {
            nbt.func_74757_a("hide_text_until_complete", true);
        }
        if (this.size != 1.0) {
            nbt.func_74780_a("size", this.size);
        }
        if (this.optional) {
            nbt.func_74757_a("optional", true);
        }
        if (this.minWidth > 0) {
            nbt.func_74768_a("min_width", this.minWidth);
        }
    }

    @Override
    public void readData(NBTTagCompound nbt) {
        super.readData(nbt);
        this.subtitle = nbt.func_74779_i("description");
        this.x = nbt.func_74769_h("x");
        this.y = nbt.func_74769_h("y");
        this.shape = nbt.func_74779_i("shape");
        if (this.shape.equals("default")) {
            this.shape = "";
        }
        this.description.clear();
        NBTTagList list = nbt.func_150295_c("text", 8);
        for (int k = 0; k < list.func_74745_c(); ++k) {
            this.description.add(list.func_150307_f(k));
        }
        this.canRepeat = nbt.func_74767_n("can_repeat");
        this.guidePage = nbt.func_74779_i("guide_page");
        this.customClick = nbt.func_74779_i("custom_click");
        this.hideDependencyLines = nbt.func_74767_n("hide_dependency_lines");
        this.minRequiredDependencies = nbt.func_74762_e("min_required_dependencies");
        this.dependencies.clear();
        NBTBase depsTag = nbt.func_74781_a("dependencies");
        if (depsTag instanceof NBTTagIntArray) {
            for (int i : nbt.func_74759_k("dependencies")) {
                QuestObject object = this.chapter.file.get(i);
                if (object == null) continue;
                this.dependencies.add(object);
            }
        } else if (depsTag instanceof NBTTagList) {
            list = (NBTTagList)depsTag;
            for (int i = 0; i < list.func_74745_c(); ++i) {
                NBTTagCompound nbt1;
                QuestObject object;
                if (list.func_179238_g(i) instanceof NBTTagString) {
                    QuestObject object2 = this.chapter.file.get(this.chapter.file.getID(list.func_150307_f(i)));
                    if (object2 == null) continue;
                    this.dependencies.add(object2);
                    continue;
                }
                if (!(list.func_179238_g(i) instanceof NBTTagCompound) || (object = this.chapter.file.get((nbt1 = list.func_150305_b(i)).func_74762_e("id"))) == null) continue;
                this.dependencies.add(object);
            }
        } else {
            QuestObject object = this.chapter.file.get(nbt.func_74762_e("dependency"));
            if (object != null) {
                this.dependencies.add(object);
            }
        }
        this.hide = nbt.func_74767_n("hide");
        this.dependencyRequirement = (DependencyRequirement)((Object)DependencyRequirement.NAME_MAP.get(nbt.func_74779_i("dependency_requirement")));
        this.hideTextUntilComplete = nbt.func_74767_n("hide_text_until_complete");
        this.size = nbt.func_74764_b("size") ? nbt.func_74769_h("size") : 1.0;
        this.optional = nbt.func_74767_n("optional");
        this.minWidth = nbt.func_74762_e("min_width");
    }

    @Override
    public void writeNetData(DataOut data) {
        super.writeNetData(data);
        int flags = 0;
        flags = Bits.setFlag((int)flags, (int)1, (boolean)this.canRepeat);
        flags = Bits.setFlag((int)flags, (int)2, (boolean)this.hide);
        flags = Bits.setFlag((int)flags, (int)4, (!this.guidePage.isEmpty() ? 1 : 0) != 0);
        flags = Bits.setFlag((int)flags, (int)8, (!this.subtitle.isEmpty() ? 1 : 0) != 0);
        flags = Bits.setFlag((int)flags, (int)16, (!this.description.isEmpty() ? 1 : 0) != 0);
        flags = Bits.setFlag((int)flags, (int)32, (!this.customClick.isEmpty() ? 1 : 0) != 0);
        flags = Bits.setFlag((int)flags, (int)64, (boolean)this.hideDependencyLines);
        flags = Bits.setFlag((int)flags, (int)128, (boolean)this.hideTextUntilComplete);
        flags = Bits.setFlag((int)flags, (int)256, (boolean)this.optional);
        flags = Bits.setFlag((int)flags, (int)512, (this.minWidth > 0 ? 1 : 0) != 0);
        data.writeVarInt(flags);
        if (!this.subtitle.isEmpty()) {
            data.writeString(this.subtitle);
        }
        data.writeDouble(this.x);
        data.writeDouble(this.y);
        data.writeString(this.shape);
        if (!this.description.isEmpty()) {
            data.writeCollection(this.description, DataOut.STRING);
        }
        if (!this.guidePage.isEmpty()) {
            data.writeString(this.guidePage);
        }
        if (!this.customClick.isEmpty()) {
            data.writeString(this.customClick);
        }
        data.writeVarInt(this.minRequiredDependencies);
        DependencyRequirement.NAME_MAP.write(data, (Object)this.dependencyRequirement);
        data.writeVarInt(this.dependencies.size());
        for (QuestObject d : this.dependencies) {
            if (d.invalid) {
                data.writeInt(0);
                continue;
            }
            data.writeInt(d.id);
        }
        data.writeDouble(this.size);
        if (this.minWidth > 0) {
            data.writeVarInt(this.minWidth);
        }
    }

    @Override
    public void readNetData(DataIn data) {
        super.readNetData(data);
        int flags = data.readVarInt();
        this.subtitle = Bits.getFlag((int)flags, (int)8) ? data.readString() : "";
        this.x = data.readDouble();
        this.y = data.readDouble();
        this.shape = data.readString();
        if (Bits.getFlag((int)flags, (int)16)) {
            data.readCollection(this.description, DataIn.STRING);
        } else {
            this.description.clear();
        }
        this.canRepeat = Bits.getFlag((int)flags, (int)1);
        this.hide = Bits.getFlag((int)flags, (int)2);
        this.guidePage = Bits.getFlag((int)flags, (int)4) ? data.readString() : "";
        this.customClick = Bits.getFlag((int)flags, (int)32) ? data.readString() : "";
        this.hideDependencyLines = Bits.getFlag((int)flags, (int)64);
        this.hideTextUntilComplete = Bits.getFlag((int)flags, (int)128);
        this.optional = Bits.getFlag((int)flags, (int)256);
        this.minRequiredDependencies = data.readVarInt();
        this.dependencyRequirement = (DependencyRequirement)((Object)DependencyRequirement.NAME_MAP.read(data));
        this.dependencies.clear();
        int d = data.readVarInt();
        for (int i = 0; i < d; ++i) {
            QuestObject object = this.chapter.file.get(data.readInt());
            if (object == null) continue;
            this.dependencies.add(object);
        }
        this.size = data.readDouble();
        this.minWidth = Bits.getFlag((int)flags, (int)512) ? data.readVarInt() : 0;
    }

    @Override
    public int getRelativeProgressFromChildren(QuestData data) {
        if (this.tasks.isEmpty()) {
            return this.areDependenciesComplete(data) ? 100 : 0;
        }
        int progress = 0;
        for (Task task : this.tasks) {
            progress += task.getRelativeProgress(data);
        }
        if (progress > 0 && !this.areDependenciesComplete(data)) {
            return 0;
        }
        return Quest.getRelativeProgressFromChildren(progress, this.tasks.size());
    }

    public boolean areDependenciesComplete(QuestData data) {
        byte b;
        if (this.dependencies.isEmpty()) {
            return true;
        }
        if (data.areDependenciesCompleteCache == null) {
            data.areDependenciesCompleteCache = new Int2ByteOpenHashMap();
            data.areDependenciesCompleteCache.defaultReturnValue((byte)-1);
        }
        if ((b = data.areDependenciesCompleteCache.get(this.id)) == -1) {
            b = this.areDependenciesComplete0(data) ? (byte)1 : 0;
            data.areDependenciesCompleteCache.put(this.id, b);
        }
        return b == 1;
    }

    private boolean areDependenciesComplete0(QuestData data) {
        if (this.minRequiredDependencies > 0) {
            int complete = 0;
            for (QuestObject dependency : this.dependencies) {
                if (dependency.invalid || !dependency.isComplete(data) || ++complete < this.minRequiredDependencies) continue;
                return true;
            }
            return false;
        }
        if (this.dependencyRequirement.one) {
            for (QuestObject object : this.dependencies) {
                if (object.invalid || !(this.dependencyRequirement.completed ? object.isComplete(data) : object.isStarted(data))) continue;
                return true;
            }
            return false;
        }
        for (QuestObject object : this.dependencies) {
            if (object.invalid || !(this.dependencyRequirement.completed ? !object.isComplete(data) : !object.isStarted(data))) continue;
            return false;
        }
        return true;
    }

    public boolean canStartTasks(QuestData data) {
        return this.areDependenciesComplete(data);
    }

    @Override
    public void onCompleted(QuestData data, List<EntityPlayerMP> onlineMembers, List<EntityPlayerMP> notifiedPlayers) {
        super.onCompleted(data, onlineMembers, notifiedPlayers);
        if (!this.disableToast) {
            for (EntityPlayerMP player : notifiedPlayers) {
                new MessageDisplayCompletionToast(this.id).sendTo(player);
            }
        }
        data.checkAutoCompletion(this);
        new ObjectCompletedEvent.QuestEvent(data, this, onlineMembers, notifiedPlayers).post();
        for (Chapter chapter : this.chapter.file.chapters) {
            for (Quest quest : chapter.quests) {
                if (!quest.dependencies.contains(this)) continue;
                data.checkAutoCompletion(quest);
            }
        }
        if (this.chapter.isComplete(data)) {
            this.chapter.onCompleted(data, onlineMembers, notifiedPlayers);
        }
    }

    @Override
    public void changeProgress(QuestData data, ChangeProgress type) {
        if (type.dependencies) {
            for (QuestObject dependency : this.dependencies) {
                if (dependency.invalid) continue;
                dependency.changeProgress(data, type);
            }
        }
        for (Task task : this.tasks) {
            task.changeProgress(data, type);
        }
        if (type.reset) {
            data.unclaimRewards(this.rewards);
        }
    }

    @Override
    public Icon getAltIcon() {
        ArrayList<Icon> list = new ArrayList<Icon>();
        for (Task task : this.tasks) {
            list.add(task.getIcon());
        }
        return IconAnimation.fromList(list, (boolean)false);
    }

    @Override
    public String getAltTitle() {
        if (!this.tasks.isEmpty()) {
            return this.tasks.get(0).getTitle();
        }
        return I18n.func_135052_a((String)"ftbquests.unnamed", (Object[])new Object[0]);
    }

    @Override
    public void deleteSelf() {
        super.deleteSelf();
        this.chapter.quests.remove(this);
    }

    @Override
    public void deleteChildren() {
        for (Task task : this.tasks) {
            task.deleteChildren();
            task.invalid = true;
        }
        for (Reward reward : this.rewards) {
            reward.deleteChildren();
            reward.invalid = true;
        }
        this.tasks.clear();
        this.rewards.clear();
    }

    @Override
    public void onCreated() {
        this.chapter.quests.add(this);
        if (!this.tasks.isEmpty()) {
            for (Task task : ListUtils.clearAndCopy(this.tasks)) {
                task.onCreated();
            }
        }
    }

    @Override
    public File getFile() {
        return new File(this.chapter.file.getFolder(), "chapters/" + Quest.getCodeString(this.chapter) + "/" + Quest.getCodeString(this) + ".snbt");
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void getConfig(ConfigGroup config) {
        super.getConfig(config);
        config.addString("subtitle", () -> this.subtitle, v -> {
            this.subtitle = v;
        }, "");
        config.addList("description", this.description, (ConfigValue)new ConfigString(""), ConfigString::new, ConfigString::getString);
        config.addEnum("shape", () -> this.shape.isEmpty() ? "default" : this.shape, v -> {
            this.shape = v.equals("default") ? "" : v;
        }, QuestShape.idMapWithDefault);
        config.addBool("hide", () -> this.hide, v -> {
            this.hide = v;
        }, false);
        config.addBool("can_repeat", () -> this.canRepeat, v -> {
            this.canRepeat = v;
        }, false);
        config.addDouble("size", () -> this.size, v -> {
            this.size = v;
        }, 1.0, 0.0625, 8.0);
        config.addDouble("x", () -> this.x, v -> {
            this.x = v;
        }, 0.0, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY);
        config.addDouble("y", () -> this.y, v -> {
            this.y = v;
        }, 0.0, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY);
        config.addBool("optional", () -> this.optional, v -> {
            this.optional = v;
        }, false);
        config.addInt("min_width", () -> this.minWidth, v -> {
            this.minWidth = v;
        }, 0, 0, 3000);
        Predicate<QuestObjectBase> depTypes = object -> object != this.chapter.file && object != this.chapter && object instanceof QuestObject;
        config.addList("dependencies", this.dependencies, (ConfigValue)new ConfigQuestObject(this.chapter.file, 0, depTypes), questObject -> new ConfigQuestObject(this.chapter.file, questObject.id, depTypes), configQuestObject -> this.chapter.file.get(configQuestObject.getObject())).setDisplayName((ITextComponent)new TextComponentTranslation("ftbquests.dependencies", new Object[0]));
        config.addEnum("dependency_requirement", () -> this.dependencyRequirement, v -> {
            this.dependencyRequirement = v;
        }, DependencyRequirement.NAME_MAP);
        config.addInt("min_required_dependencies", () -> this.minRequiredDependencies, v -> {
            this.minRequiredDependencies = v;
        }, 0, 0, Integer.MAX_VALUE);
        config.addBool("hide_dependency_lines", () -> this.hideDependencyLines, v -> {
            this.hideDependencyLines = v;
        }, false);
        config.addString("guide_page", () -> this.guidePage, v -> {
            this.guidePage = v;
        }, "");
        config.addString("custom_click", () -> this.customClick, v -> {
            this.customClick = v;
        }, "");
        config.addBool("hide_text_until_complete", () -> this.hideTextUntilComplete, v -> {
            this.hideTextUntilComplete = v;
        }, false);
        config.addEnum("disable_jei", () -> this.disableJEI, v -> {
            this.disableJEI = v;
        }, EnumTristate.NAME_MAP);
    }

    @Override
    public Chapter getChapter() {
        return this.chapter;
    }

    @Override
    public double getX() {
        return this.x;
    }

    @Override
    public double getY() {
        return this.y;
    }

    @Override
    public double getWidth() {
        return this.size;
    }

    @Override
    public double getHeight() {
        return this.size;
    }

    @Override
    public String getShape() {
        return this.shape.isEmpty() ? this.chapter.getDefaultQuestShape() : this.shape;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void move(Chapter to, double x, double y) {
        new MessageMoveQuest(this.id, to.id, x, y).sendToServer();
    }

    public boolean isProgressionIgnored() {
        return this.canRepeat || this.optional || !this.customClick.isEmpty();
    }

    @Override
    public boolean isVisible(QuestData data) {
        if (this.dependencies.isEmpty()) {
            return true;
        }
        if (this.hide) {
            return this.areDependenciesComplete(data);
        }
        for (QuestObject object : this.dependencies) {
            if (!object.isVisible(data)) continue;
            return true;
        }
        return false;
    }

    public Task getTask(int index) {
        if (this.tasks.isEmpty()) {
            throw new IllegalStateException("Quest has no tasks!");
        }
        if (index <= 0) {
            return this.tasks.get(0);
        }
        if (index >= this.tasks.size()) {
            return this.tasks.get(this.tasks.size() - 1);
        }
        return this.tasks.get(index);
    }

    @Override
    public void clearCachedData() {
        super.clearCachedData();
        this.cachedDescription = null;
        this.cachedText = null;
        for (Task task : this.tasks) {
            task.clearCachedData();
        }
        for (Reward reward : this.rewards) {
            reward.clearCachedData();
        }
    }

    public String getSubtitle() {
        if (this.cachedDescription != null) {
            return this.cachedDescription;
        }
        String textDesc = this.loadText().getString("description");
        if (!textDesc.isEmpty()) {
            this.cachedDescription = textDesc;
            return this.cachedDescription;
        }
        String key = String.format("quests.%08x.description", this.id);
        String t = FTBQuestsClient.addI18nAndColors(I18n.func_135052_a((String)key, (Object[])new Object[0]));
        this.cachedDescription = t.isEmpty() || key.equals(t) ? FTBQuestsClient.addI18nAndColors(this.subtitle) : t;
        return this.cachedDescription;
    }

    public String[] getDescription() {
        if (this.cachedText != null) {
            return this.cachedText;
        }
        this.cachedText = this.loadText().getStringArray("text");
        if (this.cachedText.length > 0) {
            return this.cachedText;
        }
        if (this.description.isEmpty()) {
            return StringUtils.EMPTY_ARRAY;
        }
        this.cachedText = new String[this.description.size()];
        for (int i = 0; i < this.cachedText.length; ++i) {
            this.cachedText[i] = FTBQuestsClient.addI18nAndColors(this.description.get(i));
        }
        return this.cachedText;
    }

    public boolean hasDependency(QuestObject object) {
        if (object.invalid) {
            return false;
        }
        for (QuestObject dependency : this.dependencies) {
            if (dependency != object) continue;
            return true;
        }
        return false;
    }

    private void removeInvalidDependencies() {
        if (!this.dependencies.isEmpty()) {
            this.dependencies.removeIf(o -> o == null || o.invalid || o == this);
        }
    }

    public boolean verifyDependencies(boolean autofix) {
        try {
            if (this.verifyDependenciesInternal(this, true)) {
                return true;
            }
        }
        catch (StackOverflowError stackOverflowError) {
            // empty catch block
        }
        if (autofix) {
            FTBQuests.LOGGER.error("Looping dependencies found in " + this + "! Deleting all dependencies...");
            this.dependencies.clear();
            if (!this.chapter.file.isClient()) {
                ServerQuestFile.INSTANCE.save();
            }
        } else {
            FTBQuests.LOGGER.error("Looping dependencies found in " + this + "!");
        }
        return false;
    }

    @Override
    public boolean verifyDependenciesInternal(QuestObject original, boolean firstLoop) {
        if (this == original && !firstLoop) {
            return false;
        }
        this.removeInvalidDependencies();
        for (QuestObject dependency : this.dependencies) {
            if (dependency.verifyDependenciesInternal(original, false)) continue;
            return false;
        }
        return true;
    }

    public void checkRepeatableQuests(QuestData data, UUID player) {
        if (!this.canRepeat) {
            return;
        }
        for (Reward reward1 : this.rewards) {
            if (data.isRewardClaimed(player, reward1)) continue;
            return;
        }
        this.changeProgress(data, ChangeProgress.RESET);
    }

    @Override
    public int refreshJEI() {
        return FTBQuestsJEIHelper.QUESTS;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void editedFromGUI() {
        GuiQuestTree gui = (GuiQuestTree)((Object)ClientUtils.getCurrentGuiAs(GuiQuestTree.class));
        if (gui != null) {
            gui.questPanel.refreshWidgets();
            gui.viewQuestPanel.refreshWidgets();
        }
    }

    public boolean hasUnclaimedRewards(UUID player, QuestData data, boolean showExcluded) {
        if (this.isComplete(data)) {
            for (Reward reward : this.rewards) {
                if (!showExcluded && !reward.getExcludeFromClaimAll() || data.isRewardClaimed(player, reward)) continue;
                return true;
            }
        }
        return false;
    }

    public int getUnclaimedRewards(UUID player, QuestData data, boolean showExcluded) {
        int r = 0;
        if (this.isComplete(data)) {
            for (Reward reward : this.rewards) {
                if (!showExcluded && reward.getExcludeFromClaimAll() || data.isRewardClaimed(player, reward)) continue;
                ++r;
            }
        }
        return r;
    }

    public void moved(double nx, double ny, int nc) {
        QuestFile f;
        Chapter c;
        this.x = nx;
        this.y = ny;
        if (nc != this.chapter.id && (c = (f = this.getQuestFile()).getChapter(nc)) != null) {
            File newFile;
            File oldFile = f.isClient() ? null : this.getFile();
            this.chapter.quests.remove(this);
            c.quests.add(this);
            this.chapter = c;
            File file = newFile = f.isClient() ? null : this.getFile();
            if (oldFile != null && newFile != null && !oldFile.renameTo(newFile)) {
                FTBQuests.LOGGER.error("Couldn't rename " + oldFile.getPath() + " to " + newFile.getPath());
            }
        }
    }

    public List<QuestObject> getDependants() {
        ArrayList<QuestObject> list = new ArrayList<QuestObject>();
        for (Chapter c : this.chapter.file.chapters) {
            for (Quest q : c.quests) {
                if (!q.dependencies.contains(this)) continue;
                list.add(q);
            }
        }
        return list;
    }
}

