/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbquests.quest;

import com.feed_the_beast.ftblib.FTBLibConfig;
import com.feed_the_beast.ftblib.lib.config.ConfigGroup;
import com.feed_the_beast.ftblib.lib.config.ConfigItemStack;
import com.feed_the_beast.ftblib.lib.config.ConfigTimer;
import com.feed_the_beast.ftblib.lib.config.ConfigValue;
import com.feed_the_beast.ftblib.lib.icon.Icon;
import com.feed_the_beast.ftblib.lib.icon.IconAnimation;
import com.feed_the_beast.ftblib.lib.io.DataIn;
import com.feed_the_beast.ftblib.lib.io.DataOut;
import com.feed_the_beast.ftblib.lib.math.MathUtils;
import com.feed_the_beast.ftblib.lib.math.Ticks;
import com.feed_the_beast.ftbquests.FTBQuests;
import com.feed_the_beast.ftbquests.events.ClearFileCacheEvent;
import com.feed_the_beast.ftbquests.events.CustomTaskEvent;
import com.feed_the_beast.ftbquests.events.ObjectCompletedEvent;
import com.feed_the_beast.ftbquests.integration.jei.FTBQuestsJEIHelper;
import com.feed_the_beast.ftbquests.net.MessageDisplayCompletionToast;
import com.feed_the_beast.ftbquests.quest.ChangeProgress;
import com.feed_the_beast.ftbquests.quest.Chapter;
import com.feed_the_beast.ftbquests.quest.Quest;
import com.feed_the_beast.ftbquests.quest.QuestData;
import com.feed_the_beast.ftbquests.quest.QuestObject;
import com.feed_the_beast.ftbquests.quest.QuestObjectBase;
import com.feed_the_beast.ftbquests.quest.QuestObjectType;
import com.feed_the_beast.ftbquests.quest.QuestShape;
import com.feed_the_beast.ftbquests.quest.ServerQuestFile;
import com.feed_the_beast.ftbquests.quest.loot.EntityWeight;
import com.feed_the_beast.ftbquests.quest.loot.LootCrate;
import com.feed_the_beast.ftbquests.quest.loot.RewardTable;
import com.feed_the_beast.ftbquests.quest.reward.CustomReward;
import com.feed_the_beast.ftbquests.quest.reward.Reward;
import com.feed_the_beast.ftbquests.quest.reward.RewardAutoClaim;
import com.feed_the_beast.ftbquests.quest.reward.RewardType;
import com.feed_the_beast.ftbquests.quest.task.CustomTask;
import com.feed_the_beast.ftbquests.quest.task.Task;
import com.feed_the_beast.ftbquests.quest.task.TaskType;
import com.feed_the_beast.ftbquests.util.SNBT;
import com.feed_the_beast.ftbquests.util.SNBTTagCompound;
import com.latmod.mods.itemfilters.item.ItemMissing;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.ForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public abstract class QuestFile
extends QuestObject {
    public static final int VERSION = 9;
    public final List<Chapter> chapters;
    public final List<RewardTable> rewardTables;
    private final Int2ObjectOpenHashMap<QuestObjectBase> map;
    public final List<ItemStack> emergencyItems;
    public Ticks emergencyItemsCooldown;
    public int fileVersion;
    public boolean defaultRewardTeam;
    public boolean defaultTeamConsumeItems;
    public RewardAutoClaim defaultRewardAutoClaim;
    public String defaultQuestShape;
    public boolean defaultQuestDisableJEI;
    public boolean dropLootCrates;
    public final EntityWeight lootCrateNoDrop;
    public boolean disableGui;
    public String folderName;
    public double gridScale;

    public QuestFile() {
        this.id = 1;
        this.fileVersion = 0;
        this.chapters = new ArrayList<Chapter>();
        this.rewardTables = new ArrayList<RewardTable>();
        this.map = new Int2ObjectOpenHashMap();
        this.emergencyItems = new ArrayList<ItemStack>();
        this.emergencyItemsCooldown = Ticks.MINUTE.x(5L);
        this.defaultRewardTeam = false;
        this.defaultTeamConsumeItems = false;
        this.defaultRewardAutoClaim = RewardAutoClaim.DISABLED;
        this.defaultQuestShape = "circle";
        this.defaultQuestDisableJEI = false;
        this.dropLootCrates = false;
        this.lootCrateNoDrop = new EntityWeight();
        this.lootCrateNoDrop.passive = 4000;
        this.lootCrateNoDrop.monster = 600;
        this.lootCrateNoDrop.boss = 0;
        this.disableGui = false;
        this.folderName = "";
        this.gridScale = 0.5;
    }

    public abstract boolean isClient();

    @Override
    public QuestFile getQuestFile() {
        return this;
    }

    @Override
    public QuestObjectType getObjectType() {
        return QuestObjectType.FILE;
    }

    public boolean isLoading() {
        return false;
    }

    public boolean canEdit() {
        return false;
    }

    public File getFolder() {
        throw new IllegalStateException("This quest file doesn't have a folder!");
    }

    @Override
    public int getRelativeProgressFromChildren(QuestData data) {
        int progress = 0;
        for (Chapter chapter : this.chapters) {
            progress += chapter.getRelativeProgress(data);
        }
        return QuestFile.getRelativeProgressFromChildren(progress, this.chapters.size());
    }

    @Override
    public void onCompleted(QuestData data, List<EntityPlayerMP> onlineMembers, List<EntityPlayerMP> notifiedPlayers) {
        super.onCompleted(data, onlineMembers, notifiedPlayers);
        new ObjectCompletedEvent.FileEvent(data, this, onlineMembers, notifiedPlayers).post();
        if (!this.disableToast) {
            for (EntityPlayerMP player : notifiedPlayers) {
                new MessageDisplayCompletionToast(this.id).sendTo(player);
            }
        }
    }

    @Override
    public void changeProgress(QuestData data, ChangeProgress type) {
        for (Chapter chapter : this.chapters) {
            chapter.changeProgress(data, type);
        }
    }

    @Override
    public void deleteSelf() {
        this.invalid = true;
    }

    @Override
    public void deleteChildren() {
        for (Chapter chapter : this.chapters) {
            chapter.deleteChildren();
            chapter.invalid = true;
        }
        this.chapters.clear();
        for (RewardTable table : this.rewardTables) {
            table.deleteChildren();
            table.invalid = true;
        }
        this.rewardTables.clear();
    }

    @Nullable
    public QuestObjectBase getBase(int id) {
        if (id == 0) {
            return null;
        }
        if (id == 1) {
            return this;
        }
        QuestObjectBase object = (QuestObjectBase)this.map.get(id);
        return object == null || object.invalid ? null : object;
    }

    @Nullable
    public QuestObject get(int id) {
        QuestObjectBase object = this.getBase(id);
        return object instanceof QuestObject ? (QuestObject)object : null;
    }

    @Nullable
    public QuestObjectBase remove(int id) {
        QuestObjectBase object = (QuestObjectBase)this.map.remove(id);
        if (object != null) {
            if (object instanceof QuestObject) {
                QuestObject o = (QuestObject)object;
                for (Chapter chapter : this.chapters) {
                    for (Quest quest : chapter.quests) {
                        quest.dependencies.remove(o);
                    }
                }
            }
            object.invalid = true;
            this.refreshIDMap();
            return object;
        }
        return null;
    }

    @Nullable
    public Chapter getChapter(int id) {
        QuestObjectBase object = this.getBase(id);
        return object instanceof Chapter ? (Chapter)object : null;
    }

    @Nullable
    public Quest getQuest(int id) {
        QuestObjectBase object = this.getBase(id);
        return object instanceof Quest ? (Quest)object : null;
    }

    @Nullable
    public Task getTask(int id) {
        QuestObjectBase object = this.getBase(id);
        return object instanceof Task ? (Task)object : null;
    }

    @Nullable
    public Reward getReward(int id) {
        QuestObjectBase object = this.getBase(id);
        return object instanceof Reward ? (Reward)object : null;
    }

    @Nullable
    public RewardTable getRewardTable(int id) {
        QuestObjectBase object = this.getBase(id);
        return object instanceof RewardTable ? (RewardTable)object : null;
    }

    @Nullable
    public LootCrate getLootCrate(String id) {
        RewardTable table;
        if (!id.startsWith("#")) {
            for (RewardTable table2 : this.rewardTables) {
                if (table2.lootCrate == null || !table2.lootCrate.stringID.equals(id)) continue;
                return table2.lootCrate;
            }
        }
        return (table = this.getRewardTable(this.getID(id))) == null ? null : table.lootCrate;
    }

    @Nullable
    public RewardTable getRewardTable(String id) {
        LootCrate crate = this.getLootCrate(id);
        return crate != null ? crate.table : this.getRewardTable(this.getID(id));
    }

    public void refreshIDMap() {
        this.clearCachedData();
        this.map.clear();
        for (RewardTable table : this.rewardTables) {
            this.map.put(table.id, (Object)table);
        }
        for (Chapter chapter : this.chapters) {
            this.map.put(chapter.id, (Object)chapter);
            for (Quest quest : chapter.quests) {
                this.map.put(quest.id, (Object)quest);
                for (Task task : quest.tasks) {
                    this.map.put(task.id, (Object)task);
                }
                for (Reward reward : quest.rewards) {
                    this.map.put(reward.id, (Object)reward);
                }
            }
        }
        this.clearCachedData();
    }

    public QuestObjectBase create(QuestObjectType type, int parent, NBTTagCompound extra) {
        switch (type) {
            case CHAPTER: {
                return new Chapter(this);
            }
            case QUEST: {
                Chapter chapter = this.getChapter(parent);
                if (chapter != null) {
                    return new Quest(chapter);
                }
                throw new IllegalArgumentException("Parent chapter not found!");
            }
            case TASK: {
                Quest quest = this.getQuest(parent);
                if (quest != null) {
                    Task task = TaskType.createTask(quest, extra.func_74779_i("type"));
                    if (task != null) {
                        return task;
                    }
                    throw new IllegalArgumentException("Unknown task type!");
                }
                throw new IllegalArgumentException("Parent quest not found!");
            }
            case REWARD: {
                Quest quest = this.getQuest(parent);
                if (quest != null) {
                    Reward reward = RewardType.createReward(quest, extra.func_74779_i("type"));
                    if (reward != null) {
                        return reward;
                    }
                    throw new IllegalArgumentException("Unknown reward type!");
                }
                throw new IllegalArgumentException("Parent quest not found!");
            }
            case REWARD_TABLE: {
                return new RewardTable(this);
            }
        }
        throw new IllegalArgumentException("Unknown type: " + type);
    }

    @Override
    public final void writeData(NBTTagCompound nbt) {
        nbt.func_74768_a("version", 9);
        super.writeData(nbt);
        nbt.func_74757_a("default_reward_team", this.defaultRewardTeam);
        nbt.func_74757_a("default_consume_items", this.defaultTeamConsumeItems);
        nbt.func_74778_a("default_autoclaim_rewards", this.defaultRewardAutoClaim.getId());
        nbt.func_74778_a("default_quest_shape", this.defaultQuestShape);
        nbt.func_74757_a("default_quest_disable_jei", this.defaultQuestDisableJEI);
        if (!this.emergencyItems.isEmpty()) {
            NBTTagList list = new NBTTagList();
            for (ItemStack stack : this.emergencyItems) {
                list.func_74742_a(ItemMissing.write((ItemStack)stack, (boolean)true));
            }
            nbt.func_74782_a("emergency_items", (NBTBase)list);
        }
        nbt.func_74778_a("emergency_items_cooldown", this.emergencyItemsCooldown.toString());
        nbt.func_74757_a("drop_loot_crates", this.dropLootCrates);
        SNBTTagCompound nbt1 = new SNBTTagCompound();
        this.lootCrateNoDrop.writeData(nbt1);
        nbt.func_74782_a("loot_crate_no_drop", (NBTBase)nbt1);
        nbt.func_74757_a("disable_gui", this.disableGui);
        nbt.func_74780_a("grid_scale", this.gridScale);
    }

    @Override
    public final void readData(NBTTagCompound nbt) {
        super.readData(nbt);
        this.defaultRewardTeam = nbt.func_74767_n("default_reward_team");
        this.defaultTeamConsumeItems = nbt.func_74767_n("default_consume_items");
        this.defaultRewardAutoClaim = (RewardAutoClaim)((Object)RewardAutoClaim.NAME_MAP_NO_DEFAULT.get(nbt.func_74779_i("default_autoclaim_rewards")));
        this.defaultQuestShape = nbt.func_74779_i("default_quest_shape");
        if (this.defaultQuestShape.equals("default")) {
            this.defaultQuestShape = "";
        }
        this.defaultQuestDisableJEI = nbt.func_74767_n("default_quest_disable_jei");
        this.emergencyItems.clear();
        NBTTagList list = nbt.func_150295_c("emergency_items", 10);
        for (int i = 0; i < list.func_74745_c(); ++i) {
            ItemStack stack = ItemMissing.read((NBTBase)list.func_150305_b(i));
            if (stack.func_190926_b()) continue;
            this.emergencyItems.add(stack);
        }
        Ticks t = Ticks.get((String)nbt.func_74779_i("emergency_items_cooldown"));
        this.emergencyItemsCooldown = t.hasTicks() ? t : Ticks.MINUTE.x(5L);
        this.dropLootCrates = nbt.func_74767_n("drop_loot_crates");
        if (nbt.func_74764_b("loot_crate_no_drop")) {
            this.lootCrateNoDrop.readData(nbt.func_74775_l("loot_crate_no_drop"));
        }
        this.disableGui = nbt.func_74767_n("disable_gui");
        this.gridScale = nbt.func_74769_h("grid_scale");
        if (this.gridScale == 0.0) {
            this.gridScale = 0.5;
        }
    }

    private NBTTagCompound createIndex(Iterable<? extends QuestObjectBase> list) {
        NBTTagList index = new NBTTagList();
        for (QuestObjectBase questObjectBase : list) {
            index.func_74742_a((NBTBase)new NBTTagString(QuestFile.getCodeString(questObjectBase.id)));
        }
        SNBTTagCompound nbt = new SNBTTagCompound();
        nbt.func_74782_a("index", (NBTBase)index);
        return nbt;
    }

    public int[] readIndex(File dir, String name) {
        NBTTagCompound nbt = SNBT.readOrTransform(dir, name);
        if (nbt == null) {
            return new int[0];
        }
        int[] ai = nbt.func_74759_k("index");
        if (ai.length > 0) {
            if (this instanceof ServerQuestFile) {
                ((ServerQuestFile)this).save();
            }
            return ai;
        }
        NBTTagList list = nbt.func_150295_c("index", 8);
        ai = new int[list.func_74745_c()];
        for (int i = 0; i < ai.length; ++i) {
            ai[i] = this.getID(list.func_150307_f(i));
        }
        return ai;
    }

    public final void writeDataFull(File folder) {
        SNBTTagCompound out = new SNBTTagCompound();
        this.writeData(out);
        SNBT.write(new File(folder, "file.snbt"), out);
        SNBT.write(new File(folder, "chapters/index.snbt"), this.createIndex(this.chapters));
        SNBT.write(new File(folder, "reward_tables/index.snbt"), this.createIndex(this.rewardTables));
        for (Chapter chapter : this.chapters) {
            out = new SNBTTagCompound();
            chapter.writeData(out);
            String chapterPath = "chapters/" + QuestFile.getCodeString(chapter) + "/";
            SNBT.write(new File(folder, chapterPath + "chapter.snbt"), out);
            if (chapter.quests.isEmpty()) continue;
            for (Quest quest : chapter.quests) {
                SNBTTagCompound nbt3;
                IForgeRegistryEntry.Impl type;
                if (quest.invalid) continue;
                out = new SNBTTagCompound();
                quest.writeData(out);
                if (!quest.tasks.isEmpty()) {
                    NBTTagList t = new NBTTagList();
                    for (Task task : quest.tasks) {
                        type = task.getType();
                        nbt3 = new SNBTTagCompound();
                        nbt3.func_74778_a("uid", task.getCodeString());
                        nbt3.func_74778_a("type", type.getTypeForNBT());
                        task.writeData(nbt3);
                        t.func_74742_a((NBTBase)nbt3);
                    }
                    if (!t.func_82582_d()) {
                        out.func_74782_a("tasks", (NBTBase)t);
                    }
                }
                if (!quest.rewards.isEmpty()) {
                    NBTTagList r = new NBTTagList();
                    for (Reward reward : quest.rewards) {
                        type = reward.getType();
                        nbt3 = new SNBTTagCompound();
                        nbt3.func_74778_a("uid", reward.getCodeString());
                        nbt3.func_74778_a("type", type.getTypeForNBT());
                        reward.writeData(nbt3);
                        r.func_74742_a((NBTBase)nbt3);
                    }
                    if (!r.func_82582_d()) {
                        out.func_74782_a("rewards", (NBTBase)r);
                    }
                }
                SNBT.write(new File(folder, chapterPath + QuestFile.getCodeString(quest) + ".snbt"), out);
            }
        }
        for (RewardTable table : this.rewardTables) {
            out = new SNBTTagCompound();
            table.writeData(out);
            SNBT.write(new File(folder, "reward_tables/" + QuestFile.getCodeString(table) + ".snbt"), out);
        }
    }

    public final void readDataFull(File folder) {
        NBTTagCompound nbt = SNBT.readOrTransform(folder, "file");
        if (nbt != null) {
            this.fileVersion = nbt.func_74762_e("version");
            this.readData(nbt);
        }
        this.chapters.clear();
        this.rewardTables.clear();
        Int2ObjectOpenHashMap questFileCache = new Int2ObjectOpenHashMap();
        for (int i : this.readIndex(folder, "chapters/index")) {
            Chapter chapter = new Chapter(this);
            chapter.id = i;
            this.chapters.add(chapter);
            File[] files = new File(folder, "chapters/" + QuestFile.getCodeString(chapter)).listFiles();
            if (files == null || files.length <= 0) continue;
            for (File f : files) {
                if (f.getName().equals("chapter.snbt") || f.getName().equals("chapter.nbt")) continue;
                try {
                    Quest quest = new Quest(chapter);
                    quest.id = Long.decode("#" + f.getName().replace(".nbt", "").replace(".snbt", "")).intValue();
                    nbt = SNBT.readOrTransform(chapter.file.getFolder(), "chapters/" + QuestFile.getCodeString(chapter) + "/" + QuestFile.getCodeString(quest));
                    if (nbt == null) continue;
                    questFileCache.put(quest.id, (Object)nbt);
                    NBTTagList t = nbt.func_150295_c("tasks", 10);
                    for (int k = 0; k < t.func_74745_c(); ++k) {
                        NBTTagCompound tt = t.func_150305_b(k);
                        Task task = TaskType.createTask(quest, tt.func_74779_i("type"));
                        if (task == null) {
                            task = new CustomTask(quest);
                            task.title = "Unknown type: " + tt.func_74779_i("type");
                        }
                        task.id = tt.func_74762_e("uid");
                        if (task.id == 0) {
                            task.id = this.getID(tt.func_74779_i("uid"));
                        }
                        quest.tasks.add(task);
                    }
                    NBTTagList r = nbt.func_150295_c("rewards", 10);
                    for (int k = 0; k < r.func_74745_c(); ++k) {
                        NBTTagCompound rt = r.func_150305_b(k);
                        Reward reward = RewardType.createReward(quest, rt.func_74779_i("type"));
                        if (reward == null) {
                            reward = new CustomReward(quest);
                            reward.title = "Unknown type: " + rt.func_74779_i("type");
                        }
                        reward.id = rt.func_74762_e("uid");
                        if (reward.id == 0) {
                            reward.id = this.getID(rt.func_74779_i("uid"));
                        }
                        quest.rewards.add(reward);
                    }
                    chapter.quests.add(quest);
                }
                catch (Exception ex) {
                    FTBQuests.LOGGER.warn("Failed to read quest ID " + f.getName());
                }
            }
        }
        for (int i : this.readIndex(folder, "reward_tables/index")) {
            RewardTable table = new RewardTable(this);
            table.id = i;
            this.rewardTables.add(table);
        }
        this.refreshIDMap();
        Object object = this.chapters.iterator();
        while (object.hasNext()) {
            Chapter chapter = (Chapter)object.next();
            nbt = SNBT.readOrTransform(folder, "chapters/" + QuestFile.getCodeString(chapter) + "/chapter");
            if (nbt != null) {
                chapter.readData(nbt);
            }
            for (Quest quest : chapter.quests) {
                nbt = (NBTTagCompound)questFileCache.get(quest.id);
                if (nbt == null) continue;
                quest.readData(nbt);
                NBTTagList t = nbt.func_150295_c("tasks", 10);
                for (int k = 0; k < t.func_74745_c(); ++k) {
                    quest.tasks.get(k).readData(t.func_150305_b(k));
                }
                NBTTagList r = nbt.func_150295_c("rewards", 10);
                for (int k = 0; k < r.func_74745_c(); ++k) {
                    quest.rewards.get(k).readData(r.func_150305_b(k));
                }
            }
        }
        for (RewardTable table : this.rewardTables) {
            nbt = SNBT.readOrTransform(folder, "reward_tables/" + QuestFile.getCodeString(table));
            if (nbt == null) continue;
            table.readData(nbt);
        }
        for (Chapter chapter : this.chapters) {
            for (Quest quest : chapter.quests) {
                quest.verifyDependencies(true);
            }
        }
        for (QuestObjectBase object2 : this.getAllObjects()) {
            if (!(object2 instanceof CustomTask)) continue;
            new CustomTaskEvent((CustomTask)object2).post();
        }
    }

    @Override
    public final void writeNetData(DataOut data) {
        super.writeNetData(data);
        data.writeCollection(this.emergencyItems, DataOut.ITEM_STACK);
        data.writeVarLong(this.emergencyItemsCooldown.ticks());
        data.writeBoolean(this.defaultRewardTeam);
        data.writeBoolean(this.defaultTeamConsumeItems);
        RewardAutoClaim.NAME_MAP_NO_DEFAULT.write(data, (Object)this.defaultRewardAutoClaim);
        data.writeString(this.defaultQuestShape);
        data.writeBoolean(this.defaultQuestDisableJEI);
        data.writeBoolean(this.dropLootCrates);
        this.lootCrateNoDrop.writeNetData(data);
        data.writeBoolean(this.disableGui);
        data.writeString(this.folderName);
        data.writeDouble(this.gridScale);
    }

    @Override
    public final void readNetData(DataIn data) {
        super.readNetData(data);
        data.readCollection(this.emergencyItems, DataIn.ITEM_STACK);
        this.emergencyItemsCooldown = Ticks.get((long)data.readVarLong());
        this.defaultRewardTeam = data.readBoolean();
        this.defaultTeamConsumeItems = data.readBoolean();
        this.defaultRewardAutoClaim = (RewardAutoClaim)((Object)RewardAutoClaim.NAME_MAP_NO_DEFAULT.read(data));
        this.defaultQuestShape = data.readString();
        this.defaultQuestDisableJEI = data.readBoolean();
        this.dropLootCrates = data.readBoolean();
        this.lootCrateNoDrop.readNetData(data);
        this.disableGui = data.readBoolean();
        this.folderName = data.readString();
        this.gridScale = data.readDouble();
    }

    public final void writeNetDataFull(DataOut data) {
        int pos = data.getPosition();
        this.writeNetData(data);
        data.writeVarInt(this.rewardTables.size());
        for (RewardTable table : this.rewardTables) {
            data.writeInt(table.id);
        }
        data.writeVarInt(this.chapters.size());
        ForgeRegistry<TaskType> taskTypes = TaskType.getRegistry();
        ForgeRegistry<RewardType> rewardTypes = RewardType.getRegistry();
        for (Chapter chapter : this.chapters) {
            data.writeInt(chapter.id);
            data.writeVarInt(chapter.quests.size());
            for (Quest quest : chapter.quests) {
                data.writeInt(quest.id);
                data.writeVarInt(quest.tasks.size());
                for (Task task : quest.tasks) {
                    data.writeVarInt(taskTypes.getID((IForgeRegistryEntry)task.getType()));
                    data.writeInt(task.id);
                }
                data.writeVarInt(quest.rewards.size());
                for (Reward reward : quest.rewards) {
                    data.writeVarInt(rewardTypes.getID((IForgeRegistryEntry)reward.getType()));
                    data.writeInt(reward.id);
                }
            }
        }
        for (RewardTable table : this.rewardTables) {
            table.writeNetData(data);
        }
        for (Chapter chapter : this.chapters) {
            chapter.writeNetData(data);
            for (Quest quest : chapter.quests) {
                quest.writeNetData(data);
                for (Task task : quest.tasks) {
                    task.writeNetData(data);
                }
                for (Reward reward : quest.rewards) {
                    reward.writeNetData(data);
                }
            }
        }
        if (FTBLibConfig.debugging.print_more_info) {
            FTBQuests.LOGGER.info("Wrote " + (data.getPosition() - pos) + " bytes");
        }
    }

    public final void readNetDataFull(DataIn data) {
        int pos = data.getPosition();
        this.readNetData(data);
        this.chapters.clear();
        this.rewardTables.clear();
        int rtl = data.readVarInt();
        for (int i = 0; i < rtl; ++i) {
            RewardTable table = new RewardTable(this);
            table.id = data.readInt();
            this.rewardTables.add(table);
        }
        ForgeRegistry<TaskType> taskTypes = TaskType.getRegistry();
        ForgeRegistry<RewardType> rewardTypes = RewardType.getRegistry();
        int c = data.readVarInt();
        for (int i = 0; i < c; ++i) {
            Chapter chapter = new Chapter(this);
            chapter.id = data.readInt();
            this.chapters.add(chapter);
            int q = data.readVarInt();
            for (int j = 0; j < q; ++j) {
                Quest quest = new Quest(chapter);
                quest.id = data.readInt();
                chapter.quests.add(quest);
                int t = data.readVarInt();
                for (int k = 0; k < t; ++k) {
                    TaskType type = (TaskType)taskTypes.getValue(data.readVarInt());
                    Task task = type.provider.create(quest);
                    task.id = data.readInt();
                    quest.tasks.add(task);
                }
                int r = data.readVarInt();
                for (int k = 0; k < r; ++k) {
                    RewardType type = (RewardType)rewardTypes.getValue(data.readVarInt());
                    Reward reward = type.provider.create(quest);
                    reward.id = data.readInt();
                    quest.rewards.add(reward);
                }
            }
        }
        this.refreshIDMap();
        for (RewardTable table : this.rewardTables) {
            table.readNetData(data);
        }
        for (Chapter chapter : this.chapters) {
            chapter.readNetData(data);
            for (Quest quest : chapter.quests) {
                quest.readNetData(data);
                for (Task task : quest.tasks) {
                    task.readNetData(data);
                }
                for (Reward reward : quest.rewards) {
                    reward.readNetData(data);
                }
            }
        }
        for (QuestObjectBase object : this.getAllObjects()) {
            if (!(object instanceof CustomTask)) continue;
            new CustomTaskEvent((CustomTask)object).post();
        }
        if (FTBLibConfig.debugging.print_more_info) {
            FTBQuests.LOGGER.info("Read " + (data.getPosition() - pos) + " bytes");
        }
    }

    @Override
    public int getParentID() {
        return 0;
    }

    @Nullable
    public abstract QuestData getData(short var1);

    @Nullable
    public abstract QuestData getData(String var1);

    @Nullable
    public final QuestData getData(Entity player) {
        return this.getData(player.func_110124_au());
    }

    @Nullable
    public abstract QuestData getData(UUID var1);

    public abstract Collection<? extends QuestData> getAllData();

    public abstract void deleteObject(int var1);

    @Override
    public Icon getAltIcon() {
        ArrayList<Icon> list = new ArrayList<Icon>();
        for (Chapter chapter : this.chapters) {
            list.add(chapter.getIcon());
        }
        return IconAnimation.fromList(list, (boolean)false);
    }

    @Override
    public String getAltTitle() {
        return I18n.func_135052_a((String)"ftbquests.file", (Object[])new Object[0]);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void getConfig(ConfigGroup config) {
        super.getConfig(config);
        config.addList("emergency_items", this.emergencyItems, (ConfigValue)new ConfigItemStack(ItemStack.field_190927_a), ConfigItemStack::new, ConfigItemStack::getStack);
        config.add("emergency_items_cooldown", (ConfigValue)new ConfigTimer(Ticks.NO_TICKS){

            public Ticks getTimer() {
                return QuestFile.this.emergencyItemsCooldown;
            }

            public void setTimer(Ticks t) {
                QuestFile.this.emergencyItemsCooldown = t;
            }
        }, (ConfigValue)new ConfigTimer(Ticks.MINUTE.x(5L)));
        config.addBool("drop_loot_crates", () -> this.dropLootCrates, v -> {
            this.dropLootCrates = v;
        }, false);
        config.addBool("disable_gui", () -> this.disableGui, v -> {
            this.disableGui = v;
        }, false);
        config.addDouble("grid_scale", () -> this.gridScale, v -> {
            this.gridScale = v;
        }, 0.5, 0.03125, 8.0);
        ConfigGroup defaultsGroup = config.getGroup("defaults");
        defaultsGroup.addBool("reward_team", () -> this.defaultRewardTeam, v -> {
            this.defaultRewardTeam = v;
        }, false);
        defaultsGroup.addBool("consume_items", () -> this.defaultTeamConsumeItems, v -> {
            this.defaultTeamConsumeItems = v;
        }, false);
        defaultsGroup.addEnum("autoclaim_rewards", () -> this.defaultRewardAutoClaim, v -> {
            this.defaultRewardAutoClaim = v;
        }, RewardAutoClaim.NAME_MAP_NO_DEFAULT);
        defaultsGroup.addEnum("quest_shape", () -> this.defaultQuestShape, v -> {
            this.defaultQuestShape = v;
        }, QuestShape.idMap);
        defaultsGroup.addBool("quest_disable_jei", () -> this.defaultQuestDisableJEI, v -> {
            this.defaultQuestDisableJEI = v;
        }, false);
        ConfigGroup d = config.getGroup("loot_crate_no_drop");
        d.addInt("passive", () -> this.lootCrateNoDrop.passive, v -> {
            this.lootCrateNoDrop.passive = v;
        }, 0, 0, Integer.MAX_VALUE).setDisplayName((ITextComponent)new TextComponentTranslation("ftbquests.loot.entitytype.passive", new Object[0]));
        d.addInt("monster", () -> this.lootCrateNoDrop.monster, v -> {
            this.lootCrateNoDrop.monster = v;
        }, 0, 0, Integer.MAX_VALUE).setDisplayName((ITextComponent)new TextComponentTranslation("ftbquests.loot.entitytype.monster", new Object[0]));
        d.addInt("boss", () -> this.lootCrateNoDrop.boss, v -> {
            this.lootCrateNoDrop.boss = v;
        }, 0, 0, Integer.MAX_VALUE).setDisplayName((ITextComponent)new TextComponentTranslation("ftbquests.loot.entitytype.boss", new Object[0]));
    }

    @Override
    public void clearCachedData() {
        super.clearCachedData();
        for (Chapter chapter : this.chapters) {
            chapter.clearCachedData();
        }
        this.clearCachedProgress();
        new ClearFileCacheEvent(this).post();
    }

    public void clearCachedProgress() {
        for (QuestData questData : this.getAllData()) {
            questData.progressCache = null;
            questData.areDependenciesCompleteCache = null;
        }
    }

    public int newID() {
        return this.readID(0);
    }

    public int readID(int id) {
        while (id == 0 || id == 1 || this.map.get(id) != null) {
            id = MathUtils.RAND.nextInt();
        }
        return id;
    }

    public int getID(@Nullable Object o) {
        if (o == null) {
            return 0;
        }
        if (o instanceof Number) {
            return ((Number)o).intValue();
        }
        String id = o.toString();
        if (id.isEmpty()) {
            return 0;
        }
        if (id.charAt(0) == '*') {
            return 1;
        }
        try {
            return Long.valueOf(id.charAt(0) == '#' ? id.substring(1) : id, 16).intValue();
        }
        catch (Exception ex) {
            for (QuestObjectBase b : this.map.values()) {
                if (!b.hasTag(id)) continue;
                return b.id;
            }
            return 0;
        }
    }

    @Nullable
    public LootCrate getRandomLootCrate(Entity entity, Random random) {
        int totalWeight = this.lootCrateNoDrop.getWeight(entity);
        for (RewardTable table : this.rewardTables) {
            if (table.lootCrate == null) continue;
            totalWeight += table.lootCrate.drops.getWeight(entity);
        }
        if (totalWeight <= 0) {
            return null;
        }
        int number = random.nextInt(totalWeight) + 1;
        int currentWeight = this.lootCrateNoDrop.getWeight(entity);
        if (currentWeight < number) {
            for (RewardTable table : this.rewardTables) {
                if (table.lootCrate == null || (currentWeight += table.lootCrate.drops.getWeight(entity)) < number) continue;
                return table.lootCrate;
            }
        }
        return null;
    }

    @Override
    public final int refreshJEI() {
        return FTBQuestsJEIHelper.QUESTS | FTBQuestsJEIHelper.LOOTCRATES;
    }

    public final Collection<QuestObjectBase> getAllObjects() {
        return this.map.values();
    }

    public int getUnclaimedRewards(UUID player, QuestData data, boolean showExcluded) {
        int r = 0;
        for (Chapter chapter : this.chapters) {
            for (Quest quest : chapter.quests) {
                r += quest.getUnclaimedRewards(player, data, showExcluded);
            }
        }
        return r;
    }

    @Override
    public boolean isVisible(QuestData data) {
        for (Chapter chapter : this.chapters) {
            if (!chapter.isVisible(data)) continue;
            return true;
        }
        return false;
    }

    public List<Chapter> getVisibleChapters(QuestData data, boolean excludeEmpty) {
        ArrayList<Chapter> list = new ArrayList<Chapter>();
        for (Chapter chapter : this.chapters) {
            if (excludeEmpty && chapter.quests.isEmpty() || !chapter.isVisible(data)) continue;
            list.add(chapter);
        }
        return list;
    }

    public <T extends QuestObjectBase> List<T> collect(Class<T> clazz, Predicate<QuestObjectBase> filter) {
        ArrayList<QuestObjectBase> list = new ArrayList<QuestObjectBase>();
        for (QuestObjectBase base : this.getAllObjects()) {
            if (!filter.test(base)) continue;
            list.add(base);
        }
        if (list.isEmpty()) {
            return Collections.emptyList();
        }
        if (list.size() == 1) {
            return Collections.singletonList(list.get(0));
        }
        return list;
    }

    public <T extends QuestObjectBase> List<T> collect(Class<T> clazz) {
        return this.collect(clazz, o -> clazz.isAssignableFrom(o.getClass()));
    }

    public String getDefaultQuestShape() {
        return this.defaultQuestShape;
    }
}

