/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbquests.quest;

import com.feed_the_beast.ftblib.lib.config.ConfigGroup;
import com.feed_the_beast.ftblib.lib.io.DataIn;
import com.feed_the_beast.ftblib.lib.io.DataOut;
import com.feed_the_beast.ftbquests.quest.ChangeProgress;
import com.feed_the_beast.ftbquests.quest.QuestData;
import com.feed_the_beast.ftbquests.quest.QuestObjectBase;
import it.unimi.dsi.fastutil.ints.Int2ByteOpenHashMap;
import java.util.List;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class QuestObject
extends QuestObjectBase {
    public boolean disableToast = false;

    @Override
    public void writeData(NBTTagCompound nbt) {
        super.writeData(nbt);
        if (this.disableToast) {
            nbt.func_74757_a("disable_toast", true);
        }
    }

    @Override
    public void readData(NBTTagCompound nbt) {
        super.readData(nbt);
        this.disableToast = nbt.func_74767_n("disable_toast");
    }

    @Override
    public void writeNetData(DataOut data) {
        super.writeNetData(data);
        data.writeBoolean(this.disableToast);
    }

    @Override
    public void readNetData(DataIn data) {
        super.readNetData(data);
        this.disableToast = data.readBoolean();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void getConfig(ConfigGroup config) {
        super.getConfig(config);
        config.addBool("disable_toast", () -> this.disableToast, v -> {
            this.disableToast = v;
        }, false).setDisplayName((ITextComponent)new TextComponentTranslation("ftbquests.disable_completion_toast", new Object[0])).setCanEdit(this.getQuestChapter() == null || !this.getQuestChapter().alwaysInvisible).setOrder(10);
    }

    @Override
    public abstract void changeProgress(QuestData var1, ChangeProgress var2);

    public abstract int getRelativeProgressFromChildren(QuestData var1);

    public final int getRelativeProgress(QuestData data) {
        int i;
        if (!this.cacheProgress()) {
            return this.getRelativeProgressFromChildren(data);
        }
        if (data.progressCache == null) {
            data.progressCache = new Int2ByteOpenHashMap();
            data.progressCache.defaultReturnValue((byte)-1);
        }
        if ((i = data.progressCache.get(this.id)) == -1) {
            i = this.getRelativeProgressFromChildren(data);
            data.progressCache.put(this.id, (byte)i);
        }
        return i;
    }

    public boolean cacheProgress() {
        return true;
    }

    public static int getRelativeProgressFromChildren(int progressSum, int count) {
        if (count <= 0 || progressSum <= 0) {
            return 0;
        }
        if (progressSum >= count * 100) {
            return 100;
        }
        return Math.max(1, (int)((double)progressSum / (double)count));
    }

    public final boolean isStarted(QuestData data) {
        return this.getRelativeProgress(data) > 0;
    }

    public final boolean isComplete(QuestData data) {
        return this.getRelativeProgress(data) >= 100;
    }

    public boolean isVisible(QuestData data) {
        return true;
    }

    public void onCompleted(QuestData data, List<EntityPlayerMP> onlineMembers, List<EntityPlayerMP> notifiedPlayers) {
    }

    @Override
    public abstract String getAltTitle();

    protected boolean verifyDependenciesInternal(QuestObject original, boolean firstLoop) {
        return true;
    }
}

