/*
 * Decompiled with CFR 0.152.
 */
package info.openmods.calc.types.multi;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import info.openmods.calc.executable.IExecutable;
import info.openmods.calc.executable.Value;
import info.openmods.calc.parsing.IValueParser;
import info.openmods.calc.parsing.ast.IAstParser;
import info.openmods.calc.parsing.ast.IModifierStateTransition;
import info.openmods.calc.parsing.ast.IParserState;
import info.openmods.calc.parsing.ast.ISymbolCallStateTransition;
import info.openmods.calc.parsing.ast.QuotedParser;
import info.openmods.calc.parsing.node.ContainerNode;
import info.openmods.calc.parsing.node.IExprNode;
import info.openmods.calc.parsing.node.NullNode;
import info.openmods.calc.parsing.node.ValueNode;
import info.openmods.calc.parsing.token.Token;
import info.openmods.calc.parsing.token.TokenType;
import info.openmods.calc.types.multi.Cons;
import info.openmods.calc.types.multi.Symbol;
import info.openmods.calc.types.multi.TypeDomain;
import info.openmods.calc.types.multi.TypedValue;
import java.util.ArrayList;
import java.util.List;

public class QuoteStateTransition {
    private static final IExprNode<TypedValue> QUOTED_DOT_MARKER = new IExprNode<TypedValue>(){

        @Override
        public void flatten(List<IExecutable<TypedValue>> output) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Iterable<IExprNode<TypedValue>> getChildren() {
            throw new UnsupportedOperationException();
        }
    };
    private final TypeDomain domain;
    private final TypedValue terminatorValue;
    private final IValueParser<TypedValue> valueParser;

    public QuoteStateTransition(TypeDomain domain, TypedValue terminatorValue, IValueParser<TypedValue> valueParser) {
        this.domain = domain;
        this.terminatorValue = terminatorValue;
        this.valueParser = valueParser;
    }

    public static class ForModifier
    extends QuoteStateTransition
    implements IModifierStateTransition<IExprNode<TypedValue>> {
        public ForModifier(TypeDomain domain, TypedValue terminatorValue, IValueParser<TypedValue> valueParser) {
            super(domain, terminatorValue, valueParser);
        }

        @Override
        public IParserState<IExprNode<TypedValue>> getState() {
            return new QuotedState();
        }

        @Override
        public IExprNode<TypedValue> createRootNode(IExprNode<TypedValue> child) {
            return new QuotedRoot(child);
        }
    }

    public static class ForSymbol
    extends QuoteStateTransition
    implements ISymbolCallStateTransition<IExprNode<TypedValue>> {
        public ForSymbol(TypeDomain domain, TypedValue terminatorValue, IValueParser<TypedValue> valueParser) {
            super(domain, terminatorValue, valueParser);
        }

        @Override
        public IParserState<IExprNode<TypedValue>> getState() {
            return new QuotedState();
        }

        @Override
        public IExprNode<TypedValue> createRootNode(List<IExprNode<TypedValue>> children) {
            Preconditions.checkArgument((children.size() == 1 ? 1 : 0) != 0, (String)"Expected exactly one child for quote, got %s", children);
            return new QuotedRoot(children.get(0));
        }
    }

    private class QuotedState
    implements IParserState<IExprNode<TypedValue>> {
        private final QuotedParser<IExprNode<TypedValue>> quotedParser;

        private QuotedState() {
            this.quotedParser = new QuotedParser<IExprNode<TypedValue>>(new QuotedExprNodeFactory());
        }

        @Override
        public IAstParser<IExprNode<TypedValue>> getParser() {
            return this.quotedParser;
        }

        @Override
        public ISymbolCallStateTransition<IExprNode<TypedValue>> getStateForSymbolCall(String symbol) {
            throw new UnsupportedOperationException(symbol);
        }

        @Override
        public IModifierStateTransition<IExprNode<TypedValue>> getStateForModifier(String modifier) {
            throw new UnsupportedOperationException(modifier);
        }
    }

    private class QuotedExprNodeFactory
    implements QuotedParser.IQuotedExprNodeFactory<IExprNode<TypedValue>> {
        private QuotedExprNodeFactory() {
        }

        @Override
        public IExprNode<TypedValue> createValueNode(Token token) {
            if (token.type == TokenType.MODIFIER && token.value.equals("...")) {
                return QUOTED_DOT_MARKER;
            }
            if (token.type == TokenType.SEPARATOR) {
                return new NullNode<TypedValue>();
            }
            if (token.type.isValue()) {
                TypedValue value = (TypedValue)QuoteStateTransition.this.valueParser.parseToken(token);
                return new ValueNode<TypedValue>(value);
            }
            return new ValueNode<TypedValue>(Symbol.get(QuoteStateTransition.this.domain, token.value));
        }

        @Override
        public IExprNode<TypedValue> createBracketNode(String openingBracket, String closingBracket, List<IExprNode<TypedValue>> children) {
            return new ContainerNode<TypedValue>(children);
        }
    }

    private class QuotedRoot
    implements IExprNode<TypedValue> {
        private final IExprNode<TypedValue> arg;

        public QuotedRoot(IExprNode<TypedValue> arg) {
            this.arg = arg;
        }

        @Override
        public void flatten(List<IExecutable<TypedValue>> output) {
            TypedValue node = this.unwrapNode(this.arg);
            output.add(Value.create(node));
        }

        private TypedValue unwrapNode(IExprNode<TypedValue> arg) {
            if (arg instanceof ValueNode) {
                return (TypedValue)((ValueNode)arg).value;
            }
            if (arg instanceof ContainerNode) {
                return this.unwrapList(arg);
            }
            throw new IllegalStateException(arg.toString());
        }

        private TypedValue unwrapList(IExprNode<TypedValue> arg) {
            ArrayList elements = Lists.newArrayList();
            boolean dotFound = false;
            boolean firstAfterDot = false;
            for (IExprNode<TypedValue> childArg : arg.getChildren()) {
                if (childArg instanceof NullNode) continue;
                if (childArg == QUOTED_DOT_MARKER) {
                    Preconditions.checkState((!dotFound ? 1 : 0) != 0, (Object)"Duplicated dot in quoted statement");
                    dotFound = true;
                    continue;
                }
                if (dotFound) {
                    Preconditions.checkState((!firstAfterDot ? 1 : 0) != 0, (Object)"More than one element after dot");
                    firstAfterDot = true;
                }
                elements.add(this.unwrapNode(childArg));
            }
            if (dotFound) {
                int lastElement = elements.size() - 1;
                TypedValue customTerminatorValue = (TypedValue)elements.get(lastElement);
                return Cons.createList(elements.subList(0, lastElement), customTerminatorValue);
            }
            return Cons.createList(elements, QuoteStateTransition.this.terminatorValue);
        }

        @Override
        public Iterable<IExprNode<TypedValue>> getChildren() {
            return ImmutableList.of();
        }
    }
}

