/*
 * Decompiled with CFR 0.152.
 */
package com.mattdahepic.mdecore.command.logic;

import com.mattdahepic.mdecore.command.AbstractCommand;
import com.mattdahepic.mdecore.command.AbstractSingleLogicCommand;
import com.mattdahepic.mdecore.config.MDEConfig;
import com.mattdahepic.mdecore.helpers.TeleportHelper;
import java.util.HashMap;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;

public class TPALogic
extends AbstractSingleLogicCommand {
    public static TPALogic instance = new TPALogic();
    private static HashMap<String, String> pendingConfirms = new HashMap();
    private static HashMap<String, String> pendingTeleports = new HashMap();

    @Override
    public String getCommandName() {
        return "tpa";
    }

    @Override
    public int getPermissionLevel() {
        return 0;
    }

    @Override
    public String getCommandSyntax() {
        return "/mde tpa <player>";
    }

    @Override
    public void handleCommand(final MinecraftServer server, final ICommandSender sender, String[] args) throws CommandException {
        if (args.length == 1) {
            AbstractCommand.throwUsages(instance);
        }
        final EntityPlayerMP senderPlayer = AbstractCommand.func_71521_c((ICommandSender)sender);
        if (args[1].equals("confirm")) {
            if (pendingConfirms.containsKey(sender.func_70005_c_())) {
                final String originalSender = pendingConfirms.get(sender.func_70005_c_());
                pendingTeleports.put(sender.func_70005_c_(), originalSender);
                pendingConfirms.remove(sender.func_70005_c_(), originalSender);
                final EntityPlayerMP teleportee = server.func_184103_al().func_152612_a(originalSender);
                teleportee.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.YELLOW + "Preparing to teleport, stand still!"));
                new Timer().schedule(new TimerTask(){

                    @Override
                    public void run() {
                        if (pendingTeleports.containsKey(sender.func_70005_c_())) {
                            pendingTeleports.remove(sender.func_70005_c_(), originalSender);
                            if (senderPlayer.field_71093_bK != teleportee.field_71093_bK) {
                                TeleportHelper.transferPlayerToDimension(teleportee, senderPlayer.field_71093_bK, server.func_184103_al());
                            }
                            teleportee.func_70634_a(senderPlayer.field_70165_t, senderPlayer.field_70163_u, senderPlayer.field_70161_v);
                            sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.GREEN + "Teleport successful."));
                            teleportee.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.GREEN + "Teleport successful."));
                        }
                    }
                }, MathHelper.func_76141_d((float)(MDEConfig.tpaWaitTime * 1000)));
                new Thread(){

                    @Override
                    public void run() {
                        BlockPos cachePosition = teleportee.func_180425_c();
                        while (cachePosition.equals((Object)teleportee.func_180425_c()) || pendingTeleports.containsKey(originalSender)) {
                        }
                        if (pendingTeleports.containsKey(originalSender)) {
                            pendingTeleports.remove(sender.func_70005_c_(), originalSender);
                            sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.RED + "Teleport canceled."));
                            teleportee.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.RED + "Teleport canceled."));
                        }
                    }
                }.start();
            } else {
                sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.RED + "There are no pending teleports to you."));
            }
        } else {
            final EntityPlayerMP target = AbstractCommand.func_184888_a((MinecraftServer)server, (ICommandSender)sender, (String)args[1]);
            if (target.func_70005_c_().equals(sender.func_70005_c_())) {
                throw new CommandException("That's you silly!", new Object[0]);
            }
            if (!MDEConfig.tpaCrossDimension && target.field_71093_bK != senderPlayer.field_71093_bK) {
                throw new CommandException("Your server does not allow cross-dimension tpa. Try again when you and the target are in the same dimension.", new Object[0]);
            }
            sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.DARK_GREEN + "Waiting for target to confirm, stand still"));
            target.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.AQUA + sender.func_70005_c_() + TextFormatting.LIGHT_PURPLE + " wants to teleport to you.\n" + TextFormatting.LIGHT_PURPLE + "Type " + TextFormatting.GREEN + "/mde tpa confirm" + TextFormatting.LIGHT_PURPLE + " to confirm or " + TextFormatting.RED + "wait 10 seconds" + TextFormatting.LIGHT_PURPLE + " to deny."));
            pendingConfirms.put(target.func_70005_c_(), sender.func_70005_c_());
            new Timer().schedule(new TimerTask(){

                @Override
                public void run() {
                    try {
                        pendingConfirms.remove(target.func_70005_c_(), sender.func_70005_c_());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }, 10000L);
        }
    }

    @Override
    public List<String> getTabCompletionList(MinecraftServer server, ICommandSender sender, String[] args, BlockPos pos) {
        return args.length == 2 ? AbstractCommand.getPlayerNamesStartingWithLastArg(server, args) : null;
    }
}

