/*
 * Decompiled with CFR 0.152.
 */
package com.mattdahepic.mdecore.helpers;

import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;

public class NumberHelper {
    private static final NavigableMap<Long, String> suffixes = new TreeMap<Long, String>();

    public static String IntegerToRomanNumerals(int number) {
        String ret = "";
        while (number >= 1000) {
            ret = ret + "M";
            number -= 1000;
        }
        while (number >= 900) {
            ret = ret + "CM";
            number -= 900;
        }
        while (number >= 500) {
            ret = ret + "D";
            number -= 500;
        }
        while (number >= 400) {
            ret = ret + "CD";
            number -= 400;
        }
        while (number >= 100) {
            ret = ret + "C";
            number -= 100;
        }
        while (number >= 90) {
            ret = ret + "XC";
            number -= 90;
        }
        while (number >= 50) {
            ret = ret + "L";
            number -= 50;
        }
        while (number >= 40) {
            ret = ret + "XL";
            number -= 40;
        }
        while (number >= 10) {
            ret = ret + "X";
            number -= 10;
        }
        while (number >= 9) {
            ret = ret + "IX";
            number -= 9;
        }
        while (number >= 5) {
            ret = ret + "V";
            number -= 5;
        }
        while (number >= 4) {
            ret = ret + "IV";
            number -= 4;
        }
        while (number >= 1) {
            ret = ret + "I";
            --number;
        }
        return ret;
    }

    public static String niceifyNumber(long value) {
        if (value == Long.MIN_VALUE) {
            return NumberHelper.niceifyNumber(-9223372036854775807L);
        }
        if (value < 0L) {
            return "-" + NumberHelper.niceifyNumber(-value);
        }
        if (value < 1000L) {
            return Long.toString(value);
        }
        Map.Entry<Long, String> e = suffixes.floorEntry(value);
        Long divideBy = e.getKey();
        String suffix = e.getValue();
        long truncated = value / (divideBy / 10L);
        boolean hasDecimal = truncated < 100L && (double)truncated / 10.0 != (double)(truncated / 10L);
        return hasDecimal ? (double)truncated / 10.0 + suffix : truncated / 10L + suffix;
    }

    static {
        suffixes.put(1000L, "k");
        suffixes.put(1000000L, "M");
        suffixes.put(1000000000L, "G");
        suffixes.put(1000000000000L, "T");
        suffixes.put(1000000000000000L, "P");
        suffixes.put(1000000000000000000L, "E");
    }
}

