/*
 * Decompiled with CFR 0.152.
 */
package com.mattdahepic.mdecore.recipe;

import com.mattdahepic.mdecore.helpers.ItemHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.block.Block;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class NBTRespectingShapelessOreRecipe
extends IForgeRegistryEntry.Impl<IRecipe>
implements IRecipe {
    protected ItemStack output = null;
    protected ArrayList<ItemStack> input = new ArrayList();

    public NBTRespectingShapelessOreRecipe(Block result, Object ... recipe) {
        this(new ItemStack(result), recipe);
    }

    public NBTRespectingShapelessOreRecipe(Item result, Object ... recipe) {
        this(new ItemStack(result), recipe);
    }

    public NBTRespectingShapelessOreRecipe(ItemStack result, Object ... recipe) {
        this.output = result.func_77946_l();
        for (Object in : recipe) {
            if (in instanceof ItemStack) {
                this.input.add(((ItemStack)in).func_77946_l());
                continue;
            }
            if (in instanceof Item) {
                this.input.add(new ItemStack((Item)in));
                continue;
            }
            if (in instanceof Block) {
                this.input.add(new ItemStack((Block)in));
                continue;
            }
            if (in instanceof String) {
                OreDictionary.getOres((String)((String)in)).forEach((Consumer)new Consumer<ItemStack>(){

                    @Override
                    public void accept(ItemStack s) {
                        NBTRespectingShapelessOreRecipe.this.input.add(s);
                    }
                });
                continue;
            }
            String ret = "Invalid shapeless ore recipe: ";
            for (Object tmp : recipe) {
                ret = ret + tmp + ", ";
            }
            ret = ret + this.output;
            throw new RuntimeException(ret);
        }
    }

    public boolean func_194133_a(int width, int height) {
        return this.input.size() <= width * height;
    }

    public ItemStack func_77571_b() {
        return this.output;
    }

    public ItemStack func_77572_b(InventoryCrafting c) {
        return this.output.func_77946_l();
    }

    public ArrayList<ItemStack> getInput() {
        return this.input;
    }

    public boolean func_77569_a(InventoryCrafting c, World world) {
        ArrayList<ItemStack> required = new ArrayList<ItemStack>(this.input);
        for (int x = 0; x < c.func_70302_i_(); ++x) {
            ItemStack slot = c.func_70301_a(x);
            if (slot == null) continue;
            boolean inRecipe = false;
            for (ItemStack req : required) {
                boolean match = false;
                if (req instanceof ItemStack) {
                    match = this.isItemSame(req, slot);
                } else if (req instanceof List) {
                    for (ItemStack s : (List)req) {
                        match = this.isItemSame(s, slot);
                    }
                }
                if (!match) continue;
                inRecipe = true;
                required.remove(req);
                break;
            }
            if (inRecipe) continue;
            return false;
        }
        return required.isEmpty();
    }

    public NonNullList<ItemStack> func_179532_b(InventoryCrafting inv) {
        return ForgeHooks.defaultRecipeGetRemainingItems((InventoryCrafting)inv);
    }

    public boolean isItemSame(ItemStack stack1, ItemStack stack2) {
        return ItemHelper.isSameIgnoreStackSize(stack1, stack2, true);
    }
}

