/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.roots.event.handlers;

import epicsquid.mysticallib.util.ItemUtil;
import epicsquid.mysticallib.util.Util;
import epicsquid.roots.block.BlockElementalSoil;
import epicsquid.roots.init.ModBlocks;
import epicsquid.roots.mechanics.Harvest;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Mod.EventBusSubscriber(modid="roots")
public class SoilHandler {
    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onCropHarvest(BlockEvent.HarvestDropsEvent event) {
        if (event.getHarvester() != null && event.getState().func_177230_c() instanceof IPlantable) {
            IBlockState soil = event.getWorld().func_180495_p(event.getPos().func_177972_a(EnumFacing.DOWN));
            if (event.getState().func_177230_c() instanceof IPlantable && soil.func_177230_c().canSustainPlant(soil, (IBlockAccess)event.getWorld(), event.getPos().func_177972_a(EnumFacing.DOWN), EnumFacing.UP, (IPlantable)event.getState().func_177230_c())) {
                int fertility;
                int cookingMultiplier;
                if (soil.func_177230_c() == ModBlocks.elemental_soil_fire && (cookingMultiplier = ((Integer)soil.func_177229_b((IProperty)BlockElementalSoil.FIRE_MULTIPLIER)).intValue()) > 0) {
                    ItemStack seed = Harvest.getSeed(event.getState());
                    ArrayList<ItemStack> newDrops = new ArrayList<ItemStack>();
                    Random random = new Random();
                    boolean foundSeed = false;
                    for (ItemStack stack : event.getDrops()) {
                        ItemStack result = FurnaceRecipes.func_77602_a().func_151395_a(stack);
                        if (!foundSeed && !seed.func_190926_b() && ItemUtil.equalWithoutSize((ItemStack)seed, (ItemStack)stack)) {
                            foundSeed = true;
                            newDrops.add(stack);
                            continue;
                        }
                        if (!foundSeed && seed.func_190926_b() && stack.func_77973_b() instanceof IPlantable) {
                            foundSeed = true;
                            seed = stack;
                            newDrops.add(stack);
                            continue;
                        }
                        if (!result.func_190926_b()) {
                            ItemStack copy = result.func_77946_l();
                            copy.func_190920_e(cookingMultiplier - 1 > 0 ? random.nextInt(cookingMultiplier - 1) + 1 : 1);
                            newDrops.add(copy);
                            continue;
                        }
                        newDrops.add(stack);
                    }
                    World world = event.getWorld();
                    BlockPos pos = event.getPos();
                    if (Harvest.isGrown(event.getState()) && Util.rand.nextInt(3) == 0 && !world.field_72995_K) {
                        world.func_72838_d((Entity)new EntityXPOrb(world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, 1));
                    }
                    event.getDrops().clear();
                    event.getDrops().addAll(newDrops);
                }
                if (soil.func_177230_c() == ModBlocks.elemental_soil_earth && Harvest.isGrown(event.getState()) && (fertility = ((Integer)soil.func_177229_b((IProperty)BlockElementalSoil.EARTH_FERTILITY)).intValue()) > 0) {
                    ArrayList<ItemStack> newDrops = new ArrayList<ItemStack>();
                    Random random = new Random();
                    for (ItemStack stack : event.getDrops()) {
                        newDrops.add(stack);
                        if (random.nextInt(3) >= fertility) continue;
                        newDrops.add(new ItemStack(stack.func_77973_b(), fertility > 2 ? 2 : 1));
                    }
                    event.getDrops().clear();
                    event.getDrops().addAll(newDrops);
                }
            }
        }
    }

    @SubscribeEvent
    public static void onCropsGrowPost(BlockEvent.CropGrowEvent.Post cropGrowEvent) {
        ((BlockElementalSoil)ModBlocks.elemental_soil_water).doHarvest(cropGrowEvent);
    }

    @SubscribeEvent
    public static void onCropsGrowPre(BlockEvent.CropGrowEvent.Pre cropGrowEvent) {
        int speed;
        IBlockState soil = cropGrowEvent.getWorld().func_180495_p(cropGrowEvent.getPos().func_177972_a(EnumFacing.DOWN));
        IBlockState plant = cropGrowEvent.getWorld().func_180495_p(cropGrowEvent.getPos());
        if (plant.func_177230_c() instanceof IPlantable && soil.func_177230_c().canSustainPlant(soil, (IBlockAccess)cropGrowEvent.getWorld(), cropGrowEvent.getPos().func_177972_a(EnumFacing.DOWN), EnumFacing.UP, (IPlantable)plant.func_177230_c()) && soil.func_177230_c() == ModBlocks.elemental_soil_air && (speed = ((Integer)soil.func_177229_b((IProperty)BlockElementalSoil.AIR_SPEED)).intValue()) > 0) {
            cropGrowEvent.setResult(Util.rand.nextInt(3) == 0 ? Event.Result.ALLOW : Event.Result.DEFAULT);
        }
    }
}

