/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.roots.integration.crafttweaker.tweaks;

import crafttweaker.CraftTweakerAPI;
import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.minecraft.CraftTweakerMC;
import crafttweaker.mc1120.CraftTweaker;
import epicsquid.roots.init.ModRecipes;
import epicsquid.roots.integration.crafttweaker.Action;
import epicsquid.roots.util.zen.ZenDocAppend;
import epicsquid.roots.util.zen.ZenDocArg;
import epicsquid.roots.util.zen.ZenDocClass;
import epicsquid.roots.util.zen.ZenDocMethod;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenDocClass(value="mods.roots.Bark")
@ZenDocAppend(value={"docs/include/bark.example.md"})
@ZenRegister
@ZenClass(value="mods.roots.Bark")
public class BarkTweaker {
    @ZenDocMethod(order=1, args={@ZenDocArg(arg="name", info="the name of the recipe"), @ZenDocArg(arg="woodLog", info="the itemstack equivalent of the wood log being broken"), @ZenDocArg(arg="bark", info="the itemstack of the type of bark this log produces (including stack count)")})
    @ZenMethod
    public static void addRecipe(String name, IItemStack woodLog, IItemStack bark) {
        ItemStack log = CraftTweakerMC.getItemStack((IItemStack)woodLog);
        if (!(log.func_77973_b() instanceof ItemBlock)) {
            CraftTweakerAPI.logError((String)("Provided log " + woodLog + " is not an item block!"));
            return;
        }
        CraftTweaker.LATE_ACTIONS.add(new Add(name, CraftTweakerMC.getItemStack((IItemStack)bark), log));
    }

    @ZenDocMethod(order=2, args={@ZenDocArg(arg="bark", info="the itemstack of the type of bark to remove (excluding stack size)")})
    @ZenMethod
    public static void removeRecipe(IItemStack bark) {
        CraftTweaker.LATE_ACTIONS.add(new Remove(CraftTweakerMC.getItemStack((IItemStack)bark)));
    }

    private static class Add
    extends Action {
        private final ItemStack woodLog;
        private final ItemStack bark;
        private final String name;

        public Add(String name, ItemStack bark, ItemStack woodLog) {
            super("add_bark_recipe");
            this.woodLog = woodLog;
            this.bark = bark;
            this.name = name;
        }

        public void apply() {
            ModRecipes.addModdedBarkRecipe(this.name, this.bark, this.woodLog);
        }

        public String describe() {
            return String.format("Recipe to add %s->%s to Bark Recipes", this.woodLog, this.bark);
        }
    }

    private static class Remove
    extends Action {
        private final ItemStack bark;

        public Remove(ItemStack bark) {
            super("remove_bark_recipe");
            this.bark = bark;
        }

        public void apply() {
            ModRecipes.removeBarkRecipe(this.bark);
        }

        public String describe() {
            return String.format("Recipe to remove %s from Bark Recipes", this.bark.toString());
        }
    }
}

