/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.roots.integration.crafttweaker.tweaks;

import crafttweaker.CraftTweakerAPI;
import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.entity.IEntityDefinition;
import crafttweaker.api.item.IIngredient;
import crafttweaker.api.minecraft.CraftTweakerMC;
import crafttweaker.mc1120.CraftTweaker;
import epicsquid.roots.init.ModRecipes;
import epicsquid.roots.integration.crafttweaker.Action;
import epicsquid.roots.util.zen.ZenDocAppend;
import epicsquid.roots.util.zen.ZenDocArg;
import epicsquid.roots.util.zen.ZenDocClass;
import epicsquid.roots.util.zen.ZenDocMethod;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.crafting.Ingredient;
import net.minecraftforge.fml.common.registry.EntityEntry;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenDocClass(value="mods.roots.SummonCreatures")
@ZenDocAppend(value={"docs/include/summon_creatures.example.md"})
@ZenRegister
@ZenClass(value="mods.roots.SummonCreatures")
public class SummonCreaturesTweaker {
    @ZenDocMethod(order=1, args={@ZenDocArg(arg="entity", info="the entity to be summoned"), @ZenDocArg(arg="ingredients", info="a list of ingredients used for the summoning")})
    @ZenMethod
    public static void addEntity(IEntityDefinition entity, IIngredient[] ingredients) {
        CraftTweaker.LATE_ACTIONS.add(new Add((EntityEntry)entity.getInternal(), Stream.of(ingredients).map(CraftTweakerMC::getIngredient).collect(Collectors.toList())));
    }

    @ZenDocMethod(order=2, args={@ZenDocArg(arg="entity", info="the entity to remove from summoning via recipe")})
    @ZenMethod
    public static void removeEntity(IEntityDefinition entity) {
        CraftTweaker.LATE_ACTIONS.add(new Remove((EntityEntry)entity.getInternal()));
    }

    @ZenDocMethod(order=3, args={@ZenDocArg(arg="entity", info="the entity to remove life essence for")})
    @ZenMethod
    public static void removeLifeEssence(IEntityDefinition entity) {
        CraftTweaker.LATE_ACTIONS.add(new RemoveLifeEssence((EntityEntry)entity.getInternal()));
    }

    @ZenDocMethod(order=4, args={@ZenDocArg(arg="entity", info="the entity to add life essence for")})
    @ZenMethod
    public static void addLifeEssence(IEntityDefinition entity) {
        CraftTweaker.LATE_ACTIONS.add(new AddLifeEssence((EntityEntry)entity.getInternal()));
    }

    @ZenDocMethod(order=5)
    @ZenMethod
    public static void clearLifeEssence() {
        CraftTweaker.LATE_ACTIONS.add(new ClearLifeEssence());
    }

    private static class AddLifeEssence
    extends Action {
        private final EntityEntry entry;

        public AddLifeEssence(EntityEntry entry) {
            super("add_life_essence");
            this.entry = entry;
            if (!EntityLivingBase.class.isAssignableFrom(this.entry.getEntityClass())) {
                CraftTweakerAPI.logError((String)("Invalid Summon Creature life essence entity class to add: " + this.entry.getEntityClass().getSimpleName()));
            }
        }

        public void apply() {
            ModRecipes.addLifeEssence(this.entry.getEntityClass());
        }

        public String describe() {
            return String.format("Recipe to add %s to Life Essence", this.entry.getName());
        }
    }

    private static class Add
    extends Action {
        private final EntityEntry entry;
        private List<Ingredient> ingredients;

        public Add(EntityEntry entry, List<Ingredient> ingredients) {
            super("add_summon_creature");
            this.entry = entry;
            this.ingredients = ingredients;
            if (!EntityLivingBase.class.isAssignableFrom(this.entry.getEntityClass())) {
                CraftTweakerAPI.logError((String)("Invalid Summon Creature entity class to add: " + this.entry.getEntityClass().getSimpleName()));
            }
        }

        public void apply() {
            Class elb = this.entry.getEntityClass();
            if (ModRecipes.getSummonCreatureEntry(elb) != null) {
                CraftTweakerAPI.logError((String)("Summon Creature Recipe already exists for entity: " + this.entry.getName()));
                return;
            }
            ModRecipes.addSummonCreatureEntry(this.entry.getName(), (Class<? extends EntityLivingBase>)elb, this.ingredients);
        }

        public String describe() {
            return String.format("Recipe to add %s to Summon Creatures", this.entry.getName());
        }
    }

    private static class ClearLifeEssence
    extends Action {
        public ClearLifeEssence() {
            super("clear_life_essences");
        }

        public void apply() {
            ModRecipes.clearLifeEssence();
        }

        public String describe() {
            return String.format("Recipe to clear all life essences", new Object[0]);
        }
    }

    private static class RemoveLifeEssence
    extends Action {
        private final EntityEntry entry;

        public RemoveLifeEssence(EntityEntry entry) {
            super("remove_life_essence");
            this.entry = entry;
            if (!EntityLivingBase.class.isAssignableFrom(this.entry.getEntityClass())) {
                CraftTweakerAPI.logError((String)("Invalid Summon Creature entity class to remove: " + this.entry.getEntityClass().getSimpleName()));
            }
        }

        public void apply() {
            Class clz = this.entry.getEntityClass();
            ModRecipes.removeLifeEssence(clz);
        }

        public String describe() {
            return String.format("Recipe to blacklist %s from SummonCreatures and Life Essence", this.entry.getName());
        }
    }

    private static class Remove
    extends Action {
        private final EntityEntry entry;

        public Remove(EntityEntry entry) {
            super("remove_summon_creature");
            this.entry = entry;
            if (!EntityLivingBase.class.isAssignableFrom(this.entry.getEntityClass())) {
                CraftTweakerAPI.logError((String)("Invalid Summon Creature entity class to remove: " + this.entry.getEntityClass().getSimpleName()));
            }
        }

        public void apply() {
            Class clz = this.entry.getEntityClass();
            ModRecipes.removeSummonCreatureEntry(clz);
        }

        public String describe() {
            return String.format("Recipe to remove %s from SummonCreatures", this.entry.getName());
        }
    }
}

