/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.roots.item;

import epicsquid.mysticallib.item.ItemArrowBase;
import epicsquid.mysticallib.util.ItemUtil;
import epicsquid.mysticallib.util.Util;
import epicsquid.roots.Roots;
import epicsquid.roots.entity.item.EntityLivingArrow;
import epicsquid.roots.handler.QuiverHandler;
import epicsquid.roots.init.ModItems;
import epicsquid.roots.util.QuiverInventoryUtil;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.entity.projectile.EntityTippedArrow;
import net.minecraft.init.Items;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.ItemArrow;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class ItemQuiver
extends ItemArrowBase {
    public static AxisAlignedBB bounding = new AxisAlignedBB(-2.5, -2.5, -2.5, 2.5, 2.5, 2.5);
    public static Method getArrowStack = null;

    public ItemQuiver(@Nonnull String name) {
        super(name);
        this.func_77625_d(1);
        this.func_77656_e(256);
    }

    public EntityArrow func_185052_a(World worldIn, ItemStack stack, EntityLivingBase shooter) {
        ItemStack arrow = ItemQuiver.findArrow(stack);
        if (!arrow.func_190926_b()) {
            EntityArrow entityArrow = ((ItemArrow)arrow.func_77973_b()).func_185052_a(worldIn, arrow, shooter);
            entityArrow.getEntityData().func_74757_a("return", true);
            return entityArrow;
        }
        EntityTippedArrow entityArrow = new EntityTippedArrow(worldIn, shooter);
        entityArrow.func_70239_b(1.5);
        entityArrow.getEntityData().func_74757_a("generated", true);
        stack.func_77972_a(field_77697_d.nextInt(2), shooter);
        return entityArrow;
    }

    public boolean isInfinite(ItemStack stack, ItemStack bow, EntityPlayer player) {
        return true;
    }

    public static ItemStack findArrow(ItemStack quiver) {
        QuiverHandler handler = QuiverHandler.getHandler(quiver);
        ItemStack result = ItemStack.field_190927_a;
        for (int i = 0; i < handler.getInventory().getSlots(); ++i) {
            ItemStack stack = handler.getInventory().getStackInSlot(i);
            if (stack.func_190926_b()) continue;
            result = handler.getInventory().extractItem(i, 1, false);
            break;
        }
        return result;
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, @Nonnull EnumHand hand) {
        player.openGui((Object)Roots.getInstance(), 17, world, 0, 0, 0);
        return new ActionResult(EnumActionResult.SUCCESS, (Object)player.func_184586_b(hand));
    }

    public static void tryPickupArrows(EntityPlayer player) {
        ItemStack quiver = QuiverInventoryUtil.getQuiver(player);
        if (quiver.func_190926_b()) {
            return;
        }
        List arrows = player.field_70170_p.func_72872_a(EntityArrow.class, bounding.func_186670_a(player.func_180425_c()));
        if (arrows.isEmpty()) {
            return;
        }
        QuiverHandler handler = QuiverHandler.getHandler(quiver);
        int consumed = 0;
        int generated = 0;
        for (EntityArrow arrow : arrows) {
            ItemStack stack = ItemQuiver.getArrowStack(arrow);
            if (stack.func_190926_b()) {
                stack = arrow instanceof EntityLivingArrow ? new ItemStack(ModItems.living_arrow) : new ItemStack(Items.field_151032_g);
            }
            arrow.func_70106_y();
            if (arrow.getEntityData().func_74764_b("generated")) {
                ++generated;
                continue;
            }
            if (Util.rand.nextInt(3) == 0 && !arrow.getEntityData().func_74764_b("return")) continue;
            ItemStack result = ItemHandlerHelper.insertItemStacked((IItemHandler)handler.getInventory(), (ItemStack)stack, (boolean)false);
            if (result.func_190926_b()) {
                ++consumed;
                continue;
            }
            result = ItemHandlerHelper.insertItemStacked((IItemHandler)((IItemHandler)player.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, EnumFacing.UP)), (ItemStack)result, (boolean)false);
            if (result.func_190926_b()) continue;
            ItemUtil.spawnItem((World)player.field_70170_p, (BlockPos)player.func_180425_c(), (ItemStack)result);
        }
        if (consumed > 0) {
            player.func_146105_b(new TextComponentTranslation("roots.quiver.picked_up_arrow", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.GREEN).func_150227_a(Boolean.valueOf(true))), true);
        } else if (consumed == 0 && generated > 0) {
            player.func_146105_b(new TextComponentTranslation("roots.quiver.fragile", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.DARK_GREEN).func_150227_a(Boolean.valueOf(true))), true);
        } else {
            player.func_146105_b(new TextComponentTranslation("roots.quiver.broke", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.DARK_GREEN).func_150227_a(Boolean.valueOf(true))), true);
        }
    }

    public EnumRarity func_77613_e(ItemStack stack) {
        return EnumRarity.RARE;
    }

    public int func_77619_b() {
        return 22;
    }

    public boolean func_77616_k(ItemStack stack) {
        return true;
    }

    public boolean func_82789_a(ItemStack toRepair, ItemStack repair) {
        return toRepair.func_77973_b() == this && repair.func_77973_b() == ModItems.bark_wildwood;
    }

    public boolean isRepairable() {
        return true;
    }

    public static ItemStack getArrowStack(EntityArrow arrow) {
        if (getArrowStack == null) {
            try {
                getArrowStack = EntityArrow.class.getDeclaredMethod("getArrowStack", new Class[0]);
            }
            catch (NoSuchMethodException e) {
                return ItemStack.field_190927_a;
            }
            getArrowStack.setAccessible(true);
        }
        try {
            return (ItemStack)getArrowStack.invoke((Object)arrow, new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            return ItemStack.field_190927_a;
        }
    }
}

