/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.roots.mechanics;

import epicsquid.mysticallib.util.ItemUtil;
import epicsquid.roots.config.CropConfig;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.lang.reflect.Method;
import java.util.ArrayDeque;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockCrops;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Mod.EventBusSubscriber(modid="roots")
public class Harvest {
    private static Method getSeed;
    private static Map<IProperty<?>, Integer> stateMax;
    private static Deque<HarvestEntry> queue;
    private static HashMap<Block, ItemStack> seedCache;

    public static int getMaxState(IProperty<?> prop) {
        return stateMax.getOrDefault(prop, -1);
    }

    public static void setMaxState(IProperty<?> prop, int max) {
        stateMax.put(prop, max);
    }

    public static Set<IProperty<?>> getStateKeys() {
        return stateMax.keySet();
    }

    public static IProperty<?> resolveStates(IBlockState state) {
        Block block = state.func_177230_c();
        ResourceLocation rl = block.getRegistryName();
        if (CropConfig.getHarvestModBlacklist().contains(Objects.requireNonNull(rl).func_110624_b()) || CropConfig.getHarvestBlacklist().contains(rl)) {
            return null;
        }
        for (IProperty prop : state.func_177227_a()) {
            if (!prop.func_177701_a().equals("age") && !prop.func_177701_a().equals("growth") || prop.func_177699_b() != Integer.class) continue;
            int max = Harvest.getMaxState(prop);
            if (max == -1) {
                max = (Integer)Collections.max(prop.func_177700_c());
                Harvest.setMaxState(prop, max);
            }
            return prop;
        }
        return null;
    }

    public static void prepare() {
        seedCache.clear();
        seedCache.put(Blocks.field_150388_bm, new ItemStack(Items.field_151075_bm));
    }

    public static void add(ItemStack seed, int dimension, BlockPos position, IBlockState block) {
        queue.add(new HarvestEntry(seed, dimension, position, block));
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onHarvestDrops(BlockEvent.HarvestDropsEvent event) {
        HarvestEntry me;
        if (queue.peek() == null) {
            return;
        }
        HarvestEntry ref = queue.pop();
        if (!ref.equals(me = new HarvestEntry(null, event.getWorld().field_73011_w.getDimension(), event.getPos(), event.getState()))) {
            return;
        }
        ItemStack seed = ref.getSeed();
        List drops = event.getDrops();
        ListIterator dropIter = drops.listIterator();
        while (dropIter.hasNext()) {
            ItemStack copy = ((ItemStack)dropIter.next()).func_77946_l();
            copy.func_190920_e(1);
            if (ItemStack.func_77989_b((ItemStack)copy, (ItemStack)seed)) {
                dropIter.remove();
                break;
            }
            if (!(copy.func_77973_b() instanceof IPlantable)) continue;
            dropIter.remove();
            break;
        }
    }

    public static ItemStack getSeed(IBlockState state) {
        Block block = state.func_177230_c();
        ItemStack seed = seedCache.get(block);
        if (seed != null && !seed.func_190926_b()) {
            return seed;
        }
        try {
            seed = new ItemStack((Item)getSeed.invoke((Object)state.func_177230_c(), new Object[0]));
        }
        catch (Exception e) {
            seed = ItemStack.field_190927_a;
        }
        seedCache.put(state.func_177230_c(), seed);
        return seed;
    }

    public static List<ItemStack> harvestReturnDrops(IBlockState state, IProperty<?> prop, ItemStack seed, BlockPos pos, World world, @Nullable EntityPlayer player) {
        IBlockState newState = state.func_177226_a(prop, (Comparable)Integer.valueOf(0));
        NonNullList drops = NonNullList.func_191196_a();
        Harvest.add(seed, world.field_73011_w.getDimension(), pos, state);
        state.func_177230_c().getDrops(drops, (IBlockAccess)world, pos, state, 0);
        ForgeEventFactory.fireBlockHarvesting((List)drops, (World)world, (BlockPos)pos, (IBlockState)state, (int)0, (float)1.0f, (boolean)false, (EntityPlayer)player);
        world.func_175656_a(pos, newState);
        return drops;
    }

    public static void doHarvest(IBlockState state, IProperty<?> prop, ItemStack seed, BlockPos pos, World world, @Nullable EntityPlayer player) {
        List<ItemStack> drops = Harvest.harvestReturnDrops(state, prop, seed, pos, world, player);
        for (ItemStack stack : drops) {
            if (stack.func_190926_b()) continue;
            ItemUtil.spawnItem((World)world, (BlockPos)pos, (ItemStack)stack);
        }
    }

    public static List<ItemStack> harvestReturnDrops(IBlockState state, BlockPos pos, World world, @Nullable EntityPlayer player) {
        ItemStack seed = Harvest.getSeed(state);
        IProperty<?> prop = Harvest.resolveStates(state);
        return Harvest.harvestReturnDrops(state, prop, seed, pos, world, player);
    }

    public static void doHarvest(IBlockState state, BlockPos pos, World world, @Nullable EntityPlayer player) {
        List<ItemStack> drops = Harvest.harvestReturnDrops(state, pos, world, player);
        for (ItemStack stack : drops) {
            if (stack.func_190926_b()) continue;
            ItemUtil.spawnItem((World)world, (BlockPos)pos, (ItemStack)stack);
        }
    }

    public static boolean isGrown(IBlockState state) {
        IProperty<?> prop = Harvest.resolveStates(state);
        if (prop == null) {
            return false;
        }
        return (Integer)state.func_177229_b(prop) == Harvest.getMaxState(prop);
    }

    static {
        stateMax = new Object2IntOpenHashMap();
        queue = new ArrayDeque<HarvestEntry>();
        seedCache = new HashMap();
        getSeed = ObfuscationReflectionHelper.findMethod(BlockCrops.class, (String)"func_149866_i", Item.class, (Class[])new Class[0]);
        getSeed.setAccessible(true);
    }

    public static class HarvestEntry {
        private ItemStack seed;
        private int dimension;
        private BlockPos position;
        private IBlockState block;

        public HarvestEntry(ItemStack seed, int dimension, BlockPos position, IBlockState block) {
            this.seed = seed;
            this.dimension = dimension;
            this.position = position;
            this.block = block;
        }

        public ItemStack getSeed() {
            return this.seed;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            HarvestEntry that = (HarvestEntry)o;
            return this.dimension == that.dimension && Objects.equals(this.position, that.position) && Objects.equals(this.block, that.block);
        }

        public int hashCode() {
            return Objects.hash(this.seed, this.dimension, this.position, this.block);
        }
    }
}

