/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.roots.recipe;

import epicsquid.mysticallib.util.ListUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;

public class FeyCraftingRecipe {
    private List<Ingredient> ingredients = new ArrayList<Ingredient>();
    private ItemStack result;
    private String name;
    private int xp;

    public FeyCraftingRecipe(ItemStack result, int xp) {
        this.result = result;
        this.xp = xp;
    }

    public FeyCraftingRecipe(ItemStack result) {
        this(result, 0);
    }

    public FeyCraftingRecipe setName(String name) {
        this.name = name;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public FeyCraftingRecipe addIngredient(Ingredient stack) {
        this.ingredients.add(stack);
        return this;
    }

    public FeyCraftingRecipe addIngredient(ItemStack stack) {
        this.ingredients.add(Ingredient.func_193369_a((ItemStack[])new ItemStack[]{stack}));
        return this;
    }

    public FeyCraftingRecipe addIngredients(Object ... stacks) {
        for (Object stack : stacks) {
            if (stack instanceof Ingredient) {
                this.ingredients.add((Ingredient)stack);
                continue;
            }
            if (!(stack instanceof ItemStack)) continue;
            this.ingredients.add(Ingredient.func_193369_a((ItemStack[])new ItemStack[]{(ItemStack)stack}));
        }
        return this;
    }

    public boolean matches(List<ItemStack> ingredients) {
        return ListUtil.matchesIngredients(ingredients, this.ingredients);
    }

    public ItemStack getResult() {
        return this.result;
    }

    public int getXP() {
        return this.xp;
    }

    public List<ItemStack> getRecipe() {
        return this.ingredients.stream().map(ingredient -> ingredient.func_193365_a()[0]).collect(Collectors.toList());
    }

    public List<Ingredient> getIngredients() {
        return this.ingredients;
    }

    public void postCraft(ItemStack output, List<ItemStack> inputs) {
    }
}

