/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.roots.ritual;

import epicsquid.roots.config.RitualConfig;
import epicsquid.roots.ritual.RitualAnimalHarvest;
import epicsquid.roots.ritual.RitualBase;
import epicsquid.roots.ritual.RitualDivineProtection;
import epicsquid.roots.ritual.RitualFireStorm;
import epicsquid.roots.ritual.RitualFlowerGrowth;
import epicsquid.roots.ritual.RitualFrostLands;
import epicsquid.roots.ritual.RitualGathering;
import epicsquid.roots.ritual.RitualGermination;
import epicsquid.roots.ritual.RitualHealingAura;
import epicsquid.roots.ritual.RitualHeavyStorms;
import epicsquid.roots.ritual.RitualOvergrowth;
import epicsquid.roots.ritual.RitualPurity;
import epicsquid.roots.ritual.RitualSpreadingForest;
import epicsquid.roots.ritual.RitualSummonCreatures;
import epicsquid.roots.ritual.RitualTransmutation;
import epicsquid.roots.ritual.RitualWardingProtection;
import epicsquid.roots.ritual.RitualWildGrowth;
import epicsquid.roots.ritual.RitualWindwall;
import epicsquid.roots.tileentity.TileEntityBonfire;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;

public class RitualRegistry {
    public static Map<String, RitualBase> ritualRegistry = new HashMap<String, RitualBase>();
    public static RitualBase ritual_life;
    public static RitualBase ritual_storm;
    public static RitualBase ritual_light;
    public static RitualBase ritual_fire_storm;
    public static RitualBase ritual_regrowth;
    public static RitualBase ritual_windwall;
    public static RitualBase ritual_warden;
    public static RitualBase ritual_natural_aura;
    public static RitualBase ritual_purity;
    public static RitualBase ritual_frost;
    public static RitualBase ritual_animal_harvest;
    public static RitualBase ritual_summoning;
    public static RitualBase ritual_wild_growth;
    public static RitualBase ritual_overgrowth;
    public static RitualBase ritual_flower_growth;
    public static RitualBase ritual_transmutation;
    public static RitualBase ritual_gathering;

    public static RitualBase getRitual(TileEntityBonfire tileEntity, @Nullable EntityPlayer player) {
        for (int i = 0; i < ritualRegistry.size(); ++i) {
            RitualBase ritual = ritualRegistry.values().toArray(new RitualBase[0])[i];
            if (!ritual.isRitualRecipe(tileEntity, player)) continue;
            return ritual;
        }
        return null;
    }

    public static RitualBase getRitual(String ritualName) {
        if (ritualName == null) {
            return null;
        }
        for (RitualBase ritual : ritualRegistry.values()) {
            if (!ritual.getName().equalsIgnoreCase(ritualName)) continue;
            return ritual;
        }
        return null;
    }

    public static void init() {
        ritual_life = new RitualHealingAura("ritual_healing_aura", 800, RitualConfig.disableRitualCategory.disableHealingAura);
        RitualRegistry.addRitual(ritual_life);
        ritual_storm = new RitualHeavyStorms("ritual_heavy_storms", 2400, RitualConfig.disableRitualCategory.disableHeavyStorms);
        RitualRegistry.addRitual(ritual_storm);
        ritual_light = new RitualDivineProtection("ritual_divine_protection", 1200, RitualConfig.disableRitualCategory.disableDivineProtection);
        RitualRegistry.addRitual(ritual_light);
        ritual_fire_storm = new RitualFireStorm("ritual_fire_storm", 1200, RitualConfig.disableRitualCategory.disableFireStorm);
        RitualRegistry.addRitual(ritual_fire_storm);
        ritual_regrowth = new RitualSpreadingForest("ritual_spreading_forest", 2400, RitualConfig.disableRitualCategory.disableNaturalGrowth);
        RitualRegistry.addRitual(ritual_regrowth);
        ritual_windwall = new RitualWindwall("ritual_windwall", 3000, RitualConfig.disableRitualCategory.disableWindwall);
        RitualRegistry.addRitual(ritual_windwall);
        ritual_warden = new RitualWardingProtection("ritual_warding_protection", 1200, RitualConfig.disableRitualCategory.disableWardingProtection);
        RitualRegistry.addRitual(ritual_warden);
        ritual_natural_aura = new RitualGermination("ritual_germination", 6400, RitualConfig.disableRitualCategory.disableNaturalAura);
        RitualRegistry.addRitual(ritual_natural_aura);
        ritual_overgrowth = new RitualOvergrowth("ritual_overgrowth", 3000, RitualConfig.disableRitualCategory.disableOvergrowth);
        RitualRegistry.addRitual(ritual_overgrowth);
        ritual_purity = new RitualPurity("ritual_purity", 1200, RitualConfig.disableRitualCategory.disablePurity);
        RitualRegistry.addRitual(ritual_purity);
        ritual_frost = new RitualFrostLands("ritual_frost_lands", 6400, RitualConfig.disableRitualCategory.disableFrostLands);
        RitualRegistry.addRitual(ritual_frost);
        ritual_animal_harvest = new RitualAnimalHarvest("ritual_animal_harvest", 3200, RitualConfig.disableRitualCategory.disableAnimalHarvest);
        RitualRegistry.addRitual(ritual_animal_harvest);
        ritual_summoning = new RitualSummonCreatures("ritual_summon_creatures", 200, RitualConfig.disableRitualCategory.disableSummonCreatures);
        RitualRegistry.addRitual(ritual_summoning);
        ritual_wild_growth = new RitualWildGrowth("ritual_wild_growth", 300, RitualConfig.disableRitualCategory.disableWildGrowth);
        RitualRegistry.addRitual(ritual_wild_growth);
        ritual_overgrowth = new RitualOvergrowth("ritual_overgrowth", 4500, RitualConfig.disableRitualCategory.disableOvergrowth);
        RitualRegistry.addRitual(ritual_overgrowth);
        ritual_flower_growth = new RitualFlowerGrowth("ritual_flower_growth", 3200, RitualConfig.disableRitualCategory.disableFlowerGrowth);
        RitualRegistry.addRitual(ritual_flower_growth);
        ritual_transmutation = new RitualTransmutation("ritual_transmutation", 2400, RitualConfig.disableRitualCategory.disableTransmutation);
        RitualRegistry.addRitual(ritual_transmutation);
        ritual_gathering = new RitualGathering("ritual_gathering", 6000, RitualConfig.disableRitualCategory.disableGathering);
        RitualRegistry.addRitual(ritual_gathering);
    }

    public static void addRitual(RitualBase ritual) {
        ritualRegistry.put(ritual.getName(), ritual);
    }
}

