/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.roots.spell;

import epicsquid.mysticallib.network.PacketHandler;
import epicsquid.mysticallib.util.Util;
import epicsquid.roots.init.HerbRegistry;
import epicsquid.roots.init.ModItems;
import epicsquid.roots.mechanics.Harvest;
import epicsquid.roots.network.fx.MessageHarvestCompleteFX;
import epicsquid.roots.spell.SpellBase;
import epicsquid.roots.spell.modules.SpellModule;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class SpellHarvest
extends SpellBase {
    public static String spellName = "spell_harvest";
    public static SpellHarvest instance = new SpellHarvest(spellName);
    private static List<Block> skipBlocks = Arrays.asList(Blocks.field_150357_h, Blocks.field_150349_c, Blocks.field_150346_d, Blocks.field_150348_b, Blocks.field_150329_H, Blocks.field_150355_j, Blocks.field_150353_l, Blocks.field_150398_cm, Blocks.field_150394_bc, Blocks.field_150393_bb);

    public SpellHarvest(String name) {
        super(name, TextFormatting.GREEN, 0.22352941f, 0.99215686f, 0.10980392f, 0.77254903f, 0.9137255f, 0.10980392f);
        this.castType = SpellBase.EnumCastType.INSTANTANEOUS;
        this.cooldown = 25;
        this.addCost(HerbRegistry.getHerbByName("wildewheet"), 0.55f);
        this.addIngredients(new ItemStack(Items.field_151013_M), new ItemStack(epicsquid.mysticalworld.init.ModItems.aubergine_seed), new ItemStack(ModItems.wildewheet), new ItemStack(Items.field_185163_cU), new ItemStack(Items.field_151014_N));
    }

    @Override
    public boolean cast(EntityPlayer player, List<SpellModule> modules) {
        Object state;
        Harvest.prepare();
        ArrayList<BlockPos> affectedPositions = new ArrayList<BlockPos>();
        ArrayList pumpkinsAndMelons = new ArrayList();
        ArrayList reedsAndCactus = new ArrayList();
        List crops = Util.getBlocksWithinRadius((World)player.field_70170_p, (BlockPos)player.func_180425_c(), (float)6.0f, (float)5.0f, (float)6.0f, pos -> {
            if (player.field_70170_p.func_175623_d(pos)) {
                return false;
            }
            IBlockState state = player.field_70170_p.func_180495_p(pos);
            Block block = state.func_177230_c();
            if (skipBlocks.contains(block)) {
                return false;
            }
            if (state.func_177230_c() == Blocks.field_150423_aK || state.func_177230_c() == Blocks.field_150440_ba) {
                pumpkinsAndMelons.add(pos);
                return false;
            }
            if (state.func_177230_c() == Blocks.field_150436_aH || state.func_177230_c() == Blocks.field_150434_aF) {
                reedsAndCactus.add(pos);
                return false;
            }
            IProperty<?> prop = Harvest.resolveStates(state);
            if (prop != null) {
                return Harvest.isGrown(state);
            }
            return false;
        });
        int count = 0;
        for (BlockPos pos2 : crops) {
            state = player.field_70170_p.func_180495_p(pos2);
            if (!player.field_70170_p.field_72995_K) {
                Harvest.doHarvest((IBlockState)state, pos2, player.field_70170_p, player);
                affectedPositions.add(pos2);
            }
            ++count;
        }
        for (BlockPos pos2 : pumpkinsAndMelons) {
            ++count;
            if (player.field_70170_p.field_72995_K) continue;
            state = player.field_70170_p.func_180495_p(pos2);
            player.field_70170_p.func_175656_a(pos2, Blocks.field_150350_a.func_176223_P());
            state.func_177230_c().func_180657_a(player.field_70170_p, player, pos2, (IBlockState)state, null, player.func_184614_ca());
            affectedPositions.add(pos2);
        }
        HashSet<BlockPos> done = new HashSet<BlockPos>();
        ArrayList<BlockPos> lowest = new ArrayList<BlockPos>();
        for (BlockPos pos3 : reedsAndCactus) {
            if (done.contains(pos3)) continue;
            BlockPos down = pos3.func_177977_b();
            IBlockState downState = player.field_70170_p.func_180495_p(down);
            while (downState.func_177230_c() == Blocks.field_150434_aF || downState.func_177230_c() == Blocks.field_150436_aH) {
                done.add(down);
                down = down.func_177977_b();
                downState = player.field_70170_p.func_180495_p(down);
            }
            lowest.add(down.func_177984_a());
            done.add(pos3);
        }
        for (BlockPos pos3 : lowest) {
            IBlockState state2 = player.field_70170_p.func_180495_p(pos3.func_177984_a());
            if (state2.func_177230_c() != Blocks.field_150434_aF && state2.func_177230_c() != Blocks.field_150436_aH) continue;
            ++count;
            if (player.field_70170_p.field_72995_K) continue;
            state2.func_177230_c().func_180657_a(player.field_70170_p, player, pos3.func_177984_a(), state2, null, player.func_184614_ca());
            player.field_70170_p.func_175656_a(pos3.func_177984_a(), Blocks.field_150350_a.func_176223_P());
            affectedPositions.add(pos3);
        }
        if (!affectedPositions.isEmpty() && !player.field_70170_p.field_72995_K) {
            MessageHarvestCompleteFX message = new MessageHarvestCompleteFX(affectedPositions);
            PacketHandler.sendToAllTracking((IMessage)message, (Entity)player);
        }
        return count != 0;
    }
}

