/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.roots.util;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraftforge.items.IItemHandler;

public class ItemHandlerUtil {
    public static boolean isEmpty(IItemHandler handler) {
        for (ItemStack stack : new Iterable(handler)) {
            if (stack.func_190926_b()) continue;
            return false;
        }
        return true;
    }

    public static List<ItemStack> getItemsInSlots(IItemHandler handler, Int2ObjectOpenHashMap<IngredientWithStack> slotToIngredients, boolean simulate) {
        ArrayList<ItemStack> result = new ArrayList<ItemStack>();
        int runningCount = 0;
        for (Int2ObjectMap.Entry entry : slotToIngredients.int2ObjectEntrySet()) {
            int slot = entry.getIntKey();
            IngredientWithStack ing = (IngredientWithStack)entry.getValue();
            if (slot < handler.getSlots()) {
                for (int i = 0; i < ing.getCount(); ++i) {
                    result.add(handler.extractItem(slot, 1, simulate));
                    ++runningCount;
                }
            }
            if (runningCount <= 5) continue;
            throw new IllegalStateException("Somehow managed to collect more than 5 ingredients total. This should never happen.");
        }
        result.removeIf(ItemStack::func_190926_b);
        return result;
    }

    public static class IngredientWithStack {
        private final Ingredient ingredient;
        private int count;

        public IngredientWithStack(Ingredient ingredient, int count) {
            this.ingredient = ingredient;
            this.count = count;
        }

        public Ingredient getIngredient() {
            return this.ingredient;
        }

        public int getCount() {
            return this.count;
        }

        public void increment() {
            ++this.count;
        }
    }

    public static class Iterable
    implements java.lang.Iterable<ItemStack> {
        private IItemHandler inventory;
        private SlotIterator iter;

        public Iterable(IItemHandler inventory) {
            this.inventory = inventory;
        }

        @Override
        public Iterator<ItemStack> iterator() {
            this.iter = new SlotIterator();
            return this.iter;
        }

        public int getSlot() {
            return this.iter.cursor;
        }

        public class SlotIterator
        implements Iterator<ItemStack> {
            int cursor;
            int lastRet = -1;
            int size = Iterable.access$000(Iterable.this).getSlots();

            SlotIterator() {
            }

            @Override
            public boolean hasNext() {
                return this.cursor != this.size;
            }

            @Override
            public ItemStack next() {
                int i = this.cursor;
                if (i >= Iterable.this.inventory.getSlots()) {
                    throw new NoSuchElementException();
                }
                this.cursor = i + 1;
                this.lastRet = i;
                return Iterable.this.inventory.getStackInSlot(this.lastRet);
            }
        }
    }
}

